/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyHolder;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Logger;

public class PolicyAlternativeHolder {
    protected static final Logger log = Logger.getLogger("com.sun.xml.wss.provider.wsit", "com.sun.xml.wss.provider.wsit.logging.LogStrings");
    private AssertionSet alternative;
    public HashMap<WSDLBoundOperation, SecurityPolicyHolder> outMessagePolicyMap = null;
    public HashMap<WSDLBoundOperation, SecurityPolicyHolder> inMessagePolicyMap = null;
    public HashMap<String, SecurityPolicyHolder> outProtocolPM = null;
    public HashMap<String, SecurityPolicyHolder> inProtocolPM = null;
    protected Policy bpMSP = null;
    protected SecurityPolicyVersion spVersion;
    private String uuid;

    public PolicyAlternativeHolder(AssertionSet assertions, SecurityPolicyVersion sv, Policy bpMSP) {
        this.alternative = assertions;
        this.spVersion = sv;
        this.bpMSP = bpMSP;
        this.uuid = UUID.randomUUID().toString();
        this.inMessagePolicyMap = new HashMap();
        this.outMessagePolicyMap = new HashMap();
        this.inProtocolPM = new HashMap();
        this.outProtocolPM = new HashMap();
    }

    public void putToOutMessagePolicyMap(WSDLBoundOperation op, SecurityPolicyHolder sh) {
        this.outMessagePolicyMap.put(op, sh);
    }

    public SecurityPolicyHolder getFromOutMessagePolicyMap(WSDLBoundOperation op) {
        return this.outMessagePolicyMap.get(op);
    }

    public void putToInMessagePolicyMap(WSDLBoundOperation op, SecurityPolicyHolder sh) {
        this.inMessagePolicyMap.put(op, sh);
    }

    public SecurityPolicyHolder getFromInMessagePolicyMap(WSDLBoundOperation op) {
        return this.inMessagePolicyMap.get(op);
    }

    public void putToOutProtocolPolicyMap(String protocol, SecurityPolicyHolder sh) {
        this.outProtocolPM.put(protocol, sh);
    }

    public SecurityPolicyHolder getFromOutProtocolPolicyMap(String protocol) {
        return this.outProtocolPM.get(protocol);
    }

    public void putToInProtocolPolicyMap(String protocol, SecurityPolicyHolder sh) {
        this.inProtocolPM.put(protocol, sh);
    }

    public SecurityPolicyHolder getFromInProtocolPolicyMap(String protocol) {
        return this.inProtocolPM.get(protocol);
    }

    public String getId() {
        return this.uuid;
    }
}

