/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.xml.wss.RealmAuthenticationAdapter;
import com.sun.xml.wss.XWSSecurityException;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import javax.security.auth.x500.X500Principal;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultRealmAuthenticationAdapter
extends RealmAuthenticationAdapter {
    private CallbackHandler gfCallbackHandler = null;
    private HashMap<String, String> tomcatUsersXML = null;
    private static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private static String classname = "com.sun.enterprise.security.jmac.callback.ContainerCallbackHandler";

    public DefaultRealmAuthenticationAdapter() {
        if (this.isGlassfish()) {
            this.gfCallbackHandler = this.loadGFHandler();
        } else if (this.isTomcat()) {
            this.populateTomcatUsersXML();
        }
    }

    private boolean isGlassfish() {
        String val = System.getProperty("com.sun.aas.installRoot");
        return val != null;
    }

    private boolean isTomcat() {
        String val = System.getProperty("catalina.home");
        String val1 = System.getProperty("com.sun.aas.installRoot");
        return val1 == null && val != null;
    }

    private boolean authenticateFromTomcatUsersXML(final Subject callerSubject, final String username, String password) throws XWSSecurityException {
        if (this.tomcatUsersXML != null) {
            String pass = this.tomcatUsersXML.get(username);
            if (pass == null) {
                return false;
            }
            if (pass.equals(password)) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        String x500Name = "CN=" + username;
                        X500Principal principal = new X500Principal(x500Name);
                        callerSubject.getPrincipals().add(principal);
                        return null;
                    }
                });
                return true;
            }
            return false;
        }
        throw new XWSSecurityException("Internal Error: Username Authentication Failed: Could not Load/Locate tomcat-users.xml, Possible Cause is Application is Not Running on TOMCAT ?");
    }

    private boolean authenticateWithGFCBH(Subject callerSubject, String username, String password) throws XWSSecurityException {
        if (this.gfCallbackHandler != null) {
            boolean result;
            char[] pwd = password == null ? null : password.toCharArray();
            PasswordValidationCallback pvCallback = new PasswordValidationCallback(callerSubject, username, pwd);
            Callback[] callbacks = new Callback[]{pvCallback};
            try {
                this.gfCallbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                throw new XWSSecurityException(e);
            }
            if (pwd != null) {
                pvCallback.clearPassword();
            }
            if (result = pvCallback.getResult()) {
                CallerPrincipalCallback pCallback = new CallerPrincipalCallback(callerSubject, username);
                callbacks = new Callback[]{pCallback};
                try {
                    this.gfCallbackHandler.handle(callbacks);
                }
                catch (Exception e) {
                    throw new XWSSecurityException(e);
                }
                return result;
            }
            return result;
        }
        throw new XWSSecurityException("Internal Error: Username Authentication Failed: Could not Locate/Load CallbackHandler: " + classname);
    }

    public boolean authenticate(Subject callerSubject, String username, String password) throws XWSSecurityException {
        if (this.isGlassfish()) {
            return this.authenticateWithGFCBH(callerSubject, username, password);
        }
        if (this.isTomcat()) {
            return this.authenticateFromTomcatUsersXML(callerSubject, username, password);
        }
        throw new XWSSecurityException("Error: Could not locate default username validator for the container");
    }

    public boolean authenticate(Subject callerSubject, String username, String passwordDigest, String nonce, String created) throws XWSSecurityException {
        throw new XWSSecurityException("Not Yet Supported: Digest Authentication not yet supported in  DefaultRealmAuthenticationAdapter");
    }

    protected CallbackHandler loadGFHandler() {
        Class<?> ret = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                if (loader != null) {
                    ret = loader.loadClass(classname);
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (ret == null) {
                loader = this.getClass().getClassLoader();
                ret = loader.loadClass(classname);
            }
            if (ret != null) {
                CallbackHandler handler = (CallbackHandler)ret.newInstance();
                return handler;
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    private void populateTomcatUsersXML() {
        String catalinaHome = System.getProperty("catalina.home");
        String tomcat_user_xml = catalinaHome + File.separator + "conf" + File.separator + "tomcat-users.xml";
        try {
            File tomcatUserXML = new File(tomcat_user_xml);
            if (!tomcatUserXML.exists()) {
                return;
            }
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(tomcatUserXML);
            NodeList nl = doc.getElementsByTagName("user");
            this.tomcatUsersXML = new HashMap();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                NamedNodeMap nmap = n.getAttributes();
                Node un = nmap.getNamedItem("username");
                if (un == null) {
                    un = nmap.getNamedItem("name");
                }
                Node pn = nmap.getNamedItem("password");
                this.tomcatUsersXML.put(un.getNodeValue(), pn.getNodeValue());
            }
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException ie) {
            throw new RuntimeException(ie);
        }
    }
}

