/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.api;

import com.sun.xml.ws.rx.rm.api.ReliableMessagingFeature;
import com.sun.xml.ws.rx.rm.api.RmProtocolVersion;

public final class ReliableMessagingFeatureBuilder {
    private final RmProtocolVersion protocolVersion;
    private boolean enabled = true;
    private long inactivityTimeout = 600000L;
    private long destinationBufferQuota = 32L;
    private boolean orderedDelivery = false;
    private ReliableMessagingFeature.DeliveryAssurance deliveryAssurance = ReliableMessagingFeature.DeliveryAssurance.getDefault();
    private ReliableMessagingFeature.SecurityBinding securityBinding = ReliableMessagingFeature.SecurityBinding.getDefault();
    private long messageRetransmissionInterval = 2000L;
    private ReliableMessagingFeature.BackoffAlgorithm retransmissionBackoffAlgorithm = ReliableMessagingFeature.BackoffAlgorithm.getDefault();
    private long maxMessageRetransmissionCount = 0L;
    private long maxRmSessionControlMessageResendAttempts = 3L;
    private long ackTransmittionInterval = -1L;
    private long ackRequestTransmissionInterval = 2000L;
    private long closeSequenceOperationTimeout = 3000L;
    private boolean persistenceEnabled = false;
    private long sequenceMaintenancePeriod = 60000L;
    private long maxConcurrentSessions = -1L;

    public ReliableMessagingFeatureBuilder(RmProtocolVersion version) {
        this.protocolVersion = version;
    }

    public ReliableMessagingFeature build() {
        return new ReliableMessagingFeature(this.enabled, this.protocolVersion, this.inactivityTimeout, this.destinationBufferQuota, this.orderedDelivery, this.deliveryAssurance, this.securityBinding, this.messageRetransmissionInterval, this.retransmissionBackoffAlgorithm, this.maxMessageRetransmissionCount, this.maxRmSessionControlMessageResendAttempts, this.ackTransmittionInterval, this.ackRequestTransmissionInterval, this.closeSequenceOperationTimeout, this.persistenceEnabled, this.sequenceMaintenancePeriod, this.maxConcurrentSessions);
    }

    public ReliableMessagingFeatureBuilder acknowledgementTransmittionInterval(long value) {
        this.ackTransmittionInterval = value;
        return this;
    }

    public ReliableMessagingFeatureBuilder ackRequestTransmissionInterval(long value) {
        this.ackRequestTransmissionInterval = value;
        return this;
    }

    public ReliableMessagingFeatureBuilder messageRetransmissionInterval(long value) {
        this.messageRetransmissionInterval = value;
        return this;
    }

    public ReliableMessagingFeatureBuilder retransmissionBackoffAlgorithm(ReliableMessagingFeature.BackoffAlgorithm value) {
        this.retransmissionBackoffAlgorithm = value;
        return this;
    }

    public ReliableMessagingFeatureBuilder maxMessageRetransmissionCount(long value) {
        this.maxMessageRetransmissionCount = value;
        return this;
    }

    public ReliableMessagingFeatureBuilder maxRmSessionControlMessageResendAttempts(long value) {
        this.maxRmSessionControlMessageResendAttempts = value;
        return this;
    }

    public ReliableMessagingFeatureBuilder destinationBufferQuota(long value) {
        this.destinationBufferQuota = value;
        return this;
    }

    public ReliableMessagingFeatureBuilder closeSequenceOperationTimeout(long value) {
        this.closeSequenceOperationTimeout = value;
        return this;
    }

    public ReliableMessagingFeatureBuilder deliveryAssurance(ReliableMessagingFeature.DeliveryAssurance value) {
        this.deliveryAssurance = value;
        return this;
    }

    public ReliableMessagingFeatureBuilder sequenceInactivityTimeout(long value) {
        this.inactivityTimeout = value;
        return this;
    }

    public ReliableMessagingFeatureBuilder enableOrderedDelivery() {
        this.orderedDelivery = true;
        return this;
    }

    public RmProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public ReliableMessagingFeatureBuilder securityBinding(ReliableMessagingFeature.SecurityBinding value) {
        this.securityBinding = value;
        return this;
    }

    public ReliableMessagingFeatureBuilder enablePersistence() {
        this.persistenceEnabled = true;
        return this;
    }

    public ReliableMessagingFeatureBuilder disablePersistence() {
        this.persistenceEnabled = false;
        return this;
    }

    public ReliableMessagingFeatureBuilder sequenceMaintenancePeriod(long value) {
        this.sequenceMaintenancePeriod = value;
        return this;
    }

    public ReliableMessagingFeatureBuilder maxConcurrentSessions(long value) {
        this.maxConcurrentSessions = value;
        return this;
    }
}

