/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.policy.mls;

import javax.xml.namespace.QName;

public class Target {
    protected static final String TARGET_VALUE_SOAP_BODY = "SOAP-BODY";
    public static final String TARGET_TYPE_VALUE_QNAME = "qname";
    public static final String TARGET_TYPE_VALUE_XPATH = "xpath";
    public static final String TARGET_TYPE_VALUE_URI = "uri";
    public static final String ALL_MESSAGE_HEADERS = "ALL_MESSAGE_HEADERS";
    public static final String BODY = "{http://schemas.xmlsoap.org/soap/envelope/}Body";
    public static final String BODY1_2 = "{http://www.w3.org/2003/05/soap-envelope}Body";
    public static final QName BODY_QNAME = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body");
    public static final QName SIGNATURE_CONFIRMATION = new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "SignatureConfirmation");
    private String type = "qname";
    private String value = "{http://schemas.xmlsoap.org/soap/envelope/}Body";
    private boolean contentOnly = true;
    private boolean enforce = true;
    private String xpathExpr = null;
    private QName qname = null;
    private boolean attachment = false;
    boolean bsp = false;
    boolean headersOnly = false;
    private String xpathVersion;
    private QName policyQName = null;

    public Target() {
    }

    public Target(String type, String value) {
        this.type = type;
        this.value = value;
        if (TARGET_TYPE_VALUE_QNAME.equals(type) && TARGET_VALUE_SOAP_BODY.equals(value)) {
            this.value = BODY;
        }
    }

    public Target(String type, String value, boolean contentOnly) {
        this.type = type;
        this.value = value;
        this.contentOnly = contentOnly;
        if (TARGET_TYPE_VALUE_QNAME.equals(type) && TARGET_VALUE_SOAP_BODY.equals(value)) {
            this.value = BODY;
        }
    }

    public Target(String type, String value, boolean contentOnly, boolean enforce) {
        this.type = type;
        this.value = value;
        this.contentOnly = contentOnly;
        this.enforce = enforce;
        if (TARGET_TYPE_VALUE_QNAME.equals(type) && TARGET_VALUE_SOAP_BODY.equals(value)) {
            this.value = BODY;
        }
    }

    public void setEnforce(boolean enforce) {
        this.enforce = enforce;
    }

    public boolean getEnforce() {
        return this.enforce;
    }

    public void isSOAPHeadersOnly(boolean headersOnly) {
        this.headersOnly = headersOnly;
    }

    public boolean isSOAPHeadersOnly() {
        return this.headersOnly;
    }

    public void isBSP(boolean flag) {
        this.bsp = flag;
    }

    public boolean isBSP() {
        return this.bsp;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.xpathExpr = null;
        if (BODY1_2.equals(value) || BODY.equals(value)) {
            this.value = BODY;
        }
        if (TARGET_TYPE_VALUE_QNAME.equals(this.type) && TARGET_VALUE_SOAP_BODY.equals(value)) {
            this.value = BODY;
        }
        if (value != null && (value.startsWith("cid:") || value.startsWith("attachmentRef:"))) {
            this.attachment = true;
            if (value.equals("cid:*")) {
                this.value = "cid:*";
            }
        }
    }

    public void setContentOnly(boolean contentOnly) {
        this.contentOnly = contentOnly;
    }

    public boolean getContentOnly() {
        return this.contentOnly;
    }

    public String convertToXPATH() {
        if (this.xpathExpr == null) {
            this.xpathExpr = this.convertToXpath(this.value);
        }
        return this.xpathExpr;
    }

    private String convertToXpath(String qname) {
        QName name = QName.valueOf(qname);
        if ("".equals(name.getNamespaceURI())) {
            return "//" + name.getLocalPart();
        }
        return "//*[local-name()='" + name.getLocalPart() + "' and namespace-uri()='" + name.getNamespaceURI() + "']";
    }

    public void setQName(QName qname) {
        this.type = TARGET_TYPE_VALUE_QNAME;
        this.value = qname.toString();
        this.qname = qname;
        this.value = qname.toString();
    }

    public QName getQName() {
        if (this.type != TARGET_TYPE_VALUE_QNAME) {
            return null;
        }
        if (this.qname == null && this.value != null) {
            this.qname = QName.valueOf(this.value);
        }
        return this.qname;
    }

    public boolean isAttachment() {
        return this.attachment;
    }

    public String getXPathVersion() {
        return this.xpathVersion;
    }

    public void setXPathVersion(String version) {
        this.xpathVersion = version;
    }

    public void setPolicyName(QName policyQName) {
        this.policyQName = policyQName;
    }

    public QName getPolicyQName() {
        return this.policyQName;
    }
}

