/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.evt;

import com.ctc.wstx.cfg.OutputConfigFlags;
import com.ctc.wstx.sw.BaseStreamWriter;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class WstxEventWriter
implements XMLEventWriter,
XMLStreamConstants,
OutputConfigFlags {
    final XMLStreamWriter mWriter;
    final BaseStreamWriter mWstxWriter;

    public WstxEventWriter(XMLStreamWriter sw) {
        this.mWriter = sw;
        this.mWstxWriter = sw instanceof BaseStreamWriter ? (BaseStreamWriter)sw : null;
    }

    public void add(XMLEvent event) throws XMLStreamException {
        switch (event.getEventType()) {
            case 10: {
                Attribute attr = (Attribute)event;
                QName name = attr.getName();
                this.mWriter.writeAttribute(name.getPrefix(), name.getNamespaceURI(), name.getLocalPart(), attr.getValue());
                break;
            }
            case 8: {
                this.mWriter.writeEndDocument();
                break;
            }
            case 2: {
                if (this.mWstxWriter != null) {
                    this.mWstxWriter.writeEndElement(event.asEndElement().getName());
                    break;
                }
                this.mWriter.writeEndElement();
                break;
            }
            case 13: {
                Namespace ns = (Namespace)event;
                this.mWriter.writeNamespace(ns.getPrefix(), ns.getNamespaceURI());
                break;
            }
            case 7: {
                StartDocument sd = (StartDocument)event;
                if (!sd.encodingSet()) {
                    this.mWriter.writeStartDocument(sd.getVersion());
                    break;
                }
                this.mWriter.writeStartDocument(sd.getCharacterEncodingScheme(), sd.getVersion());
                break;
            }
            case 1: {
                StartElement se = event.asStartElement();
                if (this.mWstxWriter != null) {
                    this.mWstxWriter.writeStartElement(se);
                    break;
                }
                QName n = se.getName();
                this.mWriter.writeStartElement(n.getPrefix(), n.getLocalPart(), n.getNamespaceURI());
                Iterator it = se.getNamespaces();
                while (it.hasNext()) {
                    Namespace ns = (Namespace)it.next();
                    this.add(ns);
                }
                it = se.getAttributes();
                while (it.hasNext()) {
                    Attribute attr = (Attribute)it.next();
                    this.add(attr);
                }
                break;
            }
            case 4: {
                Characters ch = event.asCharacters();
                String text = ch.getData();
                if (ch.isCData()) {
                    this.mWriter.writeCData(text);
                    break;
                }
                this.mWriter.writeCharacters(text);
                break;
            }
            case 5: {
                this.mWriter.writeComment(((Comment)event).getText());
                break;
            }
            case 11: {
                this.mWriter.writeDTD(((DTD)event).getDocumentTypeDeclaration());
                break;
            }
            case 9: {
                this.mWriter.writeEntityRef(((EntityReference)event).getName());
                break;
            }
            case 3: {
                ProcessingInstruction pi = (ProcessingInstruction)event;
                this.mWriter.writeProcessingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            default: {
                if (this.mWstxWriter != null) {
                    event.writeAsEncodedUnicode(this.mWstxWriter.wrapAsRawWriter());
                    break;
                }
                throw new XMLStreamException("Unrecognized event type (" + event.getEventType() + "), for XMLEvent of type " + event.getClass());
            }
        }
    }

    public void add(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            this.add(reader.nextEvent());
        }
    }

    public void close() throws XMLStreamException {
        this.mWriter.close();
    }

    public void flush() throws XMLStreamException {
        this.mWriter.flush();
    }

    public NamespaceContext getNamespaceContext() {
        return this.mWriter.getNamespaceContext();
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this.mWriter.getPrefix(uri);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.mWriter.setDefaultNamespace(uri);
    }

    public void setNamespaceContext(NamespaceContext ctxt) throws XMLStreamException {
        this.mWriter.setNamespaceContext(ctxt);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.mWriter.setPrefix(prefix, uri);
    }
}

