/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.policy.assertion.metro.rm200702;

import com.sun.istack.NotNull;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.ComplexAssertion;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.policy.spi.AssertionCreationException;
import com.sun.xml.ws.rx.policy.assertion.AssertionInstantiator;
import com.sun.xml.ws.rx.policy.assertion.AssertionNamespace;
import com.sun.xml.ws.rx.policy.assertion.RmConfigurator;
import com.sun.xml.ws.rx.rm.ReliableMessagingFeature;
import com.sun.xml.ws.rx.rm.ReliableMessagingFeatureBuilder;
import com.sun.xml.ws.rx.rm.RmVersion;
import java.util.Collection;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetransmissionConfigAssertion
extends ComplexAssertion
implements RmConfigurator {
    public static final QName NAME = AssertionNamespace.METRO_200702.getQName("RetransmissionConfig");
    private static final Logger LOGGER = Logger.getLogger(RetransmissionConfigAssertion.class);
    private static final QName INTERVAL_PARAMETER_QNAME = AssertionNamespace.METRO_200702.getQName("Interval");
    private static final QName ALGORITHM_PARAMETER_QNAME = AssertionNamespace.METRO_200702.getQName("Algorithm");
    private static final QName MAX_RETRIES_PARAMETER_QNAME = AssertionNamespace.METRO_200702.getQName("MaxRetries");
    private static final QName MILLISECONDS_ATTRIBUTE_QNAME = new QName("", "Milliseconds");
    private static AssertionInstantiator instantiator = new AssertionInstantiator(){

        @Override
        public PolicyAssertion newInstance(AssertionData data, Collection<PolicyAssertion> assertionParameters, AssertionSet nestedAlternative) throws AssertionCreationException {
            return new RetransmissionConfigAssertion(data, assertionParameters, nestedAlternative);
        }
    };
    private final long interval;
    private final long maxRetries;
    private final ReliableMessagingFeature.BackoffAlgorithm algorithm;

    public static AssertionInstantiator getInstantiator() {
        return instantiator;
    }

    private RetransmissionConfigAssertion(AssertionData data, Collection<? extends PolicyAssertion> assertionParameters, AssertionSet nestedAlternative) throws AssertionCreationException {
        super(data, assertionParameters, nestedAlternative);
        if (assertionParameters == null || assertionParameters.isEmpty()) {
            throw new AssertionCreationException(data, "No assertion parameters found.");
        }
        PolicyAssertion _interval = RetransmissionConfigAssertion.getParameter(INTERVAL_PARAMETER_QNAME, data, assertionParameters);
        this.interval = _interval == null ? 2000L : Long.parseLong(_interval.getAttributeValue(MILLISECONDS_ATTRIBUTE_QNAME));
        PolicyAssertion _maxRetries = RetransmissionConfigAssertion.getParameter(MAX_RETRIES_PARAMETER_QNAME, data, assertionParameters);
        this.maxRetries = _maxRetries == null ? -1L : Long.parseLong(_maxRetries.getValue());
        PolicyAssertion algorithmParameter = RetransmissionConfigAssertion.getParameter(ALGORITHM_PARAMETER_QNAME, data, assertionParameters);
        ReliableMessagingFeature.BackoffAlgorithm _algorithm = algorithmParameter == null ? null : ReliableMessagingFeature.BackoffAlgorithm.parse(algorithmParameter.getValue());
        this.algorithm = _algorithm == null ? ReliableMessagingFeature.BackoffAlgorithm.getDefault() : _algorithm;
    }

    private static PolicyAssertion getParameter(@NotNull QName parameterName, AssertionData data, @NotNull Collection<? extends PolicyAssertion> assertionParameters) throws AssertionCreationException {
        assert (parameterName != null);
        assert (assertionParameters != null);
        PolicyAssertion parameter = null;
        boolean parameterSet = false;
        for (PolicyAssertion policyAssertion : assertionParameters) {
            if (!parameterName.equals(policyAssertion.getName())) continue;
            if (parameterSet) {
                throw LOGGER.logSevereException(new AssertionCreationException(data, String.format("Multiple occurences of assertion parameter [ %s ] detected in the policy assertion [ %s ]", parameterName, NAME)));
            }
            parameter = policyAssertion;
        }
        return parameter;
    }

    public ReliableMessagingFeature.BackoffAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public ReliableMessagingFeatureBuilder update(ReliableMessagingFeatureBuilder builder) {
        return builder.messageRetransmissionInterval(this.interval).retransmissionBackoffAlgorithm(this.algorithm).maxMessageRetransmissionCount(this.maxRetries);
    }

    @Override
    public boolean isCompatibleWith(RmVersion version) {
        return RmVersion.WSRM200702 == version;
    }
}

