/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management.persistence;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.config.management.ConfigSaver;
import com.sun.xml.ws.api.config.management.ManagedEndpoint;
import com.sun.xml.ws.api.config.management.NamedParameters;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.config.management.ManagementUtil;
import com.sun.xml.ws.config.management.policy.ManagedServiceAssertion;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import javax.sql.DataSource;
import javax.xml.ws.WebServiceException;

public class JDBCConfigSaver
implements ConfigSaver {
    private static final Logger LOGGER = Logger.getLogger(JDBCConfigSaver.class);

    public void persist(NamedParameters parameters) {
        Connection connection = null;
        DataSource source = null;
        try {
            ManagedEndpoint endpoint = (ManagedEndpoint)parameters.get("ENDPOINT_INSTANCE");
            ManagedServiceAssertion assertion = ManagementUtil.getAssertion(endpoint);
            source = ManagementUtil.getManagementDS(assertion.getJDBCDataSourceName());
            connection = source.getConnection();
            String newConfig = (String)parameters.get("CONFIGURATION_DATA");
            JDBCConfigSaver.writeData(connection, endpoint.getId(), newConfig);
        }
        catch (SQLException e) {
            throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_5021_NO_DB_CONNECT(source), (Throwable)e));
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                LOGGER.warning(ManagementMessages.WSM_5022_NO_DB_CLOSE(connection), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeData(Connection connection, String endpointId, String config) {
        PreparedStatement updateStatement = null;
        Statement insertStatement = null;
        try {
            int rowCount;
            String update = "UPDATE METRO_CONFIG SET version = version + 1, config = ? WHERE id = ?";
            updateStatement = connection.prepareStatement("UPDATE METRO_CONFIG SET version = version + 1, config = ? WHERE id = ?");
            updateStatement.setCharacterStream(1, (Reader)new StringReader(config), config.length());
            updateStatement.setString(2, endpointId);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(ManagementMessages.WSM_5023_EXECUTE_SQL("UPDATE METRO_CONFIG SET version = version + 1, config = ? WHERE id = ?"));
            }
            if ((rowCount = updateStatement.executeUpdate()) != 0) return;
            String insert = "INSERT INTO METRO_CONFIG (id, version, config) VALUES (?, 1, ?)";
            insertStatement = connection.prepareStatement("INSERT INTO METRO_CONFIG (id, version, config) VALUES (?, 1, ?)");
            insertStatement.setString(1, endpointId);
            insertStatement.setCharacterStream(2, new StringReader(config), config.length());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(ManagementMessages.WSM_5024_EXECUTE_SQL_UPDATE("INSERT INTO METRO_CONFIG (id, version, config) VALUES (?, 1, ?)"));
            }
            insertStatement.executeUpdate();
            return;
        }
        catch (SQLException e) {
            throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_5025_SQL_FAILED(), (Throwable)e));
        }
        finally {
            try {
                if (updateStatement != null) {
                    updateStatement.close();
                }
            }
            catch (SQLException e) {
                LOGGER.warning(ManagementMessages.WSM_5026_FAILED_STATEMENT_CLOSE(updateStatement), e);
            }
            finally {
                try {
                    if (insertStatement != null) {
                        insertStatement.close();
                    }
                }
                catch (SQLException e) {
                    LOGGER.warning(ManagementMessages.WSM_5026_FAILED_STATEMENT_CLOSE(insertStatement), e);
                }
            }
        }
    }
}

