/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jvnet.wom.api.WSDLFault;
import org.jvnet.wom.api.WSDLInput;
import org.jvnet.wom.api.WSDLOperation;
import org.jvnet.wom.api.WSDLOutput;
import org.jvnet.wom.api.WSDLPart;
import org.jvnet.wom.api.WSDLPortType;
import org.jvnet.wom.api.WSDLVisitor;
import org.jvnet.wom.impl.WSDLFaultImpl;
import org.jvnet.wom.impl.WSDLInputImpl;
import org.jvnet.wom.impl.WSDLOutputImpl;
import org.jvnet.wom.impl.parser.WSDLDocumentImpl;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLOperationImpl
extends WSDLOperation {
    private Set<WSDLFaultImpl> faults = new HashSet<WSDLFaultImpl>();
    private WSDLInputImpl input;
    private WSDLOutputImpl output;
    private WSDLPortType parent;
    private String doc;
    private List<String> paramOrder = new ArrayList<String>();

    public WSDLOperationImpl(Locator locator, QName name, WSDLDocumentImpl document) {
        super(locator, name);
        this.setOwnerWSDLDocument(document);
    }

    @Override
    public WSDLInput getInput() {
        return this.input;
    }

    @Override
    public WSDLOutput getOutput() {
        return this.output;
    }

    @Override
    public boolean isOneWay() {
        return this.output == null;
    }

    public final Iterable<WSDLFaultImpl> getFaults() {
        return this.faults;
    }

    @Override
    public WSDLFault getFault(QName faultDetailName) {
        for (WSDLFaultImpl f : this.faults) {
            for (WSDLPart part : f.getMessage().parts()) {
                if (!part.getDescriptor().name().equals(faultDetailName)) continue;
                return f;
            }
        }
        return null;
    }

    public void addFault(WSDLFaultImpl fault) {
        this.faults.add(fault);
    }

    @Override
    public WSDLPortType getPortType() {
        return this.parent;
    }

    @Override
    public List<String> getParameterOrder() {
        return Collections.unmodifiableList(this.paramOrder);
    }

    public void setParameterOrder(String[] paramOrder) {
        assert (this.paramOrder.isEmpty());
        for (String param : paramOrder) {
            this.paramOrder.add(param);
        }
    }

    public void setInput(WSDLInputImpl input) {
        this.input = input;
    }

    public void setOutput(WSDLOutputImpl output) {
        this.output = output;
    }

    public void setParent(WSDLPortType parent) {
        this.parent = parent;
    }

    public void setDocumentation(String doc) {
        this.doc = doc;
    }

    @Override
    public String getDocumentation() {
        return this.doc;
    }

    @Override
    public <V, P> V visit(WSDLVisitor<V, P> visitor, P param) {
        return visitor.operation(this, param);
    }
}

