/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.tools.argparser;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.gmbal.generic.Pair;
import org.glassfish.gmbal.generic.UnaryFunction;
import org.glassfish.gmbal.tools.argparser.ElementParser;
import org.glassfish.gmbal.tools.argparser.Separator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementParserImpl
implements ElementParser {
    private UnaryFunction<String, Object> func;
    private String[] description;
    private static final UnaryFunction<String, Object> booleanParser = new BooleanParser();
    private static final UnaryFunction<String, Object> byteParser = new ByteParser();
    private static final UnaryFunction<String, Object> charParser = new CharParser();
    private static final UnaryFunction<String, Object> shortParser = new ShortParser();
    private static final UnaryFunction<String, Object> integerParser = new IntegerParser();
    private static final UnaryFunction<String, Object> longParser = new LongParser();
    private static final UnaryFunction<String, Object> floatParser = new FloatParser();
    private static final UnaryFunction<String, Object> doubleParser = new DoubleParser();

    @Override
    public Object evaluate(String str) {
        return this.func.evaluate(str);
    }

    @Override
    public String[] describe() {
        return (String[])this.description.clone();
    }

    public ElementParserImpl(Method m) {
        ResultData result = this.getData(m);
        this.func = (UnaryFunction)result.first();
        this.description = (String[])result.second();
    }

    String[] append(String str, String[] strs) {
        String[] result = new String[strs.length + 1];
        int rctr = 0;
        result[rctr++] = str;
        for (String s : strs) {
            result[rctr++] = s;
        }
        return result;
    }

    private ResultData getData(Method meth) {
        UnaryFunction<String, Object> lfunc;
        String[] ldesc;
        Class<?> type = meth.getReturnType();
        if (type.isArray()) {
            final String sep = this.getSeparator(meth);
            final Class<?> elementClass = type.getComponentType();
            final ResultData elementResultData = this.getSimpleData(elementClass);
            ldesc = this.append("A " + sep + "-separated list of ", (String[])elementResultData.second());
            lfunc = new UnaryFunction<String, Object>(){

                @Override
                public Object evaluate(String value) {
                    String[] elements = value.split(sep);
                    Object result = Array.newInstance(elementClass, elements.length);
                    int ctr = 0;
                    for (String str : elements) {
                        Object val = ((UnaryFunction)elementResultData.first()).evaluate(str);
                        Array.set(result, ctr++, val);
                    }
                    return result;
                }
            };
        } else if (type.equals(List.class)) {
            final String sep = this.getSeparator(meth);
            Class elementClass = this.getListElementClass(meth);
            final ResultData elementResultData = this.getSimpleData(elementClass);
            ldesc = this.append("A " + sep + "-separated list of ", (String[])elementResultData.second());
            lfunc = new UnaryFunction<String, Object>(){

                @Override
                public Object evaluate(String value) {
                    String[] elements = value.split(sep);
                    ArrayList result = new ArrayList(elements.length);
                    for (String str : elements) {
                        Object val = ((UnaryFunction)elementResultData.first()).evaluate(str);
                        result.add(val);
                    }
                    return result;
                }
            };
        } else {
            return this.getSimpleData(type);
        }
        return new ResultData(lfunc, ldesc);
    }

    private ResultData getSimpleData(final Class type) {
        UnaryFunction<String, Object> lfunc;
        String[] ldescription;
        if (type.isPrimitive()) {
            ldescription = new String[]{"A valid " + type.getName()};
            lfunc = this.getPrimitiveParser(type);
        } else if (type == String.class) {
            ldescription = new String[]{"A String"};
            lfunc = new UnaryFunction<String, Object>(){

                @Override
                public Object evaluate(String str) {
                    return str;
                }
            };
        } else if (type.isEnum()) {
            ldescription = new String[]{"One of: " + this.getEnumElements(type)};
            lfunc = new UnaryFunction<String, Object>(){

                @Override
                public Object evaluate(String str) {
                    try {
                        return Enum.valueOf(type, str);
                    }
                    catch (IllegalArgumentException exc) {
                        throw new RuntimeException(str + " is not in enum " + type.getName(), exc);
                    }
                }
            };
        } else {
            ldescription = new String[]{"A string that can create a " + type.getName()};
            lfunc = this.makeClassConverter(type);
        }
        return new ResultData(lfunc, ldescription);
    }

    private String getEnumElements(Class cls) {
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder();
        for (Object obj : cls.getEnumConstants()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(' ');
            }
            sb.append(obj.toString());
        }
        return sb.toString();
    }

    private UnaryFunction<String, Object> getPrimitiveParser(Class type) {
        UnaryFunction<String, Object> lfunc = null;
        if (type == Boolean.TYPE) {
            lfunc = booleanParser;
        } else if (type == Byte.TYPE) {
            lfunc = byteParser;
        } else if (type == Character.TYPE) {
            lfunc = charParser;
        } else if (type == Short.TYPE) {
            lfunc = shortParser;
        } else if (type == Integer.TYPE) {
            lfunc = integerParser;
        } else if (type == Long.TYPE) {
            lfunc = longParser;
        } else if (type == Float.TYPE) {
            lfunc = floatParser;
        } else if (type == Double.TYPE) {
            lfunc = doubleParser;
        }
        return lfunc;
    }

    private UnaryFunction<String, Object> makeClassConverter(final Class type) {
        Constructor cons;
        try {
            cons = type.getConstructor(String.class);
        }
        catch (NoSuchMethodException e1) {
            throw new RuntimeException(type.getName() + " does not have a constructor (String)", e1);
        }
        catch (SecurityException e2) {
            throw new RuntimeException(type.getName() + " constructor (String) is not accessible", e2);
        }
        final Constructor fcons = cons;
        return new UnaryFunction<String, Object>(){

            @Override
            public Object evaluate(String str) {
                try {
                    return fcons.newInstance(str);
                }
                catch (InvocationTargetException e1) {
                    throw new RuntimeException(type.getName() + "(String) constructor threw exception: " + e1.getTargetException(), e1);
                }
                catch (Exception e2) {
                    throw new RuntimeException("Exception " + e2 + " occured in calling constructor " + type.getName() + "(String)", e2);
                }
            }
        };
    }

    private Class getListElementClass(Method meth) {
        Type rtype = meth.getGenericReturnType();
        if (rtype instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)rtype;
            Type[] typeArgs = ptype.getActualTypeArguments();
            assert (typeArgs.length == 1);
            Type etype = typeArgs[0];
            if (etype instanceof Class) {
                return (Class)etype;
            }
            throw new RuntimeException("Method " + meth + " has a List<> return type " + " that is not parameterized by a class");
        }
        throw new RuntimeException("Method " + meth + " does not have a parameterized List return type");
    }

    private String getSeparator(Method meth) {
        Separator sep = meth.getAnnotation(Separator.class);
        String result = ",";
        if (sep != null) {
            result = sep.value();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleParser
    implements UnaryFunction<String, Object> {
        private DoubleParser() {
        }

        @Override
        public Object evaluate(String str) {
            return Double.valueOf(str);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FloatParser
    implements UnaryFunction<String, Object> {
        private FloatParser() {
        }

        @Override
        public Object evaluate(String str) {
            return Float.valueOf(str);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongParser
    implements UnaryFunction<String, Object> {
        private LongParser() {
        }

        @Override
        public Object evaluate(String str) {
            return Long.valueOf(str);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerParser
    implements UnaryFunction<String, Object> {
        private IntegerParser() {
        }

        @Override
        public Object evaluate(String str) {
            return Integer.valueOf(str);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShortParser
    implements UnaryFunction<String, Object> {
        private ShortParser() {
        }

        @Override
        public Object evaluate(String str) {
            return Short.valueOf(str);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharParser
    implements UnaryFunction<String, Object> {
        private CharParser() {
        }

        @Override
        public Object evaluate(String str) {
            if (str.length() != 1) {
                throw new RuntimeException("String \"" + str + "\" cannot be converted to a Character");
            }
            return Character.valueOf(str.charAt(0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByteParser
    implements UnaryFunction<String, Object> {
        private ByteParser() {
        }

        @Override
        public Object evaluate(String str) {
            return Byte.valueOf(str);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanParser
    implements UnaryFunction<String, Object> {
        private BooleanParser() {
        }

        @Override
        public Object evaluate(String str) {
            return Boolean.valueOf(str);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultData
    extends Pair<UnaryFunction<String, Object>, String[]> {
        public ResultData(UnaryFunction<String, Object> func, String[] desc) {
            super(func, desc);
        }
    }
}

