/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.security.core.ai.IdentityType;
import com.sun.xml.security.core.ai.ObjectFactory;
import com.sun.xml.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.server.EndpointComponent;
import com.sun.xml.ws.api.server.EndpointReferenceExtensionContributor;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.ws.security.secext10.BinarySecurityTokenType;
import com.sun.xml.wss.jaxws.impl.TubeConfiguration;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityComponent
implements EndpointComponent {
    protected TubeConfiguration pipeConfig = null;
    protected PolicyMap pm = null;
    protected WSEndpoint e = null;
    protected Map props = null;
    private Certificate cs = null;
    protected SOAPVersion sp = null;
    protected static final Logger log = Logger.getLogger("com.sun.xml.wss.provider.wsit", "com.sun.xml.wss.provider.wsit.logging.LogStrings");

    public IdentityComponent(Certificate cs) {
        this.cs = cs;
    }

    @Override
    public <T> T getSPI(@NotNull Class<T> spiType) {
        if (spiType.isAssignableFrom(EndpointReferenceExtensionContributor.class)) {
            return (T)new IdentityEPRExtnContributor();
        }
        return null;
    }

    public XMLStreamReader readHeader(IdentityType identityElem) throws XMLStreamException {
        XMLStreamBufferResult xbr = new XMLStreamBufferResult();
        JAXBElement<IdentityType> idElem = new ObjectFactory().createIdentity(identityElem);
        try {
            JAXBContext context = JAXBUtil.getJAXBContext();
            Marshaller m = context.createMarshaller();
            m.setProperty("com.sun.xml.bind.xmlDeclaration", (Object)false);
            m.marshal(idElem, (Result)xbr);
        }
        catch (JAXBException je) {
            log.log(Level.SEVERE, null, je);
            throw new XMLStreamException(je);
        }
        return xbr.getXMLStreamBuffer().readAsXMLStreamReader();
    }

    public class IdentityEPRExtnContributor
    extends EndpointReferenceExtensionContributor {
        QName ID_QNAME = new QName("http://schemas.xmlsoap.org/ws/2006/02/addressingidentity", "Identity");

        public WSEndpointReference.EPRExtension getEPRExtension(WSEndpoint endpoint, @Nullable WSEndpointReference.EPRExtension extension) {
            if (extension != null) {
                return extension;
            }
            return new WSEndpointReference.EPRExtension(){

                public XMLStreamReader readAsXMLStreamReader() throws XMLStreamException {
                    XMLStreamReader reader = null;
                    try {
                        String id = PolicyUtil.randomUUID();
                        BinarySecurityTokenType bst = new BinarySecurityTokenType();
                        bst.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
                        bst.setId(id);
                        bst.setEncodingType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
                        if (IdentityComponent.this.cs != null) {
                            bst.setValue(IdentityComponent.this.cs.getEncoded());
                        }
                        JAXBElement<BinarySecurityTokenType> bstElem = new com.sun.xml.ws.security.secext10.ObjectFactory().createBinarySecurityToken(bst);
                        IdentityType identityElement = new IdentityType();
                        identityElement.getDnsOrSpnOrUpn().add(bstElem);
                        reader = IdentityComponent.this.readHeader(identityElement);
                    }
                    catch (CertificateEncodingException ex) {
                        log.log(Level.SEVERE, null, ex);
                        throw new RuntimeException(ex);
                    }
                    return reader;
                }

                public QName getQName() {
                    return IdentityEPRExtnContributor.this.ID_QNAME;
                }
            };
        }

        public QName getQName() {
            return this.ID_QNAME;
        }
    }
}

