/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.policy.assertion;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.ComplexAssertion;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.policy.spi.AssertionCreationException;
import com.sun.xml.ws.rx.policy.assertion.AssertionInstantiator;
import com.sun.xml.ws.rx.policy.assertion.AssertionNamespace;
import com.sun.xml.ws.rx.policy.assertion.DeliveryAssuranceAssertion;
import com.sun.xml.ws.rx.policy.assertion.RmAssertionTranslator;
import com.sun.xml.ws.rx.rm.ReliableMessagingFeature;
import com.sun.xml.ws.rx.rm.ReliableMessagingFeatureBuilder;
import com.sun.xml.ws.rx.rm.RmVersion;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import java.util.Collection;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Rm11Assertion
extends ComplexAssertion
implements RmAssertionTranslator {
    private static final Logger LOGGER = Logger.getLogger(Rm11Assertion.class);
    public static final QName NAME = AssertionNamespace.WSRMP_200702.getQName("RMAssertion");
    private static final QName SEQUENCE_STR_QNAME = AssertionNamespace.WSRMP_200702.getQName("SequenceSTR");
    private static final QName SEQUENCE_TRANSPORT_SECURITY_QNAME = AssertionNamespace.WSRMP_200702.getQName("SequenceTransportSecurity");
    private static AssertionInstantiator instantiator = new AssertionInstantiator(){

        @Override
        public PolicyAssertion newInstance(AssertionData data, Collection<PolicyAssertion> assertionParameters, AssertionSet nestedAlternative) throws AssertionCreationException {
            return new Rm11Assertion(data, assertionParameters, nestedAlternative);
        }
    };
    private final ReliableMessagingFeature.SecurityBinding securityBinding;
    private final ReliableMessagingFeature.DeliveryAssurance deliveryAssurance;
    private final boolean isOrderedDelivery;

    public static AssertionInstantiator getInstantiator() {
        return instantiator;
    }

    private Rm11Assertion(AssertionData data, Collection<? extends PolicyAssertion> assertionParameters, AssertionSet nestedAlternative) throws AssertionCreationException {
        super(data, assertionParameters, nestedAlternative);
        ReliableMessagingFeature.SecurityBinding _securityBinding = ReliableMessagingFeature.SecurityBinding.NONE;
        DeliveryAssuranceAssertion deliveryAssuranceAssertion = null;
        if (nestedAlternative != null) {
            for (PolicyAssertion nestedAssertion : nestedAlternative) {
                if (SEQUENCE_STR_QNAME.equals(nestedAssertion.getName())) {
                    _securityBinding = this.evaluateDeliveryAssurance(_securityBinding == ReliableMessagingFeature.SecurityBinding.NONE, ReliableMessagingFeature.SecurityBinding.STR, data);
                    continue;
                }
                if (SEQUENCE_TRANSPORT_SECURITY_QNAME.equals(nestedAssertion.getName())) {
                    _securityBinding = this.evaluateDeliveryAssurance(_securityBinding == ReliableMessagingFeature.SecurityBinding.NONE, ReliableMessagingFeature.SecurityBinding.TRANSPORT, data);
                    continue;
                }
                if (!DeliveryAssuranceAssertion.NAME.equals(nestedAssertion.getName())) continue;
                deliveryAssuranceAssertion = (DeliveryAssuranceAssertion)nestedAssertion;
            }
        }
        if (deliveryAssuranceAssertion == null) {
            this.deliveryAssurance = ReliableMessagingFeature.DeliveryAssurance.getDefault();
            this.isOrderedDelivery = false;
        } else {
            this.deliveryAssurance = deliveryAssuranceAssertion.getDeliveryAssurance();
            this.isOrderedDelivery = deliveryAssuranceAssertion.isOrderedDelivery();
        }
        this.securityBinding = _securityBinding;
    }

    public ReliableMessagingFeature.DeliveryAssurance getDeliveryAssurance() {
        return this.deliveryAssurance;
    }

    public boolean isOrderedDelivery() {
        return this.isOrderedDelivery;
    }

    public ReliableMessagingFeature.SecurityBinding getSecurityBinding() {
        return this.securityBinding;
    }

    private ReliableMessagingFeature.SecurityBinding evaluateDeliveryAssurance(boolean successCondition, ReliableMessagingFeature.SecurityBinding bindingOnSuccess, AssertionData data) throws AssertionCreationException {
        if (successCondition) {
            return bindingOnSuccess;
        }
        throw LOGGER.logSevereException(new AssertionCreationException(data, LocalizationMessages.WSRM_1005_MULTIPLE_SECURITY_BINDINGS_IN_POLICY()));
    }

    @Override
    public ReliableMessagingFeatureBuilder update(ReliableMessagingFeatureBuilder builder) {
        if (this.isOrderedDelivery) {
            builder = builder.enableOrderedDelivery();
        }
        return builder.version(RmVersion.WSRM200702).deliveryAssurance(this.deliveryAssurance).securityBinding(this.securityBinding);
    }
}

