/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.external.statistics.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.impl.StatisticImpl;

public final class RangeStatisticImpl
extends StatisticImpl
implements RangeStatistic,
InvocationHandler {
    private AtomicLong currentVal = new AtomicLong(Long.MIN_VALUE);
    private AtomicLong highWaterMark = new AtomicLong(Long.MIN_VALUE);
    private AtomicLong lowWaterMark = new AtomicLong(Long.MIN_VALUE);
    private RangeStatistic rs = (RangeStatistic)Proxy.newProxyInstance(RangeStatistic.class.getClassLoader(), new Class[]{RangeStatistic.class}, (InvocationHandler)this);

    public RangeStatisticImpl(long curVal, long highMark, long lowMark, String name, String unit, String desc, long startTime, long sampleTime) {
        super(name, unit, desc, startTime, sampleTime);
        this.currentVal.set(curVal);
        this.highWaterMark.set(highMark);
        this.lowWaterMark.set(lowMark);
    }

    public synchronized RangeStatistic getStatistic() {
        return this.rs;
    }

    public synchronized Map getStaticAsMap() {
        Map m = super.getStaticAsMap();
        m.put("current", this.getCurrent());
        m.put("lowwatermark", this.getLowWaterMark());
        m.put("highwatermark", this.getHighWaterMark());
        return m;
    }

    public long getCurrent() {
        return this.currentVal.get();
    }

    public void setCurrent(long curVal) {
        this.currentVal.set(curVal);
    }

    public long getHighWaterMark() {
        return this.highWaterMark.get();
    }

    public void setHighWaterMark(long highMark) {
        this.highWaterMark.set(highMark);
    }

    public long getLowWaterMark() {
        return this.lowWaterMark.get();
    }

    public void setLowWaterMark(long lowMark) {
        this.lowWaterMark.set(lowMark);
    }

    public final String toString() {
        return super.toString() + NEWLINE + "Current: " + this.getCurrent() + NEWLINE + "LowWaterMark: " + this.getLowWaterMark() + NEWLINE + "HighWaterMark: " + this.getHighWaterMark();
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result;
        try {
            result = m.invoke((Object)this, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
        }
        return result;
    }
}

