/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.util;

import com.sun.istack.NotNull;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.commons.NamedThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public final class DelayedTaskManager {
    private static final Logger LOGGER = Logger.getLogger(DelayedTaskManager.class);
    private final ScheduledExecutorService executorService;
    private final AtomicBoolean isClosed;

    public static DelayedTaskManager createSingleThreadedManager(String name) {
        return new DelayedTaskManager(Executors.newSingleThreadScheduledExecutor(DelayedTaskManager.createThreadFactory(name)));
    }

    public static DelayedTaskManager createManager(String name, int coreThreadPoolSize) {
        return new DelayedTaskManager(Executors.newScheduledThreadPool(coreThreadPoolSize, DelayedTaskManager.createThreadFactory(name)));
    }

    private static final ThreadFactory createThreadFactory(String name) {
        return new NamedThreadFactory(name + "-worker-executor");
    }

    private DelayedTaskManager(ScheduledExecutorService executorService) {
        this.executorService = executorService;
        this.isClosed = new AtomicBoolean(false);
    }

    public boolean register(@NotNull DelayedTask task, long delay, TimeUnit timeUnit) {
        if (this.isClosed.get()) {
            LOGGER.finer(String.format("Attempt to register a new task has failed. This '%s' instance has already been closed", this.getClass().getName()));
            return false;
        }
        assert (task != null);
        this.executorService.schedule(new Worker(task), delay, timeUnit);
        return true;
    }

    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.executorService.shutdown();
        }
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    private class Worker
    implements Runnable {
        public final DelayedTask task;

        public Worker(DelayedTask handler) {
            this.task = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOGGER.entering();
            try {
                this.task.run(DelayedTaskManager.this);
            }
            catch (Exception ex) {
                LOGGER.logException(ex, Level.WARNING);
            }
            finally {
                LOGGER.exiting();
            }
        }
    }

    public static interface DelayedTask {
        public void run(DelayedTaskManager var1);
    }
}

