/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.runtime.util;

import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.runtime.util.Session;
import com.sun.xml.ws.runtime.util.SessionManagerImpl;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.util.ServiceFinder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedObject
@Description(value="Session manager used by RM and SC")
@AMXMetadata(type="RM_SC_SessionManager")
public abstract class SessionManager {
    private static Map<WSEndpoint, SessionManager> sessionManagers = new HashMap<WSEndpoint, SessionManager>();

    public abstract Session getSession(String var1);

    @ManagedAttribute
    @Description(value="The set of valid Session keys")
    public abstract Set<String> getKeys();

    @ManagedAttribute
    @Description(value="The collection of valid Sessions")
    protected abstract Collection<Session> getSessions();

    public abstract void terminateSession(String var1);

    public abstract Session createSession(String var1, Class var2);

    public abstract Session createSession(String var1, Object var2);

    public abstract Session createSession(String var1);

    public abstract void saveSession(String var1);

    public abstract IssuedTokenContext getSecurityContext(String var1, boolean var2);

    public abstract void addSecurityContext(String var1, IssuedTokenContext var2);

    public static void removeSessionManager(WSEndpoint endpoint) {
        SessionManager o = sessionManagers.remove(endpoint);
        if (o != null) {
            endpoint.getManagedObjectManager().unregister(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionManager getSessionManager(WSEndpoint endpoint) {
        Class<SessionManager> clazz = SessionManager.class;
        synchronized (SessionManager.class) {
            SessionManager sm = sessionManagers.get(endpoint);
            if (sm == null) {
                ServiceFinder<SessionManager> finder = ServiceFinder.find(SessionManager.class);
                sm = finder != null && finder.toArray().length > 0 ? finder.toArray()[0] : new SessionManagerImpl();
                sessionManagers.put(endpoint, sm);
                endpoint.getManagedObjectManager().registerAtRoot(sm, "RM_SC_SessionManager");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sm;
        }
    }
}

