/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management.persistence;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.config.management.ConfigSaver;
import com.sun.xml.ws.api.config.management.ManagedEndpoint;
import com.sun.xml.ws.api.config.management.NamedParameters;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.ws.WebServiceException;

public class JDBCConfigSaver
implements ConfigSaver {
    private static final Logger LOGGER = Logger.getLogger(JDBCConfigSaver.class);

    public void persist(NamedParameters parameters) {
        ManagedEndpoint endpoint = (ManagedEndpoint)parameters.get("ENDPOINT_INSTANCE");
        String newConfig = (String)parameters.get("CONFIGURATION_DATA");
        JDBCConfigSaver.writeData(endpoint.getId(), newConfig);
    }

    public static DataSource getManagementDS() {
        try {
            InitialContext initCtx = new InitialContext();
            return (DataSource)initCtx.lookup("jdbc/managementDS");
        }
        catch (NamingException e) {
            throw LOGGER.logSevereException(new WebServiceException((Throwable)e));
        }
    }

    private static void writeData(String endpointId, String data) {
        Connection connection = null;
        try {
            DataSource source = JDBCConfigSaver.getManagementDS();
            connection = source.getConnection();
            JDBCConfigSaver.writeData(connection, endpointId, data);
            connection.close();
        }
        catch (SQLException e) {
            throw LOGGER.logSevereException(new WebServiceException((Throwable)e));
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw LOGGER.logSevereException(new WebServiceException((Throwable)e));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeData(Connection connection, String endpointId, String config) {
        PreparedStatement updateStatement = null;
        Statement insertStatement = null;
        try {
            int rowCount;
            String update = "UPDATE METRO_CONFIG SET version = version + 1, config = ? WHERE id = ?";
            updateStatement = connection.prepareStatement("UPDATE METRO_CONFIG SET version = version + 1, config = ? WHERE id = ?");
            updateStatement.setCharacterStream(1, (Reader)new StringReader(config), config.length());
            updateStatement.setString(2, endpointId);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Executing SQL command: UPDATE METRO_CONFIG SET version = version + 1, config = ? WHERE id = ?");
            }
            if ((rowCount = updateStatement.executeUpdate()) != 0) return;
            String insert = "INSERT INTO METRO_CONFIG (id, version, config) VALUES (?, 1, ?)";
            insertStatement = connection.prepareStatement("INSERT INTO METRO_CONFIG (id, version, config) VALUES (?, 1, ?)");
            insertStatement.setString(1, endpointId);
            insertStatement.setCharacterStream(2, new StringReader(config), config.length());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("SQL UPDATE returned row count 0. Executing SQL command: INSERT INTO METRO_CONFIG (id, version, config) VALUES (?, 1, ?)");
            }
            insertStatement.executeUpdate();
            return;
        }
        catch (SQLException e) {
            throw LOGGER.logSevereException(new WebServiceException((Throwable)e));
        }
        finally {
            try {
                if (updateStatement != null) {
                    updateStatement.close();
                }
            }
            catch (SQLException e) {
                throw LOGGER.logSevereException(new WebServiceException((Throwable)e));
            }
            finally {
                try {
                    if (insertStatement != null) {
                        insertStatement.close();
                    }
                }
                catch (SQLException e) {
                    throw LOGGER.logSevereException(new WebServiceException((Throwable)e));
                }
            }
        }
    }
}

