/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.assembler;

import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.assembler.ClientTubelineAssemblyContext;
import com.sun.xml.ws.assembler.ServerTubelineAssemblyContext;
import com.sun.xml.ws.assembler.TubeFactory;
import com.sun.xml.ws.assembler.TubelineAssemblyContextUpdater;
import com.sun.xml.ws.runtime.config.TubeFactoryConfig;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TubeCreator {
    private final TubeFactory factory;
    private final String msgDumpPropertyBase;

    TubeCreator(TubeFactoryConfig config) {
        try {
            Class<?> factoryClass = Class.forName(config.getClassName());
            if (!TubeFactory.class.isAssignableFrom(factoryClass)) {
                throw new RuntimeException(String.format("Class '%s' does not implement '%s' interface", factoryClass.getName(), TubeFactory.class.getName()));
            }
            Class<?> typedClass = factoryClass;
            this.factory = (TubeFactory)typedClass.newInstance();
            this.msgDumpPropertyBase = this.factory.getClass().getName() + ".dump";
        }
        catch (InstantiationException ex) {
            String message = String.format("Unable to instantiate tube factory class", new Object[0]);
            Logger.getLogger(TubeCreator.class.getName()).log(Level.SEVERE, message, ex);
            throw new RuntimeException(message, ex);
        }
        catch (IllegalAccessException ex) {
            String message = String.format("Unable to instantiate tube factory class", new Object[0]);
            Logger.getLogger(TubeCreator.class.getName()).log(Level.SEVERE, message, ex);
            throw new RuntimeException(message, ex);
        }
        catch (ClassNotFoundException ex) {
            String message = String.format("Unable to load tube factory class", new Object[0]);
            Logger.getLogger(TubeCreator.class.getName()).log(Level.SEVERE, message, ex);
            throw new RuntimeException(message, ex);
        }
    }

    Tube createTube(ClientTubelineAssemblyContext context) {
        return this.factory.createTube(context);
    }

    Tube createTube(ServerTubelineAssemblyContext context) {
        return this.factory.createTube(context);
    }

    void updateContext(ClientTubelineAssemblyContext context) {
        if (this.factory instanceof TubelineAssemblyContextUpdater) {
            ((TubelineAssemblyContextUpdater)((Object)this.factory)).prepareContext(context);
        }
    }

    void updateContext(ServerTubelineAssemblyContext context) {
        if (this.factory instanceof TubelineAssemblyContextUpdater) {
            ((TubelineAssemblyContextUpdater)((Object)this.factory)).prepareContext(context);
        }
    }

    String getMessageDumpPropertyBase() {
        return this.msgDumpPropertyBase;
    }
}

