/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.glassfish.gmbal.ManagedData;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.gmbal.generic.Algorithms;
import org.glassfish.gmbal.generic.DumpToString;
import org.glassfish.gmbal.generic.FacetAccessor;
import org.glassfish.gmbal.generic.MethodMonitor;
import org.glassfish.gmbal.generic.MethodMonitorFactory;
import org.glassfish.gmbal.generic.Pair;
import org.glassfish.gmbal.generic.Predicate;
import org.glassfish.gmbal.impl.AttributeDescriptor;
import org.glassfish.gmbal.impl.Exceptions;
import org.glassfish.gmbal.impl.ManagedObjectManagerInternal;
import org.glassfish.gmbal.impl.TypeConverter;
import org.glassfish.gmbal.typelib.EvaluatedArrayType;
import org.glassfish.gmbal.typelib.EvaluatedClassAnalyzer;
import org.glassfish.gmbal.typelib.EvaluatedClassDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedMethodDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeConverterImpl
implements TypeConverter {
    private static final Map<EvaluatedType, OpenType> simpleTypeMap = new HashMap<EvaluatedType, OpenType>();
    private static final Map<OpenType, EvaluatedClassDeclaration> simpleOpenTypeMap = new HashMap<OpenType, EvaluatedClassDeclaration>();
    private static final MethodMonitor mm = MethodMonitorFactory.makeStandard(TypeConverterImpl.class);
    static final ObjectName NULL_OBJECTNAME;
    @DumpToString
    protected final EvaluatedType dataType;
    @DumpToString
    protected final OpenType managedType;

    private static void initMaps(EvaluatedClassDeclaration type, OpenType otype) {
        simpleTypeMap.put(type, otype);
        simpleOpenTypeMap.put(otype, type);
    }

    public static Class getJavaClass(OpenType ot) {
        if (ot instanceof SimpleType) {
            SimpleType st = (SimpleType)ot;
            return simpleOpenTypeMap.get(st).cls();
        }
        if (ot instanceof ArrayType) {
            ArrayType at = (ArrayType)ot;
            OpenType<?> cot = at.getElementOpenType();
            Class cjt = TypeConverterImpl.getJavaClass(cot);
            Object temp = Array.newInstance(cjt, 0);
            return temp.getClass();
        }
        if (ot instanceof TabularType) {
            return TabularData.class;
        }
        if (ot instanceof CompositeType) {
            return CompositeData.class;
        }
        throw Exceptions.self.unsupportedOpenType(ot);
    }

    public static Class getJavaClass(EvaluatedType type) {
        if (type instanceof EvaluatedClassDeclaration) {
            return ((EvaluatedClassDeclaration)type).cls();
        }
        if (type instanceof EvaluatedArrayType) {
            EvaluatedArrayType gat = (EvaluatedArrayType)type;
            EvaluatedType ctype = gat.componentType();
            Class cclass = TypeConverterImpl.getJavaClass(ctype);
            Object temp = Array.newInstance(cclass, 0);
            return temp.getClass();
        }
        throw Exceptions.self.cannotConvertToJavaType(type);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TypeConverter makeTypeConverter(EvaluatedType type, ManagedObjectManagerInternal mom) {
        TypeConverter result;
        block8: {
            mm.enter(mom.registrationDebug(), "makeTypeConverter", type, mom);
            result = null;
            try {
                OpenType stype = simpleTypeMap.get(type);
                if (stype != null) {
                    result = TypeConverterImpl.handleSimpleType(type, stype);
                    break block8;
                }
                if (type instanceof EvaluatedClassDeclaration) {
                    EvaluatedClassDeclaration cls = (EvaluatedClassDeclaration)type;
                    ManagedObject mo = cls.annotation(ManagedObject.class);
                    ManagedData md = cls.annotation(ManagedData.class);
                    result = mo != null ? TypeConverterImpl.handleManagedObject(cls, mom, mo) : (md != null ? TypeConverterImpl.handleManagedData(cls, mom, md) : (cls.cls().isEnum() ? TypeConverterImpl.handleEnum(cls) : TypeConverterImpl.handleClass(cls, mom)));
                } else {
                    if (!(type instanceof EvaluatedArrayType)) throw new IllegalArgumentException("Unknown kind of Type " + type);
                    result = TypeConverterImpl.handleArrayType((EvaluatedArrayType)type, mom);
                }
            }
            catch (RuntimeException exc) {
                try {
                    throw exc;
                    catch (OpenDataException exc2) {
                        throw new RuntimeException(exc2);
                    }
                }
                catch (Throwable throwable) {
                    mm.exit(mom.registrationDebug(), result);
                    throw throwable;
                }
            }
        }
        mm.exit(mom.registrationDebug(), result);
        return result;
    }

    private static TypeConverter handleSimpleType(EvaluatedType type, OpenType stype) {
        return new TypeConverterImpl(type, stype){

            public Object toManagedEntity(Object obj) {
                return obj;
            }

            public Object fromManagedEntity(Object entity) {
                return entity;
            }

            public boolean isIdentity() {
                return true;
            }
        };
    }

    private static ObjectName makeObjectName(String str) {
        try {
            return new ObjectName(str);
        }
        catch (MalformedObjectNameException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypeConverter handleManagedObject(EvaluatedClassDeclaration type, final ManagedObjectManagerInternal mom, ManagedObject mo) {
        TypeConverterImpl result = null;
        mm.enter(mom.registrationDebug(), "handleManagedObject", type, mom, mo);
        try {
            result = new TypeConverterImpl(type, SimpleType.OBJECTNAME){

                public Object toManagedEntity(Object obj) {
                    if (obj == null) {
                        return NULL_OBJECTNAME;
                    }
                    return mom.getObjectName(obj);
                }

                public Object fromManagedEntity(Object entity) {
                    if (!(entity instanceof ObjectName)) {
                        throw Exceptions.self.entityNotObjectName(entity);
                    }
                    ObjectName oname = (ObjectName)entity;
                    if (oname.equals(NULL_OBJECTNAME)) {
                        return null;
                    }
                    return mom.getObject(oname);
                }
            };
        }
        finally {
            mm.exit(mom.registrationDebug(), result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<AttributeDescriptor> analyzeManagedData(EvaluatedClassDeclaration cls, ManagedObjectManagerInternal mom) {
        mm.enter(mom.registrationDebug(), "analyzeManagedData", cls, mom);
        Collection<AttributeDescriptor> result = null;
        try {
            EvaluatedClassAnalyzer ca = mom.getClassAnalyzer(cls, ManagedData.class).second();
            Pair<Map<String, AttributeDescriptor>, Map<String, AttributeDescriptor>> ainfos = mom.getAttributes(ca, ManagedObjectManagerInternal.AttributeDescriptorType.COMPOSITE_DATA_ATTR);
            result = ainfos.first().values();
        }
        finally {
            mm.exit(mom.registrationDebug(), result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompositeType makeCompositeType(EvaluatedClassDeclaration cls, ManagedObjectManagerInternal mom, ManagedData md, Collection<AttributeDescriptor> minfos) {
        mm.enter(mom.registrationDebug(), "makeCompositeType", cls, mom, md, minfos);
        CompositeType result = null;
        try {
            String name = md.name();
            if (name.equals("")) {
                name = mom.getTypeName(cls.cls(), "GMBAL_TYPE", md.name());
            }
            mm.info(mom.registrationDebug(), "name=", name);
            String mdDescription = mom.getDescription(cls);
            mm.info(mom.registrationDebug(), "mdDescription=", mdDescription);
            int length = minfos.size();
            String[] attrNames = new String[length];
            String[] attrDescriptions = new String[length];
            OpenType[] attrOTypes = new OpenType[length];
            int ctr = 0;
            for (AttributeDescriptor minfo : minfos) {
                attrNames[ctr] = minfo.id();
                attrDescriptions[ctr] = minfo.description();
                attrOTypes[ctr] = minfo.tc().getManagedType();
                ++ctr;
            }
            mm.info(mom.registrationDebug(), "attrNames=", Arrays.asList(attrNames), "attrDescriptions=", Arrays.asList(attrDescriptions), "attrOTypes=", Arrays.asList(attrOTypes));
            try {
                result = new CompositeType(name, mdDescription, attrNames, attrDescriptions, attrOTypes);
            }
            catch (OpenDataException exc) {
                throw Exceptions.self.exceptionInMakeCompositeType(exc);
            }
            mm.exit(mom.registrationDebug(), result);
        }
        catch (Throwable throwable) {
            mm.exit(mom.registrationDebug(), result);
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypeConverter handleManagedData(final EvaluatedClassDeclaration cls, final ManagedObjectManagerInternal mom, ManagedData md) {
        mm.enter(mom.registrationDebug(), "handleManagedData", cls, mom, md);
        TypeConverterImpl result = null;
        try {
            final Collection<AttributeDescriptor> minfos = TypeConverterImpl.analyzeManagedData(cls, mom);
            final CompositeType myType = TypeConverterImpl.makeCompositeType(cls, mom, md, minfos);
            mm.info(mom.registrationDebug(), "minfos=", minfos, "myType=", myType);
            result = new TypeConverterImpl(cls, myType){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object toManagedEntity(Object obj) {
                    mm.enter(mom.runtimeDebug(), "(ManagedData):toManagedEntity", obj);
                    CompositeDataSupport runResult = null;
                    try {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        for (AttributeDescriptor minfo : minfos) {
                            mm.info(mom.runtimeDebug(), "Fetching attribute " + minfo.id());
                            Object value = null;
                            if (minfo.isApplicable(obj)) {
                                try {
                                    FacetAccessor fa = mom.getFacetAccessor(obj);
                                    value = minfo.get(fa, mom.runtimeDebug());
                                }
                                catch (JMException ex) {
                                    Exceptions.self.errorInConstructingOpenData(cls.name(), minfo.id(), ex);
                                }
                            }
                            data.put(minfo.id(), value);
                        }
                        try {
                            runResult = new CompositeDataSupport(myType, data);
                        }
                        catch (OpenDataException exc) {
                            throw Exceptions.self.exceptionInHandleManagedData(exc);
                        }
                        mm.exit(mom.runtimeDebug(), runResult);
                    }
                    catch (Throwable throwable) {
                        mm.exit(mom.runtimeDebug(), runResult);
                        throw throwable;
                    }
                    return runResult;
                }
            };
            mm.exit(mom.registrationDebug(), result);
        }
        catch (Throwable throwable) {
            mm.exit(mom.registrationDebug(), result);
            throw throwable;
        }
        return result;
    }

    private static TypeConverter handleEnum(final EvaluatedClassDeclaration cls) {
        return new TypeConverterImpl(cls, SimpleType.STRING){

            public Object toManagedEntity(Object obj) {
                return obj.toString();
            }

            public Object fromManagedEntity(Object entity) {
                if (!(entity instanceof String)) {
                    throw Exceptions.self.notAString(entity);
                }
                return Enum.valueOf(cls.cls(), (String)entity);
            }
        };
    }

    private static ArrayType getArrayType(OpenType ot) throws OpenDataException {
        ArrayType result;
        if (ot instanceof ArrayType) {
            ArrayType atype = (ArrayType)ot;
            int dim = atype.getDimension();
            OpenType<?> lowestComponentType = atype.getElementOpenType();
            result = new ArrayType(dim + 1, lowestComponentType);
        } else {
            result = new ArrayType(1, ot);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypeConverter handleArrayType(EvaluatedArrayType type, final ManagedObjectManagerInternal mom) throws OpenDataException {
        mm.enter(mom.registrationDebug(), "handleArrayType", type.name());
        TypeConverterImpl result = null;
        try {
            final EvaluatedType ctype = type.componentType();
            final TypeConverter ctypeTc = mom.getTypeConverter(ctype);
            final OpenType cotype = ctypeTc.getManagedType();
            ArrayType ot = TypeConverterImpl.getArrayType(cotype);
            mm.info(mom.registrationDebug(), "ctype=", ctype, "ctypeTc=", ctypeTc, "cotype=", cotype, "ot=", ot);
            result = new TypeConverterImpl(type, ot){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object toManagedEntity(Object obj) {
                    if (this.isIdentity()) {
                        return obj;
                    }
                    Class cclass = 5.getJavaClass(cotype);
                    int length = Array.getLength(obj);
                    Object result = Array.newInstance(cclass, length);
                    for (int ctr = 0; ctr < length; ++ctr) {
                        mm.enter(mom.runtimeDebug(), "(handleArrayType):toManagedEntity", ctr);
                        try {
                            Object elem = Array.get(obj, ctr);
                            Object relem = ctypeTc.toManagedEntity(elem);
                            Array.set(result, ctr, relem);
                            continue;
                        }
                        finally {
                            mm.exit(mom.runtimeDebug());
                        }
                    }
                    return result;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object fromManagedEntity(Object entity) {
                    if (this.isIdentity()) {
                        return entity;
                    }
                    Class cclass = 5.getJavaClass(ctype);
                    int length = Array.getLength(entity);
                    Object result = Array.newInstance(cclass, length);
                    for (int ctr = 0; ctr < length; ++ctr) {
                        mm.enter(mom.runtimeDebug(), "(handleArrayType):fromManagedEntity", ctr);
                        try {
                            Object elem = Array.get(entity, ctr);
                            Object relem = ctypeTc.fromManagedEntity(elem);
                            Array.set(result, ctr, relem);
                            continue;
                        }
                        finally {
                            mm.exit(mom.runtimeDebug());
                        }
                    }
                    return result;
                }

                public boolean isIdentity() {
                    return ctypeTc.isIdentity();
                }
            };
            mm.exit(mom.registrationDebug(), result);
        }
        catch (Throwable throwable) {
            mm.exit(mom.registrationDebug(), result);
            throw throwable;
        }
        return result;
    }

    private static EvaluatedMethodDeclaration findMethod(EvaluatedClassAnalyzer eca, final String mname) {
        return Algorithms.getFirst(eca.findMethods(new Predicate<EvaluatedMethodDeclaration>(){

            @Override
            public boolean evaluate(EvaluatedMethodDeclaration m) {
                return m.name().equals(mname);
            }
        }), "");
    }

    private static EvaluatedType getReturnType(EvaluatedClassDeclaration decl, String mname) {
        EvaluatedClassAnalyzer eca = new EvaluatedClassAnalyzer(decl);
        EvaluatedMethodDeclaration meth = TypeConverterImpl.findMethod(eca, mname);
        if (meth == null) {
            return null;
        }
        return meth.returnType();
    }

    private static EvaluatedType getParameterType(EvaluatedClassDeclaration decl, String mname, int pindex) {
        EvaluatedClassAnalyzer eca = new EvaluatedClassAnalyzer(decl);
        EvaluatedMethodDeclaration meth = TypeConverterImpl.findMethod(eca, mname);
        if (meth == null) {
            return null;
        }
        if (pindex < meth.parameterTypes().size()) {
            return meth.parameterTypes().get(pindex);
        }
        throw new IndexOutOfBoundsException("Parameter index is out of bounds");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypeConverter handleClass(EvaluatedClassDeclaration type, ManagedObjectManagerInternal mom) {
        mm.enter(mom.registrationDebug(), "handleClass", "type", type);
        TypeConverter result = null;
        try {
            if (Iterable.class.isAssignableFrom(type.cls())) {
                EvaluatedClassDeclaration type2 = (EvaluatedClassDeclaration)TypeConverterImpl.getReturnType(type, "iterator");
                if (type2 == null) {
                    throw Exceptions.self.iteratorNotFound(type);
                }
                EvaluatedType tcType = TypeConverterImpl.getReturnType(type2, "next");
                if (tcType == null) {
                    throw Exceptions.self.nextNotFound(type);
                }
                TypeConverter tc = mom.getTypeConverter(tcType);
                result = new TypeConverterListBase((EvaluatedType)type, tc){

                    protected Iterator getIterator(Object obj) {
                        return ((Iterable)obj).iterator();
                    }
                };
            } else if (Collection.class.isAssignableFrom(type.cls())) {
                EvaluatedClassDeclaration type2 = (EvaluatedClassDeclaration)TypeConverterImpl.getReturnType(type, "iterator");
                EvaluatedType tcType = TypeConverterImpl.getReturnType(type2, "next");
                TypeConverter tc = mom.getTypeConverter(tcType);
                result = new TypeConverterListBase((EvaluatedType)type, tc){

                    protected Iterator getIterator(Object obj) {
                        return ((Iterable)obj).iterator();
                    }
                };
            } else if (Iterator.class.isAssignableFrom(type.cls())) {
                EvaluatedType tcType = TypeConverterImpl.getReturnType(type, "next");
                TypeConverter tc = mom.getTypeConverter(tcType);
                result = new TypeConverterListBase((EvaluatedType)type, tc){

                    protected Iterator getIterator(Object obj) {
                        return (Iterator)obj;
                    }
                };
            } else if (Enumeration.class.isAssignableFrom(type.cls())) {
                EvaluatedType tcType = TypeConverterImpl.getReturnType(type, "next");
                TypeConverter tc = mom.getTypeConverter(tcType);
                result = new TypeConverterListBase((EvaluatedType)type, tc){

                    protected Iterator getIterator(Object obj) {
                        return new EnumerationAdapter((Enumeration)obj);
                    }
                };
            } else if (Map.class.isAssignableFrom(type.cls())) {
                EvaluatedType type1 = TypeConverterImpl.getParameterType(type, "put", 0);
                TypeConverter firstTc = mom.getTypeConverter(type1);
                EvaluatedType type2 = TypeConverterImpl.getReturnType(type, "put");
                TypeConverter secondTc = mom.getTypeConverter(type2);
                result = new TypeConverterMapBase(type, firstTc, secondTc){

                    protected Table getTable(Object obj) {
                        return new TableMapImpl((Map)obj);
                    }
                };
            } else if (Dictionary.class.isAssignableFrom(type.cls())) {
                EvaluatedType type1 = TypeConverterImpl.getParameterType(type, "put", 0);
                TypeConverter firstTc = mom.getTypeConverter(type1);
                EvaluatedType type2 = TypeConverterImpl.getReturnType(type, "put");
                TypeConverter secondTc = mom.getTypeConverter(type2);
                result = new TypeConverterMapBase(type, firstTc, secondTc){

                    protected Table getTable(Object obj) {
                        return new TableDictionaryImpl((Dictionary)obj);
                    }
                };
            } else {
                result = TypeConverterImpl.handleAsString(type);
            }
            mm.exit(mom.registrationDebug(), result);
        }
        catch (Throwable throwable) {
            mm.exit(mom.registrationDebug(), result);
            throw throwable;
        }
        return result;
    }

    private static TypeConverter handleAsString(final EvaluatedClassDeclaration cls) {
        Constructor cs = null;
        try {
            cs = cls.cls().getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        final Constructor cons = cs;
        return new TypeConverterImpl(cls, SimpleType.STRING){

            public Object toManagedEntity(Object obj) {
                if (obj == null) {
                    return "*NULL*";
                }
                return obj.toString();
            }

            public Object fromManagedEntity(Object entity) {
                if (cons == null) {
                    throw Exceptions.self.noStringConstructor(cls.cls());
                }
                try {
                    String str = (String)entity;
                    return cons.newInstance(str);
                }
                catch (InstantiationException exc) {
                    throw Exceptions.self.stringConversionError(cls.cls(), exc);
                }
                catch (IllegalAccessException exc) {
                    throw Exceptions.self.stringConversionError(cls.cls(), exc);
                }
                catch (InvocationTargetException exc) {
                    throw Exceptions.self.stringConversionError(cls.cls(), exc);
                }
            }
        };
    }

    protected TypeConverterImpl(EvaluatedType dataType, OpenType managedType) {
        this.dataType = dataType;
        this.managedType = managedType;
    }

    @Override
    public final EvaluatedType getDataType() {
        return this.dataType;
    }

    @Override
    public final OpenType getManagedType() {
        return this.managedType;
    }

    @Override
    public abstract Object toManagedEntity(Object var1);

    @Override
    public Object fromManagedEntity(Object entity) {
        throw Exceptions.self.openToJavaNotSupported(this.managedType, this.dataType);
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    private String displayOpenType(OpenType otype) {
        if (otype instanceof SimpleType) {
            SimpleType stype = (SimpleType)otype;
            return "SimpleType(" + stype.getTypeName() + ")";
        }
        if (otype instanceof ArrayType) {
            ArrayType atype = (ArrayType)otype;
            return "ArrayType(" + this.displayOpenType(atype.getElementOpenType()) + "," + atype.getDimension() + ")";
        }
        if (otype instanceof CompositeType) {
            CompositeType ctype = (CompositeType)otype;
            return "CompositeType(" + ctype.getTypeName() + ")";
        }
        if (otype instanceof TabularType) {
            TabularType ttype = (TabularType)otype;
            return "TabularType(" + ttype.getTypeName() + "," + "rowType=" + ttype.getRowType() + "indexNames=" + ttype.getIndexNames() + ")";
        }
        return "UNKNOWN(" + otype + ")";
    }

    public String toString() {
        return "TypeConverter[dataType=" + this.dataType + ",managedType=" + this.displayOpenType(this.managedType) + "]";
    }

    static {
        TypeConverterImpl.initMaps(EvaluatedType.EBOOLEAN, SimpleType.BOOLEAN);
        TypeConverterImpl.initMaps(EvaluatedType.EBOOLEANW, SimpleType.BOOLEAN);
        TypeConverterImpl.initMaps(EvaluatedType.ECHAR, SimpleType.CHARACTER);
        TypeConverterImpl.initMaps(EvaluatedType.ECHARW, SimpleType.CHARACTER);
        TypeConverterImpl.initMaps(EvaluatedType.EBYTE, SimpleType.BYTE);
        TypeConverterImpl.initMaps(EvaluatedType.EBYTEW, SimpleType.BYTE);
        TypeConverterImpl.initMaps(EvaluatedType.ESHORT, SimpleType.SHORT);
        TypeConverterImpl.initMaps(EvaluatedType.ESHORTW, SimpleType.SHORT);
        TypeConverterImpl.initMaps(EvaluatedType.EINT, SimpleType.INTEGER);
        TypeConverterImpl.initMaps(EvaluatedType.EINTW, SimpleType.INTEGER);
        TypeConverterImpl.initMaps(EvaluatedType.ELONG, SimpleType.LONG);
        TypeConverterImpl.initMaps(EvaluatedType.ELONGW, SimpleType.LONG);
        TypeConverterImpl.initMaps(EvaluatedType.EFLOAT, SimpleType.FLOAT);
        TypeConverterImpl.initMaps(EvaluatedType.EFLOATW, SimpleType.FLOAT);
        TypeConverterImpl.initMaps(EvaluatedType.EDOUBLE, SimpleType.DOUBLE);
        TypeConverterImpl.initMaps(EvaluatedType.EDOUBLEW, SimpleType.DOUBLE);
        TypeConverterImpl.initMaps(EvaluatedType.ESTRING, SimpleType.STRING);
        TypeConverterImpl.initMaps(EvaluatedType.EVOID, SimpleType.VOID);
        TypeConverterImpl.initMaps(EvaluatedType.EDATE, SimpleType.DATE);
        TypeConverterImpl.initMaps(EvaluatedType.EOBJECT_NAME, SimpleType.OBJECTNAME);
        TypeConverterImpl.initMaps(EvaluatedType.EBIG_DECIMAL, SimpleType.BIGDECIMAL);
        TypeConverterImpl.initMaps(EvaluatedType.EBIG_INTEGER, SimpleType.BIGINTEGER);
        NULL_OBJECTNAME = TypeConverterImpl.makeObjectName("NULL:type=Null,name=Null");
    }

    private static abstract class TypeConverterMapBase
    extends TypeConverterImpl {
        private final TypeConverter keyTypeConverter;
        private final TypeConverter valueTypeConverter;

        public TypeConverterMapBase(EvaluatedType dataType, TypeConverter keyTypeConverter, TypeConverter valueTypeConverter) {
            super(dataType, TypeConverterMapBase.makeMapTabularType(keyTypeConverter, valueTypeConverter));
            this.keyTypeConverter = keyTypeConverter;
            this.valueTypeConverter = valueTypeConverter;
        }

        private static TabularType makeMapTabularType(TypeConverter firstTc, TypeConverter secondTc) {
            String mapType = firstTc + "->" + secondTc;
            String[] itemNames = new String[]{"key", "value"};
            String description = Exceptions.self.rowTypeDescription(mapType);
            String[] itemDescriptions = new String[]{Exceptions.self.keyFieldDescription(mapType), Exceptions.self.valueFieldDescription(mapType)};
            OpenType[] itemTypes = new OpenType[]{firstTc.getManagedType(), secondTc.getManagedType()};
            try {
                CompositeType rowType = new CompositeType(mapType, description, itemNames, itemDescriptions, itemTypes);
                String[] keys = new String[]{"key"};
                String tableName = Exceptions.self.tableName(mapType);
                String tableDescription = Exceptions.self.tableDescription(mapType);
                TabularType result = new TabularType(tableName, tableDescription, rowType, keys);
                return result;
            }
            catch (OpenDataException exc) {
                throw Exceptions.self.exceptionInMakeMapTabularType(exc);
            }
        }

        protected abstract Table getTable(Object var1);

        public Object toManagedEntity(Object obj) {
            try {
                Table table = this.getTable(obj);
                TabularType ttype = (TabularType)this.getManagedType();
                CompositeType ctype = ttype.getRowType();
                TabularDataSupport result = new TabularDataSupport(ttype);
                for (Object key : table) {
                    Object value = table.get(key);
                    Object mappedKey = this.keyTypeConverter.toManagedEntity(key);
                    Object mappedValue = this.valueTypeConverter.toManagedEntity(value);
                    HashMap<String, Object> items = new HashMap<String, Object>();
                    items.put("key", mappedKey);
                    items.put("value", mappedValue);
                    CompositeDataSupport cdata = new CompositeDataSupport(ctype, items);
                    result.put(cdata);
                }
                return result;
            }
            catch (OpenDataException exc) {
                throw Exceptions.self.excInMakeMapTabularDataToManagedEntity(exc);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableDictionaryImpl<K, V>
    implements Table<K, V> {
        private final Dictionary<K, V> dict;

        public TableDictionaryImpl(Dictionary<K, V> dict) {
            this.dict = dict;
        }

        @Override
        public Iterator<K> iterator() {
            return new EnumerationAdapter<V>(this.dict.elements());
        }

        @Override
        public V get(K key) {
            return this.dict.get(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableMapImpl<K, V>
    implements Table<K, V> {
        private final Map<K, V> map;

        public TableMapImpl(Map<K, V> map) {
            this.map = map;
        }

        @Override
        public Iterator<K> iterator() {
            return this.map.keySet().iterator();
        }

        @Override
        public V get(K key) {
            return this.map.get(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Table<K, V>
    extends Iterable<K> {
        public V get(K var1);
    }

    private static abstract class TypeConverterListBase
    extends TypeConverterImpl {
        final TypeConverter memberTc;

        public TypeConverterListBase(EvaluatedType dataType, TypeConverter memberTc) {
            super(dataType, TypeConverterListBase.makeArrayType(memberTc.getManagedType()));
            this.memberTc = memberTc;
        }

        private static ArrayType makeArrayType(OpenType ot) {
            try {
                return TypeConverterImpl.getArrayType(ot);
            }
            catch (OpenDataException exc) {
                throw Exceptions.self.openTypeInArrayTypeException(ot, exc);
            }
        }

        protected abstract Iterator getIterator(Object var1);

        public Object toManagedEntity(Object obj) {
            Iterator iter = this.getIterator(obj);
            ArrayList list = new ArrayList();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
            Class cclass = TypeConverterListBase.getJavaClass(this.memberTc.getManagedType());
            Object result = Array.newInstance(cclass, list.size());
            int ctr = 0;
            for (Object elem : list) {
                Object mappedElem = this.memberTc.toManagedEntity(elem);
                Array.set(result, ctr++, mappedElem);
            }
            return result;
        }
    }

    public static class TypeConverterPlaceHolderImpl
    implements TypeConverter {
        private EvaluatedType et;

        public TypeConverterPlaceHolderImpl(EvaluatedType type) {
            this.et = type;
        }

        public EvaluatedType getDataType() {
            throw Exceptions.self.recursiveTypesNotSupported(this.et);
        }

        public OpenType getManagedType() {
            throw Exceptions.self.recursiveTypesNotSupported(this.et);
        }

        public Object toManagedEntity(Object obj) {
            throw Exceptions.self.recursiveTypesNotSupported(this.et);
        }

        public Object fromManagedEntity(Object entity) {
            throw Exceptions.self.recursiveTypesNotSupported(this.et);
        }

        public boolean isIdentity() {
            throw Exceptions.self.recursiveTypesNotSupported(this.et);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumerationAdapter<T>
    implements Iterator<T> {
        private final Enumeration<T> enumeration;

        public EnumerationAdapter(Enumeration<T> en) {
            this.enumeration = en;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public T next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() {
            throw Exceptions.self.removeNotSupported();
        }
    }
}

