/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.persistent;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.sequence.AbstractSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.InboundSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.OutboundSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.PersistenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.PersistentSequenceData;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.glassfish.gmbal.ManagedObjectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PersistentSequenceManager
implements SequenceManager {
    private static final Logger LOGGER = Logger.getLogger(PersistentSequenceManager.class);
    private static final String RM_JDBC_POOL_NAME = "jdbc/ReliableMessagingPool";
    private Connection sqlConnection = null;
    private final ReadWriteLock dataLock = new ReentrantReadWriteLock();
    private final Map<String, AbstractSequence> sequences = new HashMap<String, AbstractSequence>();
    private final Map<String, String> boundSequences = new HashMap<String, String>();
    private final ManagedObjectManager managedObjectManager;
    private final DeliveryQueueBuilder inboundQueueBuilder;
    private final DeliveryQueueBuilder outboundQueueBuilder;
    private final String uniqueEndpointId;

    public PersistentSequenceManager(String uniqueEndpointId, DeliveryQueueBuilder inboundQueueBuilder, DeliveryQueueBuilder outboundQueueBuilder, ManagedObjectManager managedObjectManager) {
        this.managedObjectManager = managedObjectManager;
        if (managedObjectManager != null) {
            managedObjectManager.registerAtRoot(this, "RMSequenceManager");
        }
        this.uniqueEndpointId = uniqueEndpointId;
        this.inboundQueueBuilder = inboundQueueBuilder;
        this.outboundQueueBuilder = outboundQueueBuilder;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public String uniqueEndpointId() {
        return this.uniqueEndpointId;
    }

    @Override
    public Map<String, ? extends Sequence> sequences() {
        return null;
    }

    @Override
    public Map<String, String> boundSequences() {
        return null;
    }

    @Override
    public Sequence createOutboundSequence(String sequenceId, String strId, long expirationTime) throws DuplicateSequenceException {
        PersistentSequenceData data = PersistentSequenceData.newInstance(this.sqlConnection, this.uniqueEndpointId, sequenceId, PersistentSequenceData.SequenceType.Outbound, strId, expirationTime, Sequence.State.CREATED, false, 0L, this.currentTimeInMillis(), 0L);
        return this.registerSequence(new OutboundSequence(data, this.outboundQueueBuilder, this));
    }

    @Override
    public Sequence createInboundSequence(String sequenceId, String strId, long expirationTime) throws DuplicateSequenceException {
        PersistentSequenceData data = PersistentSequenceData.newInstance(this.sqlConnection, this.uniqueEndpointId, sequenceId, PersistentSequenceData.SequenceType.Inbound, strId, expirationTime, Sequence.State.CREATED, false, 0L, this.currentTimeInMillis(), 0L);
        return this.registerSequence(new InboundSequence(data, this.inboundQueueBuilder, this));
    }

    @Override
    public String generateSequenceUID() {
        return "uuid:" + UUID.randomUUID();
    }

    @Override
    public Sequence closeSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.getSequence(sequenceId);
        sequence.close();
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence getSequence(String sequenceId) throws UnknownSequenceException {
        try {
            this.dataLock.readLock().lock();
            if (this.sequences.containsKey(sequenceId)) {
                Sequence sequence = this.sequences.get(sequenceId);
                return sequence;
            }
        }
        finally {
            this.dataLock.readLock().unlock();
        }
        Sequence sequence = this.fetch(sequenceId);
        if (sequence == null) {
            throw new UnknownSequenceException(sequenceId);
        }
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence fetch(String sequenceId) {
        this.dataLock.writeLock().lock();
        try {
            if (this.sequences.containsKey(sequenceId)) {
                Sequence sequence = this.sequences.get(sequenceId);
                return sequence;
            }
            PersistentSequenceData sequenceData = PersistentSequenceData.loadInstance(this.sqlConnection, this.uniqueEndpointId, sequenceId);
            if (sequenceData != null) {
                switch (sequenceData.getType()) {
                    case Inbound: {
                        AbstractSequence abstractSequence = this.registerSequence(new InboundSequence(sequenceData, this.inboundQueueBuilder, this));
                        return abstractSequence;
                    }
                    case Outbound: {
                        AbstractSequence abstractSequence = this.registerSequence(new OutboundSequence(sequenceData, this.outboundQueueBuilder, this));
                        return abstractSequence;
                    }
                }
            }
            Sequence sequence = null;
            return sequence;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(String sequenceId) {
        Sequence s;
        try {
            this.dataLock.readLock().lock();
            s = this.sequences.get(sequenceId);
        }
        finally {
            this.dataLock.readLock().unlock();
        }
        if (s == null) {
            s = this.fetch(sequenceId);
        }
        return s != null && s.getState() != Sequence.State.TERMINATING;
    }

    @Override
    public Sequence terminateSequence(String sequenceId) throws UnknownSequenceException {
        try {
            this.fetch(sequenceId);
            this.dataLock.writeLock().lock();
            if (this.sequences.containsKey(sequenceId)) {
                AbstractSequence sequence = this.sequences.remove(sequenceId);
                sequence.setState(Sequence.State.TERMINATING);
                if (this.boundSequences.containsKey(sequenceId)) {
                    this.boundSequences.remove(sequenceId);
                }
                if (this.managedObjectManager != null) {
                    this.managedObjectManager.unregister(sequence);
                }
                PersistentSequenceData.remove(this.sqlConnection, this.uniqueEndpointId, sequenceId);
                sequence.preDestroy();
                AbstractSequence abstractSequence = sequence;
                return abstractSequence;
            }
            throw new UnknownSequenceException(sequenceId);
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindSequences(String referenceSequenceId, String boundSequenceId) throws UnknownSequenceException {
        try {
            this.dataLock.writeLock().lock();
            if (!this.sequences.containsKey(referenceSequenceId) && this.fetch(referenceSequenceId) == null) {
                throw new UnknownSequenceException(referenceSequenceId);
            }
            if (!this.sequences.containsKey(boundSequenceId) && this.fetch(referenceSequenceId) == null) {
                throw new UnknownSequenceException(boundSequenceId);
            }
            PersistentSequenceData.bind(this.sqlConnection, this.uniqueEndpointId, referenceSequenceId, boundSequenceId);
            this.boundSequences.put(referenceSequenceId, boundSequenceId);
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    @Override
    public Sequence getBoundSequence(String referenceSequenceId) throws UnknownSequenceException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractSequence registerSequence(AbstractSequence sequence) {
        try {
            this.dataLock.writeLock().lock();
            this.sequences.put(sequence.getId(), sequence);
            if (this.managedObjectManager != null) {
                this.managedObjectManager.register(this, sequence, sequence.getId().replace(':', '-'));
            }
            AbstractSequence abstractSequence = sequence;
            return abstractSequence;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    protected void abort() {
        try {
            this.sqlConnection.rollback();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    protected void commit() throws SQLException {
        this.sqlConnection.commit();
    }

    protected void beginTransaction() {
    }

    synchronized void connect() throws PersistenceException {
        try {
            InitialContext ic = new InitialContext();
            Object __ds = ic.lookup(RM_JDBC_POOL_NAME);
            if (!(__ds instanceof DataSource)) {
                throw new PersistenceException(String.format("Object of class '%s' bound in the JNDI under '%s' is not an instance of '%s'.", __ds.getClass().getName(), RM_JDBC_POOL_NAME, DataSource.class.getName()));
            }
            DataSource ds = (DataSource)DataSource.class.cast(__ds);
            this.sqlConnection = ds.getConnection("username", "password");
            this.sqlConnection.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw LOGGER.logSevereException(new PersistenceException("Unable to retrieve JDBC connection to Metro reliable messaging database", ex));
        }
        catch (NamingException ex) {
            throw LOGGER.logSevereException(new PersistenceException("Unable to lookup Metro reliable messaging JDBC connection pool", ex));
        }
    }

    @Override
    public long currentTimeInMillis() {
        return System.currentTimeMillis();
    }
}

