/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.assembler.ServerTubelineAssemblyContext;
import com.sun.xml.ws.runtime.util.Session;
import com.sun.xml.ws.runtime.util.SessionManager;
import com.sun.xml.ws.rx.RxConfiguration;
import com.sun.xml.ws.rx.RxException;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.faults.AbstractSoapFaultException;
import com.sun.xml.ws.rx.rm.faults.CreateSequenceRefusedFault;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.protocol.AcknowledgementData;
import com.sun.xml.ws.rx.rm.protocol.CloseSequenceData;
import com.sun.xml.ws.rx.rm.protocol.CloseSequenceResponseData;
import com.sun.xml.ws.rx.rm.protocol.CreateSequenceData;
import com.sun.xml.ws.rx.rm.protocol.CreateSequenceResponseData;
import com.sun.xml.ws.rx.rm.protocol.TerminateSequenceData;
import com.sun.xml.ws.rx.rm.protocol.TerminateSequenceResponseData;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.rm.runtime.ServerDestinationDeliveryCallback;
import com.sun.xml.ws.rx.rm.runtime.ServerSourceDeliveryCallback;
import com.sun.xml.ws.rx.rm.runtime.Utilities;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.delivery.PostmanPool;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManagerFactory;
import com.sun.xml.ws.rx.util.Communicator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import javax.xml.ws.EndpointReference;

public class ServerTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(ServerTube.class);
    private static final Level PROTOCOL_FAULT_LOGGING_LEVEL = Level.WARNING;
    private static final String SEQUENCE_PROPERTY = "com.sun.xml.ws.sequence";
    private static final String MESSAGE_NUMBER_PROPERTY = "com.sun.xml.ws.messagenumber";
    private final RuntimeContext rc;
    private final WSEndpoint endpoint;

    public ServerTube(ServerTube original, TubeCloner cloner) {
        super(original, cloner);
        this.rc = original.rc;
        this.endpoint = original.endpoint;
    }

    public ServerTube(RxConfiguration configuration, Tube tubelineHead, ServerTubelineAssemblyContext context) {
        super(tubelineHead);
        this.endpoint = context.getEndpoint();
        if (configuration.getAddressingVersion() == null) {
            throw new RxRuntimeException(LocalizationMessages.WSRM_1140_NO_ADDRESSING_VERSION_ON_ENDPOINT());
        }
        RuntimeContext.Builder rcBuilder = RuntimeContext.getBuilder(configuration, new Communicator("RmServerTubeCommunicator", null, this.next, null, configuration.getAddressingVersion(), configuration.getSoapVersion(), configuration.getRmVersion().getJaxbContext(configuration.getAddressingVersion())));
        this.rc = rcBuilder.build();
        DeliveryQueueBuilder inboundQueueBuilder = DeliveryQueueBuilder.getBuilder(configuration, PostmanPool.INSTANCE.getPostman(), new ServerDestinationDeliveryCallback(this.rc));
        DeliveryQueueBuilder outboundQueueBuilder = null;
        if (configuration.requestResponseOperationsDetected()) {
            outboundQueueBuilder = DeliveryQueueBuilder.getBuilder(configuration, PostmanPool.INSTANCE.getPostman(), new ServerSourceDeliveryCallback(this.rc));
        }
        SequenceManager sequenceManager = SequenceManagerFactory.INSTANCE.createSequenceManager(context.getEndpoint().getServiceName() + "::" + context.getEndpoint().getPortName(), inboundQueueBuilder, outboundQueueBuilder, configuration.getManagedObjectManager());
        this.rc.setSequenceManager(sequenceManager);
        this.rc.startRedeliveryTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTube copy(TubeCloner cloner) {
        LOGGER.entering();
        try {
            ServerTube serverTube = new ServerTube(this, cloner);
            return serverTube;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * Exception decompiling
     */
    public NextAction processRequest(Packet request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK]], but top level block is 12[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processResponse(Packet response) {
        LOGGER.entering();
        try {
            NextAction nextAction = super.processResponse(response);
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processException(Throwable throwable) {
        LOGGER.entering();
        try {
            NextAction nextAction = super.processException(throwable);
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDestroy() {
        LOGGER.entering();
        try {
            this.rc.stopAllTasks();
            SessionManager.removeSessionManager(this.endpoint);
        }
        finally {
            super.preDestroy();
            LOGGER.exiting();
        }
    }

    private Packet processProtocolRequest(Packet request, String wsaAction) throws AbstractSoapFaultException {
        if (this.rc.rmVersion.createSequenceAction.equals(wsaAction)) {
            return this.handleCreateSequenceAction(request);
        }
        if (this.rc.rmVersion.closeSequenceAction.equals(wsaAction)) {
            return this.handleCloseSequenceAction(request);
        }
        if (this.rc.rmVersion.terminateSequenceAction.equals(wsaAction)) {
            return this.handleTerminateSequenceAction(request);
        }
        if (this.rc.rmVersion.ackRequestedAction.equals(wsaAction)) {
            return this.handleAckRequestedAction(request);
        }
        if (this.rc.rmVersion.sequenceAcknowledgementAction.equals(wsaAction)) {
            return this.handleSequenceAcknowledgementAction(request);
        }
        throw LOGGER.logSevereException(new RxRuntimeException(LocalizationMessages.WSRM_1134_UNSUPPORTED_PROTOCOL_MESSAGE(wsaAction)));
    }

    private Packet handleCreateSequenceAction(Packet request) throws CreateSequenceRefusedFault {
        CreateSequenceData requestData = this.rc.protocolHandler.toCreateSequenceData(request);
        EndpointReference requestDestination = null;
        if (requestData.getOfferedSequenceId() != null) {
            if (this.rc.sequenceManager().isValid(requestData.getOfferedSequenceId())) {
                throw new CreateSequenceRefusedFault(LocalizationMessages.WSRM_1137_OFFERED_ID_ALREADY_IN_USE(requestData.getOfferedSequenceId()), AbstractSoapFaultException.Code.Sender);
            }
            String wsaTo = this.rc.communicator.getWsaTo(request);
            try {
                requestDestination = new WSEndpointReference(new URI(wsaTo), this.rc.addressingVersion).toSpec();
            }
            catch (URISyntaxException e) {
                throw new CreateSequenceRefusedFault(LocalizationMessages.WSRM_1129_INVALID_VALUE_OF_MESSAGE_HEADER("To", "CreateSequence", wsaTo), AbstractSoapFaultException.Code.Sender, e);
            }
            catch (NullPointerException e) {
                throw new CreateSequenceRefusedFault(LocalizationMessages.WSRM_1130_MISSING_MESSAGE_HEADER("To", "CreateSequence", wsaTo), AbstractSoapFaultException.Code.Sender, e);
            }
        }
        String receivedSctId = null;
        if (requestData.getStrType() != null) {
            String activeSctId = this.getSecurityContextTokenId(request);
            if (activeSctId == null) {
                throw new CreateSequenceRefusedFault(LocalizationMessages.WSRM_1133_NO_SECURITY_TOKEN_IN_REQUEST_PACKET(), AbstractSoapFaultException.Code.Sender);
            }
            try {
                receivedSctId = Utilities.extractSecurityContextTokenId(requestData.getStrType());
            }
            catch (RxException ex) {
                throw new CreateSequenceRefusedFault(ex.getMessage(), AbstractSoapFaultException.Code.Sender);
            }
            if (!activeSctId.equals(receivedSctId)) {
                throw new CreateSequenceRefusedFault(LocalizationMessages.WSRM_1131_SECURITY_TOKEN_AUTHORIZATION_ERROR(receivedSctId, activeSctId), AbstractSoapFaultException.Code.Sender);
            }
        }
        Sequence inboundSequence = this.rc.sequenceManager().createInboundSequence(this.rc.sequenceManager().generateSequenceUID(), receivedSctId, this.calculateSequenceExpirationTime(requestData.getExpiry()));
        if (requestData.getOfferedSequenceId() != null) {
            Sequence outboundSequence = this.rc.sequenceManager().createOutboundSequence(requestData.getOfferedSequenceId(), receivedSctId, this.calculateSequenceExpirationTime(requestData.getOfferedSequenceExpiry()));
            this.rc.sequenceManager().bindSequences(inboundSequence.getId(), outboundSequence.getId());
        }
        if (!this.hasSession(request)) {
            Utilities.startSession(request.endpoint, inboundSequence.getId());
        }
        CreateSequenceResponseData.Builder responseBuilder = CreateSequenceResponseData.getBuilder(inboundSequence.getId());
        if (requestData.getOfferedSequenceId() != null) {
            responseBuilder.acceptedSequenceAcksTo(requestDestination);
        }
        return this.rc.protocolHandler.toPacket(responseBuilder.build(), request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet handleCloseSequenceAction(Packet request) {
        CloseSequenceData requestData = this.rc.protocolHandler.toCloseSequenceData(request);
        this.rc.destinationMessageHandler.processAcknowledgements(requestData.getAcknowledgementData());
        Sequence inboundSequence = this.rc.getSequence(requestData.getSequenceId());
        String boundSequenceId = this.rc.getBoundSequenceId(inboundSequence.getId());
        try {
            this.rc.sequenceManager().closeSequence(inboundSequence.getId());
        }
        finally {
            if (boundSequenceId != null) {
                this.rc.sequenceManager().closeSequence(boundSequenceId);
            }
        }
        CloseSequenceResponseData.Builder responseBuilder = CloseSequenceResponseData.getBuilder(inboundSequence.getId());
        responseBuilder.acknowledgementData(this.rc.destinationMessageHandler.getAcknowledgementData(inboundSequence.getId()));
        return this.rc.protocolHandler.toPacket(responseBuilder.build(), request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet handleTerminateSequenceAction(Packet request) {
        TerminateSequenceData requestData = this.rc.protocolHandler.toTerminateSequenceData(request);
        this.rc.destinationMessageHandler.processAcknowledgements(requestData.getAcknowledgementData());
        Sequence inboundSequence = this.rc.getSequence(requestData.getSequenceId());
        Sequence outboundSeqence = this.rc.getBoundSequence(requestData.getSequenceId());
        try {
            if (outboundSeqence != null) {
                TerminateSequenceData.Builder responseBuilder = TerminateSequenceData.getBuilder(outboundSeqence.getId(), outboundSeqence.getLastMessageNumber());
                responseBuilder.acknowledgementData(this.rc.destinationMessageHandler.getAcknowledgementData(inboundSequence.getId()));
                Packet packet = this.rc.protocolHandler.toPacket(responseBuilder.build(), request);
                return packet;
            }
            TerminateSequenceResponseData.Builder responseBuilder = TerminateSequenceResponseData.getBuilder(inboundSequence.getId());
            responseBuilder.acknowledgementData(this.rc.destinationMessageHandler.getAcknowledgementData(inboundSequence.getId()));
            Packet packet = this.rc.protocolHandler.toPacket(responseBuilder.build(), request);
            return packet;
        }
        finally {
            Utilities.endSessionIfExists(request.endpoint, inboundSequence.getId());
            try {
                this.rc.sequenceManager().terminateSequence(inboundSequence.getId());
            }
            finally {
                if (outboundSeqence != null) {
                    this.rc.sequenceManager().terminateSequence(outboundSeqence.getId());
                }
            }
        }
    }

    private Packet handleSequenceAcknowledgementAction(Packet request) {
        AcknowledgementData ackData = this.rc.protocolHandler.getAcknowledgementData(request.getMessage());
        this.rc.destinationMessageHandler.processAcknowledgements(ackData);
        request.transportBackChannel.close();
        return this.rc.communicator.createNullResponsePacket(request);
    }

    private Packet handleAckRequestedAction(Packet request) {
        AcknowledgementData ackData = this.rc.protocolHandler.getAcknowledgementData(request.getMessage());
        this.rc.destinationMessageHandler.processAcknowledgements(ackData);
        return this.createEmptyAcknowledgementResponse(request, ackData.getAckReqestedSequenceId());
    }

    private Packet createEmptyAcknowledgementResponse(Packet request, String sequenceId) throws RxRuntimeException {
        Packet response = this.rc.communicator.createEmptyResponsePacket(request, this.rc.rmVersion.sequenceAcknowledgementAction);
        this.rc.protocolHandler.appendAcknowledgementHeaders(response, this.rc.destinationMessageHandler.getAcknowledgementData(sequenceId));
        return response;
    }

    private Session getSession(Packet packet) {
        String sessionId = (String)packet.invocationProperties.get("com.sun.xml.ws.sessionid");
        if (sessionId == null) {
            return null;
        }
        return SessionManager.getSessionManager(packet.endpoint).getSession(sessionId);
    }

    private boolean hasSession(Packet packet) {
        return this.getSession(packet) != null;
    }

    private void setSession(String sessionId, Packet packet) {
        packet.invocationProperties.put("com.sun.xml.ws.sessionid", sessionId);
        Session session = SessionManager.getSessionManager(packet.endpoint).getSession(sessionId);
        packet.invocationProperties.put("com.sun.xml.ws.session", session.getUserData());
    }

    private void exposeSequenceDataToUser(JaxwsApplicationMessage message) {
        message.getPacket().invocationProperties.put(SEQUENCE_PROPERTY, message.getSequenceId());
        message.getPacket().invocationProperties.put(MESSAGE_NUMBER_PROPERTY, message.getMessageNumber());
    }

    private final String getSecurityContextTokenId(Packet packet) {
        Session session = this.getSession(packet);
        return session != null ? session.getSecurityInfo().getIdentifier() : null;
    }

    public final boolean isSecurityContextTokenIdValid(String expectedSctId, Packet packet) {
        String actualSctId = this.getSecurityContextTokenId(packet);
        return expectedSctId != null ? expectedSctId.equals(actualSctId) : actualSctId == null;
    }

    private final long calculateSequenceExpirationTime(long expiryDuration) {
        if (expiryDuration == -1L) {
            return -1L;
        }
        return expiryDuration + this.rc.sequenceManager().currentTimeInMillis();
    }
}

