/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm;

import com.sun.xml.ws.api.FeatureConstructor;
import com.sun.xml.ws.rx.rm.RmVersion;
import javax.xml.ws.WebServiceFeature;

public class ReliableMessagingFeature
extends WebServiceFeature {
    public static final String ID = "com.sun.xml.ws.rm.ReliableMessagingFeature";
    public static final long DEFAULT_SEQUENCE_INACTIVITY_TIMEOUT = 600000L;
    public static final long DEFAULT_DESTINATION_BUFFER_QUOTA = 32L;
    public static final long DEFAULT_MESSAGE_RETRANSMISSION_INTERVAL = 2000L;
    public static final long DEFAULT_ACK_REQUESTED_INTERVAL = 200L;
    public static final long DEFAULT_CLOSE_SEQUENCE_OPERATION_TIMEOUT = 3000L;
    private final RmVersion version;
    private final long sequenceInactivityTimeout;
    private final long destinationBufferQuota;
    private final boolean orderedDelivery;
    private final DeliveryAssurance deliveryAssurance;
    private final SecurityBinding securityBinding;
    private final long messageRetransmissionInterval;
    private final BackoffAlgorithm retransmissionBackoffAlgorithm;
    private final long ackRequestInterval;
    private final long closeSequenceOperationTimeout;

    public ReliableMessagingFeature() {
        this(true);
    }

    public ReliableMessagingFeature(boolean enabled) {
        this(enabled, RmVersion.getDefault(), 600000L, 32L, false, DeliveryAssurance.getDefault(), SecurityBinding.getDefault(), 2000L, BackoffAlgorithm.getDefault(), 200L, 3000L);
    }

    @FeatureConstructor(value={"enabled", "version", "sequenceInactivityTimeout", "destinationBufferQuota", "orderedDeliveryEnabled", "makeConnectionEnabled", "deliveryAssurance", "securityBinding"})
    public ReliableMessagingFeature(boolean enabled, RmVersion version, long inactivityTimeout, long bufferQuota, boolean orderedDelivery, DeliveryAssurance deliveryAssurance, SecurityBinding securityBinding) {
        this(enabled, version, inactivityTimeout, bufferQuota, orderedDelivery, deliveryAssurance, securityBinding, 2000L, BackoffAlgorithm.getDefault(), 200L, 3000L);
    }

    public ReliableMessagingFeature(boolean enabled, RmVersion version, long inactivityTimeout, long bufferQuota, boolean orderedDelivery, DeliveryAssurance deliveryAssurance, SecurityBinding securityBinding, long messageRetransmissionInterval, BackoffAlgorithm retransmissionBackoffAlgorithm, long ackRequestInterval, long closeSequenceOperationTimeout) {
        this.enabled = enabled;
        this.version = version;
        this.sequenceInactivityTimeout = inactivityTimeout;
        this.destinationBufferQuota = bufferQuota;
        this.orderedDelivery = orderedDelivery;
        this.deliveryAssurance = deliveryAssurance;
        this.securityBinding = securityBinding;
        this.messageRetransmissionInterval = messageRetransmissionInterval;
        this.retransmissionBackoffAlgorithm = retransmissionBackoffAlgorithm;
        this.ackRequestInterval = ackRequestInterval;
        this.closeSequenceOperationTimeout = closeSequenceOperationTimeout;
    }

    public String getID() {
        return ID;
    }

    public RmVersion getVersion() {
        return this.version;
    }

    public long getSequenceInactivityTimeout() {
        return this.sequenceInactivityTimeout;
    }

    public SecurityBinding getSecurityBinding() {
        return this.securityBinding;
    }

    public DeliveryAssurance getDeliveryAssurance() {
        return this.deliveryAssurance;
    }

    public boolean isOrderedDeliveryEnabled() {
        return this.orderedDelivery;
    }

    public long getDestinationBufferQuota() {
        return this.destinationBufferQuota;
    }

    public long getMessageRetransmissionInterval() {
        return this.messageRetransmissionInterval;
    }

    public BackoffAlgorithm getRetransmissionBackoffAlgorithm() {
        return this.retransmissionBackoffAlgorithm;
    }

    public long getAcknowledgementRequestInterval() {
        return this.ackRequestInterval;
    }

    public long getCloseSequenceOperationTimeout() {
        return this.closeSequenceOperationTimeout;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BackoffAlgorithm {
        LINEAR{

            public long nextResendTime(int resendAttemptNumber, long baseRate) {
                return System.currentTimeMillis() + baseRate;
            }
        }
        ,
        EXPONENTIAL{

            public long nextResendTime(int resendAttemptNumber, long baseRate) {
                return System.currentTimeMillis() + (long)resendAttemptNumber * baseRate;
            }
        };


        public static BackoffAlgorithm getDefault() {
            return LINEAR;
        }

        public abstract long nextResendTime(int var1, long var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeliveryAssurance {
        EXACTLY_ONCE,
        AT_LEAST_ONCE,
        AT_MOST_ONCE;


        public static DeliveryAssurance getDefault() {
            return EXACTLY_ONCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SecurityBinding {
        STR,
        TRANSPORT,
        NONE;


        public static SecurityBinding getDefault() {
            return NONE;
        }
    }
}

