/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.dump;

import com.sun.istack.Nullable;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.assembler.ClientTubelineAssemblyContext;
import com.sun.xml.ws.assembler.ServerTubelineAssemblyContext;
import com.sun.xml.ws.assembler.TubeFactory;
import javax.xml.ws.WebServiceException;

public final class ActionDumpTubeFactory
implements TubeFactory {
    public static final String CLIENT_NAME = "com.sun.xml.ws.assembler.client.action";
    public static final String SERVER_NAME = "com.sun.xml.ws.assembler.server.action";

    public Tube createTube(ClientTubelineAssemblyContext context) throws WebServiceException {
        if (Boolean.getBoolean(CLIENT_NAME)) {
            return new ActionDumpTube(CLIENT_NAME, context.getBinding(), context.getTubelineHead());
        }
        return context.getTubelineHead();
    }

    public Tube createTube(ServerTubelineAssemblyContext context) throws WebServiceException {
        if (Boolean.getBoolean(SERVER_NAME)) {
            return new ActionDumpTube(SERVER_NAME, context.getEndpoint().getBinding(), context.getTubelineHead());
        }
        return context.getTubelineHead();
    }

    private static class ActionDumpTube
    extends AbstractFilterTubeImpl {
        private final String name;
        private final WSBinding binding;

        public ActionDumpTube(String name, WSBinding binding, Tube next) {
            super(next);
            this.name = name;
            this.binding = binding;
        }

        private ActionDumpTube(ActionDumpTube original, TubeCloner cloner) {
            super(original, cloner);
            this.name = original.name;
            this.binding = original.binding;
        }

        public ActionDumpTube copy(TubeCloner cloner) {
            return new ActionDumpTube(this, cloner);
        }

        public NextAction processRequest(Packet request) {
            this.dumpAction(request.getMessage());
            return super.processRequest(request);
        }

        public NextAction processResponse(Packet response) {
            this.dumpAction(response.getMessage());
            return super.processResponse(response);
        }

        private void dumpAction(@Nullable Message message) {
            if (message != null) {
                try {
                    Message messageCopy = message.copy();
                    String to = messageCopy.getHeaders().getTo(this.binding.getAddressingVersion(), this.binding.getSOAPVersion());
                    String action = messageCopy.getHeaders().getAction(this.binding.getAddressingVersion(), this.binding.getSOAPVersion());
                    System.out.println("{To, Action}: {" + to + ", " + action + "}");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

