/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.policy.spi_impl;

import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.spi.PolicyAssertionValidator;
import com.sun.xml.ws.rx.policy.assertion.AckRequestIntervalClientAssertion;
import com.sun.xml.ws.rx.policy.assertion.AllowDuplicatesAssertion;
import com.sun.xml.ws.rx.policy.assertion.AssertionNamespace;
import com.sun.xml.ws.rx.policy.assertion.CloseTimeoutClientAssertion;
import com.sun.xml.ws.rx.policy.assertion.InactivityTimeoutAssertion;
import com.sun.xml.ws.rx.policy.assertion.MakeConnectionSupportedAssertion;
import com.sun.xml.ws.rx.policy.assertion.OrderedDeliveryAssertion;
import com.sun.xml.ws.rx.policy.assertion.ResendIntervalClientAssertion;
import com.sun.xml.ws.rx.policy.assertion.Rm10Assertion;
import com.sun.xml.ws.rx.policy.assertion.Rm11Assertion;
import com.sun.xml.ws.rx.policy.assertion.RmFlowControlAssertion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;

public class RxAssertionValidator
implements PolicyAssertionValidator {
    private static final ArrayList<QName> SERVER_SIDE_ASSERTIONS = new ArrayList(5);
    private static final ArrayList<QName> CLIENT_SIDE_ASSERTIONS = new ArrayList(8);
    private static final List<String> SUPPORTED_DOMAINS = Collections.unmodifiableList(AssertionNamespace.namespacesList());

    public PolicyAssertionValidator.Fitness validateClientSide(PolicyAssertion assertion) {
        return CLIENT_SIDE_ASSERTIONS.contains(assertion.getName()) ? PolicyAssertionValidator.Fitness.SUPPORTED : PolicyAssertionValidator.Fitness.UNKNOWN;
    }

    public PolicyAssertionValidator.Fitness validateServerSide(PolicyAssertion assertion) {
        QName assertionName = assertion.getName();
        if (SERVER_SIDE_ASSERTIONS.contains(assertionName)) {
            return PolicyAssertionValidator.Fitness.SUPPORTED;
        }
        if (CLIENT_SIDE_ASSERTIONS.contains(assertionName)) {
            return PolicyAssertionValidator.Fitness.UNSUPPORTED;
        }
        return PolicyAssertionValidator.Fitness.UNKNOWN;
    }

    public String[] declareSupportedDomains() {
        return SUPPORTED_DOMAINS.toArray(new String[SUPPORTED_DOMAINS.size()]);
    }

    static {
        SERVER_SIDE_ASSERTIONS.add(Rm10Assertion.NAME);
        SERVER_SIDE_ASSERTIONS.add(Rm11Assertion.NAME);
        SERVER_SIDE_ASSERTIONS.add(MakeConnectionSupportedAssertion.NAME);
        SERVER_SIDE_ASSERTIONS.add(OrderedDeliveryAssertion.NAME);
        SERVER_SIDE_ASSERTIONS.add(AllowDuplicatesAssertion.NAME);
        SERVER_SIDE_ASSERTIONS.add(RmFlowControlAssertion.NAME);
        SERVER_SIDE_ASSERTIONS.add(InactivityTimeoutAssertion.NAME);
        CLIENT_SIDE_ASSERTIONS.add(AckRequestIntervalClientAssertion.NAME);
        CLIENT_SIDE_ASSERTIONS.add(ResendIntervalClientAssertion.NAME);
        CLIENT_SIDE_ASSERTIONS.add(CloseTimeoutClientAssertion.NAME);
        CLIENT_SIDE_ASSERTIONS.addAll(SERVER_SIDE_ASSERTIONS);
    }
}

