/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy;

import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.model.wsdl.WSDLService;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.spi.ModelConfiguratorProvider;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.ws.policy.privateutil.PolicyUtils;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyUtil {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyUtil.class);
    private static ModelConfiguratorProvider[] configurators = PolicyUtils.ServiceProvider.load(ModelConfiguratorProvider.class);

    public static void configureModel(WSDLModel model, PolicyMap policyMap) throws PolicyException {
        LOGGER.entering(model, policyMap);
        for (WSDLService wSDLService : model.getServices().values()) {
            for (WSDLPort wSDLPort : wSDLService.getPorts()) {
                Collection<WebServiceFeature> features = PolicyUtil.getPortScopedFeatures(policyMap, wSDLService.getName(), wSDLPort.getName());
                for (WebServiceFeature feature : features) {
                    wSDLPort.addFeature(feature);
                    wSDLPort.getBinding().addFeature(feature);
                }
            }
        }
        LOGGER.exiting();
    }

    public static Collection<WebServiceFeature> getPortScopedFeatures(PolicyMap policyMap, QName serviceName, QName portName) {
        LOGGER.entering(policyMap, serviceName, portName);
        ArrayList<WebServiceFeature> features = new ArrayList<WebServiceFeature>();
        try {
            PolicyMapKey key = PolicyMap.createWsdlEndpointScopeKey(serviceName, portName);
            for (ModelConfiguratorProvider configurator : configurators) {
                Collection<WebServiceFeature> additionalFeatures = configurator.getFeatures(key, policyMap);
                if (additionalFeatures == null) continue;
                features.addAll(additionalFeatures);
            }
        }
        catch (PolicyException e) {
            throw new WebServiceException((Throwable)e);
        }
        LOGGER.exiting(features);
        return features;
    }
}

