/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl;

import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.STSAttributeProvider;
import com.sun.xml.wss.saml.util.SAMLUtil;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSTSAttributeProvider
implements STSAttributeProvider {
    private static final String SAML_1_0_NS = "urn:oasis:names:tc:SAML:1.0:assertion";
    private static final String SAML_2_0_NS = "urn:oasis:names:tc:SAML:2.0:assertion";

    @Override
    public Map<QName, List<String>> getClaimedAttributes(Subject subject, String appliesTo, String tokenType, Claims claims) {
        Set<Principal> principals = subject.getPrincipals();
        HashMap<QName, List<String>> attrs = new HashMap<QName, List<String>>();
        if (principals != null && !principals.isEmpty()) {
            Iterator<Principal> iterator = principals.iterator();
            while (iterator.hasNext()) {
                String name = principals.iterator().next().getName();
                if (name == null) continue;
                ArrayList<String> nameIds = new ArrayList<String>();
                nameIds.add(name);
                attrs.put(new QName("http://sun.com", "NameID"), nameIds);
                break;
            }
        } else {
            Set<Object> set = subject.getPublicCredentials();
            Node samlAssertion = null;
            try {
                for (Object obj : set) {
                    if (!(obj instanceof XMLStreamReader)) continue;
                    XMLStreamReader reader = (XMLStreamReader)obj;
                    samlAssertion = SAMLUtil.createSAMLAssertion(reader);
                }
            }
            catch (Exception ex) {
                samlAssertion = null;
            }
            if (samlAssertion != null) {
                String uri = samlAssertion.getNamespaceURI();
                ArrayList<String> nameIds = new ArrayList<String>();
                NodeList nl = null;
                if (SAML_1_0_NS.equals(uri)) {
                    nl = samlAssertion.getElementsByTagNameNS(SAML_1_0_NS, "NameIdentifier");
                } else if (SAML_2_0_NS.equals(uri)) {
                    nl = samlAssertion.getElementsByTagNameNS(SAML_2_0_NS, "NameID");
                }
                if (nl != null && nl.getLength() > 0) {
                    Element nameId = (Element)nl.item(0);
                    nameIds.add(nameId.getFirstChild().getNodeValue());
                }
                attrs.put(new QName("http://sun.com", "NameID"), nameIds);
            }
        }
        QName key = new QName("http://sun.com", "token-requestor");
        ArrayList<String> tokenRequestor = new ArrayList<String>();
        tokenRequestor.add("authenticated");
        attrs.put(key, tokenRequestor);
        return attrs;
    }
}

