/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.model;

import com.sun.istack.NotNull;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.model.FieldSignature;
import com.sun.xml.ws.model.Injector;
import com.sun.xml.ws.org.objectweb.asm.AnnotationVisitor;
import com.sun.xml.ws.org.objectweb.asm.ClassWriter;
import com.sun.xml.ws.org.objectweb.asm.FieldVisitor;
import com.sun.xml.ws.org.objectweb.asm.MethodVisitor;
import com.sun.xml.ws.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperBeanGenerator {
    private static final Logger LOGGER = Logger.getLogger(WrapperBeanGenerator.class.getName());
    private static final String PD = ".";
    private static final String JAXWS = "jaxws";
    private static final String JAXWS_PACKAGE_PD = "jaxws.";
    private static final String PD_JAXWS_PACKAGE_PD = ".jaxws.";
    private static final Class[] jaxbAnns = new Class[]{XmlAttachmentRef.class, XmlMimeType.class, XmlJavaTypeAdapter.class, XmlList.class, XmlElement.class};
    private static final Map<String, String> reservedWords = new HashMap<String, String>();
    private static final Set<String> skipProperties;

    private static byte[] createBeanImage(String className, String rootName, String rootNS, String typeName, String typeNS, String[] propOrder, List<Field> fields) throws Exception {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(49, 33, WrapperBeanGenerator.replaceDotWithSlash(className), null, "java/lang/Object", null);
        AnnotationVisitor root = cw.visitAnnotation("Ljavax/xml/bind/annotation/XmlRootElement;", true);
        root.visit("name", rootName);
        root.visit("namespace", rootNS);
        root.visitEnd();
        AnnotationVisitor type = cw.visitAnnotation("Ljavax/xml/bind/annotation/XmlType;", true);
        type.visit("name", typeName);
        type.visit("namespace", typeNS);
        if (propOrder.length > 1) {
            AnnotationVisitor propVisitor = type.visitArray("propOrder");
            for (String prop : propOrder) {
                propVisitor.visit("propOrder", prop);
            }
            propVisitor.visitEnd();
        }
        type.visitEnd();
        for (Field field : fields) {
            FieldVisitor fv = cw.visitField(1, field.fieldName, field.asmType.getDescriptor(), field.getSignature(), null);
            if (!field.noXmlElem) {
                AnnotationVisitor elem = fv.visitAnnotation("Ljavax/xml/bind/annotation/XmlElement;", true);
                elem.visit("name", field.elementName);
                elem.visit("namespace", field.elementNS);
                if (field.reflectType instanceof GenericArrayType) {
                    elem.visit("nillable", true);
                }
                elem.visitEnd();
            }
            for (Annotation ann : field.jaxbAnnotations) {
                if (ann instanceof XmlMimeType) {
                    AnnotationVisitor mime = fv.visitAnnotation("Ljavax/xml/bind/annotation/XmlMimeType;", true);
                    mime.visit("value", ((XmlMimeType)ann).value());
                    mime.visitEnd();
                    continue;
                }
                if (ann instanceof XmlJavaTypeAdapter) {
                    AnnotationVisitor ada = fv.visitAnnotation("Ljavax/xml/bind/annotation/XmlJavaTypeAdapter;", true);
                    ada.visit("value", ((XmlJavaTypeAdapter)ann).value());
                    ada.visit("type", ((XmlJavaTypeAdapter)ann).type());
                    ada.visitEnd();
                    continue;
                }
                if (ann instanceof XmlAttachmentRef) {
                    AnnotationVisitor att = fv.visitAnnotation("Ljavax/xml/bind/annotation/XmlAttachmentRef;", true);
                    att.visitEnd();
                    continue;
                }
                if (ann instanceof XmlList) {
                    AnnotationVisitor list = fv.visitAnnotation("Ljavax/xml/bind/annotation/XmlList;", true);
                    list.visitEnd();
                    continue;
                }
                if (ann instanceof XmlElement) {
                    AnnotationVisitor elem = fv.visitAnnotation("Ljavax/xml/bind/annotation/XmlElement;", true);
                    elem.visit("name", ((XmlElement)ann).name());
                    elem.visit("namespace", ((XmlElement)ann).namespace());
                    elem.visit("nillable", ((XmlElement)ann).nillable());
                    elem.visit("required", ((XmlElement)ann).required());
                    elem.visitEnd();
                    continue;
                }
                throw new WebServiceException("Unknown JAXB annotation " + ann);
            }
            fv.visitEnd();
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        if (LOGGER.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append("@XmlRootElement(name=");
            sb.append(rootName);
            sb.append(", namespace=");
            sb.append(rootNS);
            sb.append(")");
            sb.append("\n");
            sb.append("@XmlType(name=");
            sb.append(typeName);
            sb.append(", namespace=");
            sb.append(typeNS);
            if (propOrder.length > 1) {
                sb.append(", propOrder={");
                for (int i = 0; i < propOrder.length; ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append(propOrder[i]);
                }
                sb.append("}");
            }
            sb.append(")");
            sb.append("\n");
            sb.append("public class ");
            sb.append(className);
            sb.append(" {");
            for (Field field : fields) {
                sb.append("\n");
                if (!field.noXmlElem) {
                    sb.append("\n    ");
                    sb.append("@XmlRootElement(name=");
                    sb.append(field.elementName);
                    sb.append(", namespace=");
                    sb.append(field.elementNS);
                    if (field.reflectType instanceof GenericArrayType) {
                        sb.append("nillable=true");
                    }
                    sb.append(")");
                }
                for (Annotation ann : field.jaxbAnnotations) {
                    sb.append("\n    ");
                    if (ann instanceof XmlMimeType) {
                        sb.append("@XmlMimeType(value=");
                        sb.append(((XmlMimeType)ann).value());
                        sb.append(")");
                        continue;
                    }
                    if (ann instanceof XmlJavaTypeAdapter) {
                        sb.append("@XmlJavaTypeAdapter(value=");
                        sb.append(((XmlMimeType)ann).value());
                        sb.append(", type=");
                        sb.append(((XmlJavaTypeAdapter)ann).type());
                        sb.append(")");
                        continue;
                    }
                    if (ann instanceof XmlAttachmentRef) {
                        sb.append("@XmlAttachmentRef");
                        continue;
                    }
                    if (ann instanceof XmlList) {
                        sb.append("@XmlList");
                        continue;
                    }
                    if (ann instanceof XmlElement) {
                        sb.append("@XmlElement(TODO)");
                        continue;
                    }
                    throw new WebServiceException("Unknown JAXB annotation " + ann);
                }
                sb.append("\n    ");
                sb.append("public ");
                if (field.getSignature() == null) {
                    sb.append(field.asmType.getDescriptor());
                } else {
                    sb.append(field.getSignature());
                }
                sb.append(" ");
                sb.append(field.fieldName);
            }
            sb.append("\n\n}");
            LOGGER.fine(sb.toString());
        }
        return cw.toByteArray();
    }

    private static String replaceDotWithSlash(String name) {
        return name.replace('.', '/');
    }

    static Class createRequestWrapperBean(String className, Method method, QName reqElemName, ClassLoader cl) {
        byte[] image;
        LOGGER.fine("Request Wrapper Class : " + className);
        List<Field> fields = WrapperBeanGenerator.collectRequestWrapperMembers(method);
        String[] propOrder = WrapperBeanGenerator.getPropOrder(fields);
        try {
            image = WrapperBeanGenerator.createBeanImage(className, reqElemName.getLocalPart(), reqElemName.getNamespaceURI(), reqElemName.getLocalPart(), reqElemName.getNamespaceURI(), propOrder, fields);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
        return Injector.inject(cl, className, image);
    }

    static Class createResponseWrapperBean(String className, Method method, QName resElemName, ClassLoader cl) {
        byte[] image;
        LOGGER.fine("Response Wrapper Class : " + className);
        List<Field> fields = WrapperBeanGenerator.collectResponseWrapperMembers(method);
        String[] propOrder = WrapperBeanGenerator.getPropOrder(fields);
        try {
            image = WrapperBeanGenerator.createBeanImage(className, resElemName.getLocalPart(), resElemName.getNamespaceURI(), resElemName.getLocalPart(), resElemName.getNamespaceURI(), propOrder, fields);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
        return Injector.inject(cl, className, image);
    }

    private static String[] getPropOrder(List<Field> fields) {
        String[] propOrder = new String[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            propOrder[i] = fields.get(i).fieldName;
        }
        return propOrder;
    }

    private static List<Field> collectRequestWrapperMembers(Method method) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Annotation[][] paramAnns = method.getParameterAnnotations();
        Type[] paramTypes = method.getGenericParameterTypes();
        com.sun.xml.ws.org.objectweb.asm.Type[] asmTypes = com.sun.xml.ws.org.objectweb.asm.Type.getArgumentTypes(method);
        for (int i = 0; i < paramTypes.length; ++i) {
            WebParam webParam = WrapperBeanGenerator.findAnnotation(paramAnns[i], WebParam.class);
            if (webParam != null && webParam.header()) continue;
            List<Annotation> jaxb = WrapperBeanGenerator.collectJAXBAnnotations(paramAnns[i]);
            Type paramType = WrapperBeanGenerator.getHolderValueType(paramTypes[i]);
            com.sun.xml.ws.org.objectweb.asm.Type asmType = WrapperBeanGenerator.isHolder(paramTypes[i]) ? WrapperBeanGenerator.getASMType(paramType) : asmTypes[i];
            String paramNamespace = "";
            String paramName = "arg" + i;
            WebParam.Mode mode = WebParam.Mode.IN;
            if (webParam != null) {
                mode = webParam.mode();
                if (webParam.name().length() > 0) {
                    paramName = webParam.name();
                }
                if (webParam.targetNamespace().length() > 0) {
                    paramNamespace = webParam.targetNamespace();
                }
            }
            String fieldName = JAXBRIContext.mangleNameToVariableName(paramName);
            fieldName = WrapperBeanGenerator.getJavaReservedVarialbeName(fieldName);
            Field memInfo = new Field(fieldName, paramType, asmType, paramName, paramNamespace, jaxb);
            if (!mode.equals((Object)WebParam.Mode.IN) && !mode.equals((Object)WebParam.Mode.INOUT)) continue;
            fields.add(memInfo);
        }
        return fields;
    }

    private static List<Field> collectResponseWrapperMembers(Method method) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Annotation[][] paramAnns = method.getParameterAnnotations();
        Type[] paramTypes = method.getGenericParameterTypes();
        com.sun.xml.ws.org.objectweb.asm.Type[] asmTypes = com.sun.xml.ws.org.objectweb.asm.Type.getArgumentTypes(method);
        for (int i = 0; i < paramTypes.length; ++i) {
            WebParam webParam = WrapperBeanGenerator.findAnnotation(paramAnns[i], WebParam.class);
            if (webParam != null && (webParam.header() || webParam.mode() == WebParam.Mode.IN) || !WrapperBeanGenerator.isHolder(paramTypes[i])) continue;
            List<Annotation> jaxb = WrapperBeanGenerator.collectJAXBAnnotations(paramAnns[i]);
            Type paramType = WrapperBeanGenerator.getHolderValueType(paramTypes[i]);
            com.sun.xml.ws.org.objectweb.asm.Type asmType = WrapperBeanGenerator.getASMType(paramType);
            String paramNamespace = "";
            String paramName = "arg" + i;
            if (webParam != null) {
                if (webParam.name().length() > 0) {
                    paramName = webParam.name();
                }
                if (webParam.targetNamespace().length() > 0) {
                    paramNamespace = webParam.targetNamespace();
                }
            }
            String fieldName = JAXBRIContext.mangleNameToVariableName(paramName);
            fieldName = WrapperBeanGenerator.getJavaReservedVarialbeName(fieldName);
            fields.add(new Field(fieldName, paramType, asmType, paramName, paramNamespace, jaxb));
        }
        WebResult webResult = method.getAnnotation(WebResult.class);
        Type returnType = method.getGenericReturnType();
        com.sun.xml.ws.org.objectweb.asm.Type asmType = com.sun.xml.ws.org.objectweb.asm.Type.getReturnType(method);
        if (!(webResult != null && webResult.header() || returnType == Void.TYPE)) {
            String fieldElementName = "return";
            String fieldName = "_return";
            String fieldNamespace = "";
            if (webResult != null) {
                if (webResult.name().length() > 0) {
                    fieldElementName = webResult.name();
                    fieldName = JAXBRIContext.mangleNameToVariableName(webResult.name());
                    fieldName = WrapperBeanGenerator.getJavaReservedVarialbeName(fieldName);
                }
                if (webResult.targetNamespace().length() > 1) {
                    fieldNamespace = webResult.targetNamespace();
                }
            }
            List<Annotation> jaxb = WrapperBeanGenerator.collectJAXBAnnotations(method.getAnnotations());
            fields.add(new Field(fieldName, returnType, asmType, fieldElementName, fieldNamespace, jaxb));
        }
        return fields;
    }

    private static boolean isHolder(Type type) {
        ParameterizedType p;
        return type instanceof ParameterizedType && (p = (ParameterizedType)type).getRawType().equals(Holder.class);
    }

    private static com.sun.xml.ws.org.objectweb.asm.Type getASMType(Type t) {
        TypeVariable tv;
        ParameterizedType pt;
        assert (t != null);
        if (t instanceof Class) {
            return com.sun.xml.ws.org.objectweb.asm.Type.getType((Class)t);
        }
        if (t instanceof ParameterizedType && (pt = (ParameterizedType)t).getRawType() instanceof Class) {
            return com.sun.xml.ws.org.objectweb.asm.Type.getType((Class)pt.getRawType());
        }
        if (t instanceof GenericArrayType) {
            // empty if block
        }
        if (t instanceof WildcardType) {
            // empty if block
        }
        if (t instanceof TypeVariable && (tv = (TypeVariable)t).getBounds()[0] instanceof Class) {
            return com.sun.xml.ws.org.objectweb.asm.Type.getType((Class)tv.getBounds()[0]);
        }
        assert (false);
        throw new IllegalArgumentException("Not creating ASM Type for type = " + t);
    }

    private static Type getHolderValueType(Type paramType) {
        ParameterizedType p;
        if (paramType instanceof ParameterizedType && (p = (ParameterizedType)paramType).getRawType().equals(Holder.class)) {
            return p.getActualTypeArguments()[0];
        }
        return paramType;
    }

    private static <T extends Annotation> T findAnnotation(Annotation[] anns, Class<T> annotationClass) {
        for (Annotation a : anns) {
            if (a.annotationType() != annotationClass) continue;
            return (T)a;
        }
        return null;
    }

    static Class createExceptionBean(String className, Class exception, String typeNS, String elemName, String elemNS, ClassLoader cl) {
        byte[] image;
        List<Field> fields = WrapperBeanGenerator.collectExceptionProperties(exception);
        String[] propOrder = WrapperBeanGenerator.getPropOrder(fields);
        try {
            image = WrapperBeanGenerator.createBeanImage(className, elemName, elemNS, exception.getSimpleName(), typeNS, propOrder, fields);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
        return Injector.inject(cl, className, image);
    }

    private static List<Field> collectExceptionProperties(Class exception) {
        Method[] methods;
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Method method : methods = exception.getMethods()) {
            Field field;
            String fieldName;
            String name;
            int mod = method.getModifiers();
            if (!Modifier.isPublic(mod) || Modifier.isFinal(mod) && Modifier.isStatic(mod) || Modifier.isTransient(mod) || !(name = method.getName()).startsWith("get") && !name.startsWith("is") || skipProperties.contains(name) || name.equals("get") || name.equals("is")) continue;
            Type[] paramTypes = method.getGenericParameterTypes();
            Type returnType = method.getGenericReturnType();
            com.sun.xml.ws.org.objectweb.asm.Type asmType = com.sun.xml.ws.org.objectweb.asm.Type.getReturnType(method);
            if (paramTypes.length != 0) continue;
            if (name.startsWith("get")) {
                fieldName = StringUtils.decapitalize(name.substring(3));
                field = new Field(fieldName, returnType, asmType, true, Collections.<Annotation>emptyList());
                fields.add(field);
                continue;
            }
            fieldName = StringUtils.decapitalize(name.substring(2));
            field = new Field(fieldName, returnType, asmType, true, Collections.<Annotation>emptyList());
            fields.add(field);
        }
        Collections.sort(fields);
        return fields;
    }

    private static List<Annotation> collectJAXBAnnotations(Annotation[] anns) {
        ArrayList<Annotation> jaxbAnnotation = new ArrayList<Annotation>();
        for (Class c : jaxbAnns) {
            Object a = WrapperBeanGenerator.findAnnotation(anns, c);
            if (a == null) continue;
            jaxbAnnotation.add((Annotation)a);
        }
        return jaxbAnnotation;
    }

    private List<Annotation> collectJAXBAnnotations(Method decl) {
        ArrayList<Annotation> jaxbAnnotation = new ArrayList<Annotation>();
        for (Class jaxbClass : jaxbAnns) {
            Object ann = decl.getAnnotation(jaxbClass);
            if (ann == null) continue;
            jaxbAnnotation.add((Annotation)ann);
        }
        return jaxbAnnotation;
    }

    @NotNull
    private static String getJavaReservedVarialbeName(@NotNull String name) {
        String reservedName = reservedWords.get(name);
        return reservedName == null ? name : reservedName;
    }

    static {
        reservedWords.put("abstract", "_abstract");
        reservedWords.put("assert", "_assert");
        reservedWords.put("boolean", "_boolean");
        reservedWords.put("break", "_break");
        reservedWords.put("byte", "_byte");
        reservedWords.put("case", "_case");
        reservedWords.put("catch", "_catch");
        reservedWords.put("char", "_char");
        reservedWords.put("class", "_class");
        reservedWords.put("const", "_const");
        reservedWords.put("continue", "_continue");
        reservedWords.put("default", "_default");
        reservedWords.put("do", "_do");
        reservedWords.put("double", "_double");
        reservedWords.put("else", "_else");
        reservedWords.put("extends", "_extends");
        reservedWords.put("false", "_false");
        reservedWords.put("final", "_final");
        reservedWords.put("finally", "_finally");
        reservedWords.put("float", "_float");
        reservedWords.put("for", "_for");
        reservedWords.put("goto", "_goto");
        reservedWords.put("if", "_if");
        reservedWords.put("implements", "_implements");
        reservedWords.put("import", "_import");
        reservedWords.put("instanceof", "_instanceof");
        reservedWords.put("int", "_int");
        reservedWords.put("interface", "_interface");
        reservedWords.put("long", "_long");
        reservedWords.put("native", "_native");
        reservedWords.put("new", "_new");
        reservedWords.put("null", "_null");
        reservedWords.put("package", "_package");
        reservedWords.put("private", "_private");
        reservedWords.put("protected", "_protected");
        reservedWords.put("public", "_public");
        reservedWords.put("return", "_return");
        reservedWords.put("short", "_short");
        reservedWords.put("static", "_static");
        reservedWords.put("strictfp", "_strictfp");
        reservedWords.put("super", "_super");
        reservedWords.put("switch", "_switch");
        reservedWords.put("synchronized", "_synchronized");
        reservedWords.put("this", "_this");
        reservedWords.put("throw", "_throw");
        reservedWords.put("throws", "_throws");
        reservedWords.put("transient", "_transient");
        reservedWords.put("true", "_true");
        reservedWords.put("try", "_try");
        reservedWords.put("void", "_void");
        reservedWords.put("volatile", "_volatile");
        reservedWords.put("while", "_while");
        reservedWords.put("enum", "_enum");
        skipProperties = new HashSet<String>();
        skipProperties.add("getCause");
        skipProperties.add("getLocalizedMessage");
        skipProperties.add("getClass");
        skipProperties.add("getStackTrace");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Field
    implements Comparable<Field> {
        private final Type reflectType;
        private final com.sun.xml.ws.org.objectweb.asm.Type asmType;
        private final String fieldName;
        private final String elementName;
        private final String elementNS;
        private final List<Annotation> jaxbAnnotations;
        private final boolean noXmlElem;

        Field(String paramName, Type paramType, com.sun.xml.ws.org.objectweb.asm.Type asmType, String elementName, String elementNS, List<Annotation> jaxbAnnotations) {
            this(paramName, paramType, asmType, false, elementName, elementNS, jaxbAnnotations);
        }

        Field(String paramName, Type paramType, com.sun.xml.ws.org.objectweb.asm.Type asmType, boolean noXmlElem, List<Annotation> jaxbAnnotations) {
            this(paramName, paramType, asmType, noXmlElem, null, null, jaxbAnnotations);
        }

        Field(String paramName, Type paramType, com.sun.xml.ws.org.objectweb.asm.Type asmType, boolean noXmlElem, String elementName, String elementNS, List<Annotation> jaxbAnnotations) {
            this.reflectType = paramType;
            this.asmType = asmType;
            this.fieldName = paramName;
            this.noXmlElem = noXmlElem;
            this.elementName = elementName;
            this.elementNS = elementNS;
            this.jaxbAnnotations = jaxbAnnotations;
        }

        String getSignature() {
            if (this.reflectType instanceof Class) {
                return null;
            }
            if (this.reflectType instanceof TypeVariable) {
                return null;
            }
            return FieldSignature.vms(this.reflectType);
        }

        @Override
        public int compareTo(Field o) {
            return this.fieldName.compareTo(o.fieldName);
        }
    }
}

