/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util.pipe;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.developer.SchemaValidationFeature;
import com.sun.xml.ws.developer.ValidationErrorHandler;
import com.sun.xml.ws.util.ByteArrayBuffer;
import com.sun.xml.ws.util.MetadataUtil;
import com.sun.xml.ws.util.xml.MetadataDocument;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchemaValidationTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(AbstractSchemaValidationTube.class.getName());
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected final WSBinding binding;
    protected final SchemaValidationFeature feature;
    protected final DocumentAddressResolver resolver = new ValidationDocumentAddressResolver();
    protected final SchemaFactory sf;
    protected final boolean honorAllSchemaLocations;

    public AbstractSchemaValidationTube(WSBinding binding, Tube next) {
        super(next);
        this.binding = binding;
        this.feature = binding.getFeature(SchemaValidationFeature.class);
        this.sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        boolean allLocations = false;
        try {
            this.sf.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, true);
            allLocations = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        this.honorAllSchemaLocations = allLocations;
    }

    protected AbstractSchemaValidationTube(AbstractSchemaValidationTube that, TubeCloner cloner) {
        super(that, cloner);
        this.binding = that.binding;
        this.feature = that.feature;
        this.sf = that.sf;
        this.honorAllSchemaLocations = that.honorAllSchemaLocations;
    }

    protected abstract Validator getValidator();

    protected abstract boolean isNoValidation();

    protected Document createDOM(SDDocument doc) {
        ByteArrayBuffer bab = new ByteArrayBuffer();
        try {
            doc.writeTo(null, this.resolver, bab);
        }
        catch (IOException ioe) {
            throw new WebServiceException((Throwable)ioe);
        }
        Transformer trans = XmlUtil.newTransformer();
        StreamSource source = new StreamSource(bab.newInputStream(), null);
        DOMResult result = new DOMResult();
        try {
            trans.transform(source, result);
        }
        catch (TransformerException te) {
            throw new WebServiceException((Throwable)te);
        }
        return (Document)result.getNode();
    }

    protected Source[] getSchemaSources(Iterable<SDDocument> docs, MetadataResolverImpl mdresolver) {
        HashMap<String, DOMSource> inlinedSchemas = new HashMap<String, DOMSource>();
        for (SDDocument sdoc : docs) {
            if (!sdoc.isWSDL()) continue;
            Document dom = this.createDOM(sdoc);
            this.addSchemaFragmentSource(dom, sdoc.getURL().toExternalForm(), inlinedSchemas);
        }
        LOGGER.fine("WSDL inlined schema fragment documents(these are used to create a pseudo schema) = " + inlinedSchemas.keySet());
        if (inlinedSchemas.isEmpty()) {
            return new Source[0];
        }
        if (inlinedSchemas.size() == 1) {
            return new Source[]{(Source)inlinedSchemas.values().iterator().next()};
        }
        Source pseudoSchema = this.getPseudoSchemaSources(inlinedSchemas);
        ArrayList<Source> sources = new ArrayList<Source>();
        sources.add(pseudoSchema);
        mdresolver.addInlinedSchemas(inlinedSchemas);
        if (this.honorAllSchemaLocations) {
            return new Source[]{pseudoSchema};
        }
        for (SDDocument sdoc : docs) {
            if (!sdoc.isSchema()) continue;
            Document dom = this.createDOM(sdoc);
            sources.add(new DOMSource(dom, sdoc.getURL().toExternalForm()));
        }
        return sources.toArray(new Source[sources.size()]);
    }

    @Nullable
    protected void addSchemaFragmentSource(Document doc, String systemId, List<Source> list) {
        Element e = doc.getDocumentElement();
        assert (e.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/"));
        assert (e.getLocalName().equals("definitions"));
        NodeList typesList = e.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "types");
        for (int i = 0; i < typesList.getLength(); ++i) {
            NodeList schemaList = ((Element)typesList.item(i)).getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
            for (int j = 0; j < schemaList.getLength(); ++j) {
                Element elem = (Element)schemaList.item(j);
                NamespaceSupport nss = new NamespaceSupport();
                this.buildNamespaceSupport(nss, elem);
                this.patchDOMFragment(nss, elem);
                list.add(new DOMSource(elem, systemId + "#schema" + j));
            }
        }
    }

    @Nullable
    protected void addSchemaFragmentSource(Document doc, String systemId, Map<String, DOMSource> map) {
        Element e = doc.getDocumentElement();
        assert (e.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/"));
        assert (e.getLocalName().equals("definitions"));
        NodeList typesList = e.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "types");
        for (int i = 0; i < typesList.getLength(); ++i) {
            NodeList schemaList = ((Element)typesList.item(i)).getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
            for (int j = 0; j < schemaList.getLength(); ++j) {
                Element elem = (Element)schemaList.item(j);
                NamespaceSupport nss = new NamespaceSupport();
                this.buildNamespaceSupport(nss, elem);
                this.patchDOMFragment(nss, elem);
                String docId = systemId + "#schema" + j;
                map.put(docId, new DOMSource(elem, docId));
            }
        }
    }

    private void buildNamespaceSupport(NamespaceSupport nss, Node node) {
        if (node == null || node.getNodeType() != 1) {
            return;
        }
        this.buildNamespaceSupport(nss, node.getParentNode());
        nss.pushContext();
        NamedNodeMap atts = node.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr a = (Attr)atts.item(i);
            if ("xmlns".equals(a.getPrefix())) {
                nss.declarePrefix(a.getLocalName(), a.getValue());
                continue;
            }
            if (!"xmlns".equals(a.getName())) continue;
            nss.declarePrefix("", a.getValue());
        }
    }

    @Nullable
    private void patchDOMFragment(NamespaceSupport nss, Element elem) {
        NamedNodeMap atts = elem.getAttributes();
        Enumeration<String> en = nss.getPrefixes();
        while (en.hasMoreElements()) {
            String prefix = en.nextElement();
            for (int i = 0; i < atts.getLength(); ++i) {
                Attr a = (Attr)atts.item(i);
                if ("xmlns".equals(a.getPrefix()) && a.getLocalName().equals(prefix)) continue;
                LOGGER.fine("Patching with xmlns:" + prefix + "=" + nss.getURI(prefix));
                elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nss.getURI(prefix));
            }
        }
    }

    @Nullable
    protected Source getPseudoSchemaSources(Map<String, DOMSource> pseudo) {
        assert (pseudo.size() > 1);
        StringBuilder sb = new StringBuilder("<xsd:schema xmlns:xsd='http://www.w3.org/2001/XMLSchema' targetNamespace='urn:x-jax-ws'>");
        for (Map.Entry<String, DOMSource> e : pseudo.entrySet()) {
            DOMSource src = e.getValue();
            Element elem = (Element)src.getNode();
            String ns = elem.getAttribute("targetNamespace");
            sb.append("<xsd:import schemaLocation='").append(e.getKey()).append("'");
            if (!ns.equals("")) {
                sb.append(" namespace='").append(ns).append("'");
            }
            sb.append("/>");
        }
        sb.append("</xsd:schema>");
        LOGGER.fine("Pseudo Schema=" + sb);
        return new StreamSource(new StringReader(sb.toString()), "http://pseudo");
    }

    protected void doProcess(Packet packet) throws SAXException {
        ValidationErrorHandler handler;
        this.getValidator().reset();
        Class<? extends ValidationErrorHandler> handlerClass = this.feature.getErrorHandler();
        try {
            handler = handlerClass.newInstance();
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
        handler.setPacket(packet);
        this.getValidator().setErrorHandler(handler);
        Message msg = packet.getMessage().copy();
        Source source = msg.readPayloadAsSource();
        try {
            this.getValidator().validate(source);
        }
        catch (IOException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    protected static void printSource(Source src) {
        try {
            ByteArrayBuffer bos = new ByteArrayBuffer();
            StreamResult sr = new StreamResult(bos);
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.transform(src, sr);
            LOGGER.info("**** src ******" + bos.toString());
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MetadataResolverImpl
    implements MetadataUtil.MetadataResolver,
    LSResourceResolver {
        final Map<String, SDDocument> docs = new HashMap<String, SDDocument>();
        final Map<String, SDDocument> nsMapping = new HashMap<String, SDDocument>();

        public MetadataResolverImpl() {
        }

        public MetadataResolverImpl(Iterable<SDDocument> it) {
            for (SDDocument doc : it) {
                if (!doc.isSchema()) continue;
                this.docs.put(doc.getURL().toExternalForm(), doc);
                this.nsMapping.put(((SDDocument.Schema)doc).getTargetNamespace(), doc);
            }
        }

        public void addInlinedSchemas(Map<String, DOMSource> inlineSchemas) {
            for (Map.Entry<String, DOMSource> e : inlineSchemas.entrySet()) {
                try {
                    XMLStreamBufferResult xsbr = XmlUtil.identityTransform(e.getValue(), new XMLStreamBufferResult());
                    String systemId = e.getKey();
                    SDDocumentSource sds = SDDocumentSource.create(new URL(systemId), xsbr.getXMLStreamBuffer());
                    SDDocument sdoc = MetadataDocument.create(sds, new QName(""), new QName(""));
                    this.docs.put(systemId, sdoc);
                    this.nsMapping.put(((SDDocument.Schema)sdoc).getTargetNamespace(), sdoc);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Exception in adding inlined schemas to resolver", e);
                }
            }
        }

        @Override
        public SDDocument resolveEntity(String systemId) {
            SDDocument sdi = this.docs.get(systemId);
            if (sdi == null) {
                SDDocumentSource sds;
                try {
                    sds = SDDocumentSource.create(new URL(systemId));
                }
                catch (MalformedURLException e) {
                    throw new WebServiceException((Throwable)e);
                }
                sdi = MetadataDocument.create(sds, new QName(""), new QName(""));
                this.docs.put(systemId, sdi);
            }
            return sdi;
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            LOGGER.fine("type=" + type + " namespaceURI=" + namespaceURI + " publicId=" + publicId + " systemId=" + systemId + " baseURI=" + baseURI);
            try {
                SDDocument doc;
                if (systemId == null) {
                    doc = this.nsMapping.get(namespaceURI);
                    Object rel = null;
                } else {
                    URL base = baseURI == null ? null : new URL(baseURI);
                    URL rel = new URL(base, systemId);
                    doc = this.docs.get(rel.toExternalForm());
                }
                if (doc != null) {
                    return new LSInput(){

                        public Reader getCharacterStream() {
                            return null;
                        }

                        public void setCharacterStream(Reader characterStream) {
                            throw new UnsupportedOperationException();
                        }

                        public InputStream getByteStream() {
                            ByteArrayBuffer bab = new ByteArrayBuffer();
                            try {
                                doc.writeTo(null, AbstractSchemaValidationTube.this.resolver, bab);
                            }
                            catch (IOException ioe) {
                                throw new WebServiceException((Throwable)ioe);
                            }
                            return bab.newInputStream();
                        }

                        public void setByteStream(InputStream byteStream) {
                            throw new UnsupportedOperationException();
                        }

                        public String getStringData() {
                            return null;
                        }

                        public void setStringData(String stringData) {
                            throw new UnsupportedOperationException();
                        }

                        public String getSystemId() {
                            return doc.getURL().toExternalForm();
                        }

                        public void setSystemId(String systemId) {
                            throw new UnsupportedOperationException();
                        }

                        public String getPublicId() {
                            return null;
                        }

                        public void setPublicId(String publicId) {
                            throw new UnsupportedOperationException();
                        }

                        public String getBaseURI() {
                            return doc.getURL().toExternalForm();
                        }

                        public void setBaseURI(String baseURI) {
                            throw new UnsupportedOperationException();
                        }

                        public String getEncoding() {
                            return null;
                        }

                        public void setEncoding(String encoding) {
                            throw new UnsupportedOperationException();
                        }

                        public boolean getCertifiedText() {
                            return false;
                        }

                        public void setCertifiedText(boolean certifiedText) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception in LSResourceResolver impl", e);
            }
            LOGGER.fine("Don't know about systemId=" + systemId + " baseURI=" + baseURI);
            return null;
        }
    }

    private static class ValidationDocumentAddressResolver
    implements DocumentAddressResolver {
        private ValidationDocumentAddressResolver() {
        }

        @Nullable
        public String getRelativeAddressFor(@NotNull SDDocument current, @NotNull SDDocument referenced) {
            LOGGER.fine("Current = " + current.getURL() + " resolved relative=" + referenced.getURL());
            return referenced.getURL().toExternalForm();
        }
    }
}

