/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.jaxws.impl;

import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.sourcemodel.PolicyModelTranslator;
import com.sun.xml.ws.policy.sourcemodel.PolicyModelUnmarshaller;
import com.sun.xml.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.ws.rx.rm.api.RmProtocolVersion;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class RMPolicyResolver {
    SecurityPolicyVersion spVersion;
    RmProtocolVersion rmVersion;

    public RMPolicyResolver() {
        this.spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
        this.rmVersion = RmProtocolVersion.getDefault();
    }

    public RMPolicyResolver(SecurityPolicyVersion spVersion, RmProtocolVersion rmVersion) {
        this.spVersion = spVersion;
        this.rmVersion = rmVersion;
    }

    public Policy getOperationLevelPolicy() throws PolicyException {
        PolicySourceModel model;
        try {
            String rmMessagePolicy = "rm-msglevel-policy.xml";
            if (SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri.equals(this.spVersion.namespaceUri) && RmProtocolVersion.WSRM200502.protocolNamespaceUri.equals(this.rmVersion.protocolNamespaceUri)) {
                rmMessagePolicy = "rm-msglevel-policy-sp12.xml";
            } else if (SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri.equals(this.spVersion.namespaceUri) && RmProtocolVersion.WSRM200702.protocolNamespaceUri.equals(this.rmVersion.protocolNamespaceUri)) {
                rmMessagePolicy = "rm-msglevel-policy-sx.xml";
            } else if (SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri.equals(this.spVersion.namespaceUri) && RmProtocolVersion.WSRM200702.protocolNamespaceUri.equals(this.rmVersion.protocolNamespaceUri)) {
                rmMessagePolicy = "rm-msglevel-policy-sx-sp10.xml";
            }
            model = this.unmarshalPolicy("com/sun/xml/ws/security/impl/policyconv/" + rmMessagePolicy);
        }
        catch (IOException ex) {
            throw new PolicyException(ex);
        }
        Policy mbp = PolicyModelTranslator.getTranslator().translate(model);
        return mbp;
    }

    private PolicySourceModel unmarshalPolicy(String resource) throws PolicyException, IOException {
        Reader reader = this.getResourceReader(resource);
        PolicySourceModel model = PolicyModelUnmarshaller.getXmlUnmarshaller().unmarshalModel(reader);
        reader.close();
        return model;
    }

    private Reader getResourceReader(String resourceName) {
        return new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName));
    }
}

