/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl;

import com.sun.org.apache.xml.internal.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.xml.ws.api.security.trust.STSTokenProvider;
import com.sun.xml.ws.api.security.trust.Status;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.trust.GenericToken;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.saml.Advice;
import com.sun.xml.wss.saml.Assertion;
import com.sun.xml.wss.saml.AttributeStatement;
import com.sun.xml.wss.saml.AudienceRestriction;
import com.sun.xml.wss.saml.AudienceRestrictionCondition;
import com.sun.xml.wss.saml.AuthnContext;
import com.sun.xml.wss.saml.AuthnStatement;
import com.sun.xml.wss.saml.Conditions;
import com.sun.xml.wss.saml.KeyInfoConfirmationData;
import com.sun.xml.wss.saml.NameID;
import com.sun.xml.wss.saml.NameIdentifier;
import com.sun.xml.wss.saml.SAMLAssertionFactory;
import com.sun.xml.wss.saml.SAMLException;
import com.sun.xml.wss.saml.Subject;
import com.sun.xml.wss.saml.SubjectConfirmation;
import com.sun.xml.wss.saml.internal.saml20.jaxb20.SubjectType;
import com.sun.xml.wss.saml.util.SAMLUtil;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSAMLTokenProvider
implements STSTokenProvider {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");
    protected static final String SAML_HOLDER_OF_KEY_1_0 = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
    protected static final String SAML_HOLDER_OF_KEY_2_0 = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
    protected static final String SAML_BEARER_1_0 = "urn:oasis:names:tc:SAML:1.0:cm:bearer";
    protected static final String SAML_BEARER_2_0 = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
    protected static final String SAML_SENDER_VOUCHES_1_0 = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
    protected static final String SAML_SENDER_VOUCHES_2_0 = "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches";

    @Override
    public void generateToken(IssuedTokenContext ctx) throws WSTrustException {
        String issuer = ctx.getTokenIssuer();
        String appliesTo = ctx.getAppliesTo();
        String tokenType = ctx.getTokenType();
        String keyType = ctx.getKeyType();
        int tokenLifeSpan = (int)(ctx.getExpirationTime().getTime() - ctx.getCreationTime().getTime());
        String confirMethod = (String)ctx.getOtherProperties().get("samlConfirmationMethod");
        Map claimedAttrs = (Map)ctx.getOtherProperties().get("cliamedAttributes");
        WSTrustVersion wstVer = (WSTrustVersion)ctx.getOtherProperties().get("wstVersion");
        KeyInfo keyInfo = this.createKeyInfo(ctx);
        String assertionId = "uuid-" + UUID.randomUUID().toString();
        Assertion assertion = null;
        if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType)) {
            assertion = this.createSAML11Assertion(wstVer, tokenLifeSpan, confirMethod, assertionId, issuer, appliesTo, keyInfo, claimedAttrs, keyType);
        } else if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
            String authnCtx = (String)ctx.getOtherProperties().get("authnContext");
            assertion = this.createSAML20Assertion(wstVer, tokenLifeSpan, confirMethod, assertionId, issuer, appliesTo, keyInfo, claimedAttrs, keyType, authnCtx);
        } else {
            log.log(Level.SEVERE, LogStringsMessages.WST_0031_UNSUPPORTED_TOKEN_TYPE(tokenType, appliesTo));
            throw new WSTrustException(LogStringsMessages.WST_0031_UNSUPPORTED_TOKEN_TYPE(tokenType, appliesTo));
        }
        X509Certificate stsCert = (X509Certificate)ctx.getOtherProperties().get("stsCertificate");
        PrivateKey stsPrivKey = (PrivateKey)ctx.getOtherProperties().get("stsPrivateKey");
        Element signedAssertion = null;
        try {
            signedAssertion = assertion.sign(stsCert, stsPrivKey, true, ctx.getSignatureAlgorithm(), ctx.getCanonicalizationAlgorithm());
        }
        catch (SAMLException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
        }
        ctx.setSecurityToken(new GenericToken(signedAssertion));
        String valueType = null;
        if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType)) {
            valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
        } else if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
            valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID";
        }
        SecurityTokenReference samlReference = WSTrustUtil.createSecurityTokenReference(assertionId, valueType);
        ctx.setAttachedSecurityTokenReference(samlReference);
        ctx.setUnAttachedSecurityTokenReference(samlReference);
    }

    @Override
    public void isValideToken(IssuedTokenContext ctx) throws WSTrustException {
        WSTrustVersion wstVer = (WSTrustVersion)ctx.getOtherProperties().get("wstVersion");
        WSTrustElementFactory eleFac = WSTrustElementFactory.newInstance(wstVer);
        Token token = ctx.getTarget();
        Element element = (Element)token.getTokenValue();
        String code = wstVer.getValidStatusCodeURI();
        String reason = "The Trust service successfully validate the input";
        if (!this.isSAMLAssertion(element)) {
            code = wstVer.getInvalidStatusCodeURI();
            reason = "The Trust service did not successfully validate the input";
        }
        X509Certificate stsCert = (X509Certificate)ctx.getOtherProperties().get("stsCertificate");
        try {
            String samlVer = "Saml1.1";
            if (element.getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
                samlVer = "Saml2.0";
            }
            SAMLAssertionFactory samlAsserFac = SAMLAssertionFactory.newInstance(samlVer);
            Assertion assertion = samlAsserFac.createAssertion(element);
            boolean isValid = true;
            if (!assertion.verifySignature(stsCert.getPublicKey())) {
                isValid = false;
            }
            if (!SAMLUtil.validateTimeInConditionsStatement(element)) {
                isValid = false;
            }
            if (!isValid) {
                code = wstVer.getInvalidStatusCodeURI();
                reason = "The Trust service did not successfully validate the input";
            }
        }
        catch (XWSSecurityException ex) {
            throw new WSTrustException(ex.getMessage());
        }
        catch (SAMLException ex) {
            throw new WSTrustException(ex.getMessage());
        }
        Status status = eleFac.createStatus(code, reason);
        String tokenType = ctx.getTokenType();
        if (!wstVer.getValidateStatuesTokenType().equals(tokenType)) {
            // empty if block
        }
        ctx.setStatus(status);
    }

    @Override
    public void renewToken(IssuedTokenContext ctx) throws WSTrustException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void invalidateToken(IssuedTokenContext ctx) throws WSTrustException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected Assertion createSAML11Assertion(WSTrustVersion wstVer, int lifeSpan, String confirMethod, String assertionId, String issuer, String appliesTo, KeyInfo keyInfo, Map<QName, List<String>> claimedAttrs, String keyType) throws WSTrustException {
        Assertion assertion = null;
        try {
            Object statement;
            SAMLAssertionFactory samlFac = SAMLAssertionFactory.newInstance("Saml1.1");
            TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
            GregorianCalendar issuerInst = new GregorianCalendar(utcTimeZone);
            GregorianCalendar notOnOrAfter = new GregorianCalendar(utcTimeZone);
            notOnOrAfter.add(14, lifeSpan);
            ArrayList<AudienceRestrictionCondition> arc = null;
            ArrayList<String> confirmMethods = new ArrayList<String>();
            if (confirMethod == null) {
                if (keyType.equals(wstVer.getBearerKeyTypeURI())) {
                    confirMethod = SAML_BEARER_1_0;
                    if (appliesTo != null) {
                        arc = new ArrayList<AudienceRestrictionCondition>();
                        ArrayList<String> au = new ArrayList<String>();
                        au.add(appliesTo);
                        arc.add(samlFac.createAudienceRestrictionCondition(au));
                    }
                } else {
                    confirMethod = SAML_HOLDER_OF_KEY_1_0;
                }
            }
            Element keyInfoEle = null;
            if (keyInfo != null && !wstVer.getBearerKeyTypeURI().equals(keyType)) {
                keyInfoEle = keyInfo.getElement();
            }
            confirmMethods.add(confirMethod);
            SubjectConfirmation subjectConfirm = samlFac.createSubjectConfirmation(confirmMethods, null, keyInfoEle);
            Conditions conditions = samlFac.createConditions(issuerInst, notOnOrAfter, null, arc, null);
            Advice advice = samlFac.createAdvice(null, null, null);
            Subject subj = null;
            QName idName = null;
            Set<Map.Entry<QName, List<String>>> entries = claimedAttrs.entrySet();
            for (Map.Entry<QName, List<String>> entry : entries) {
                QName attrKey = entry.getKey();
                List<String> values = entry.getValue();
                if (values == null || values.size() <= 0 || !"NameID".equals(attrKey.getLocalPart()) || subj != null) continue;
                NameIdentifier nameId = samlFac.createNameIdentifier(values.get(0), attrKey.getNamespaceURI(), null);
                subj = samlFac.createSubject(nameId, subjectConfirm);
                idName = attrKey;
            }
            if (idName != null) {
                claimedAttrs.remove(idName);
            }
            ArrayList<Object> statements = new ArrayList<Object>();
            if (claimedAttrs.isEmpty()) {
                statement = samlFac.createAuthenticationStatement(null, issuerInst, subj, null, null);
                statements.add(statement);
            } else {
                statement = samlFac.createAttributeStatement(subj, null);
                statements.add(statement);
            }
            assertion = samlFac.createAssertion(assertionId, issuer, issuerInst, conditions, advice, statements);
            if (!claimedAttrs.isEmpty()) {
                return WSTrustUtil.addSamlAttributes(assertion, claimedAttrs);
            }
        }
        catch (SAMLException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
        }
        catch (XWSSecurityException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
        }
        return assertion;
    }

    protected Assertion createSAML20Assertion(WSTrustVersion wstVer, int lifeSpan, String confirMethod, String assertionId, String issuer, String appliesTo, KeyInfo keyInfo, Map<QName, List<String>> claimedAttrs, String keyType, String authnCtx) throws WSTrustException {
        Assertion assertion = null;
        try {
            SAMLAssertionFactory samlFac = SAMLAssertionFactory.newInstance("Saml2.0");
            TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
            GregorianCalendar issueInst = new GregorianCalendar(utcTimeZone);
            GregorianCalendar notOnOrAfter = new GregorianCalendar(utcTimeZone);
            notOnOrAfter.add(14, lifeSpan);
            ArrayList<AudienceRestriction> arc = null;
            KeyInfoConfirmationData keyInfoConfData = null;
            if (confirMethod == null) {
                if (keyType.equals(wstVer.getBearerKeyTypeURI())) {
                    confirMethod = SAML_BEARER_2_0;
                    if (appliesTo != null) {
                        arc = new ArrayList<AudienceRestriction>();
                        ArrayList<String> au = new ArrayList<String>();
                        au.add(appliesTo);
                        arc.add(samlFac.createAudienceRestriction(au));
                    }
                } else {
                    confirMethod = SAML_HOLDER_OF_KEY_2_0;
                    if (keyInfo != null) {
                        keyInfoConfData = samlFac.createKeyInfoConfirmationData(keyInfo.getElement());
                    }
                }
            }
            Conditions conditions = samlFac.createConditions(issueInst, notOnOrAfter, null, arc, null, null);
            SubjectConfirmation subjectConfirm = samlFac.createSubjectConfirmation(null, keyInfoConfData, confirMethod);
            Subject subj = null;
            QName idName = null;
            Set<Map.Entry<QName, List<String>>> entries = claimedAttrs.entrySet();
            for (Map.Entry<QName, List<String>> entry : entries) {
                QName attrKey = entry.getKey();
                List<String> values = entry.getValue();
                if (values == null || values.size() <= 0 || !"NameID".equals(attrKey.getLocalPart()) || subj != null) continue;
                NameID nameId = samlFac.createNameID(values.get(0), attrKey.getNamespaceURI(), null);
                subj = samlFac.createSubject(nameId, subjectConfirm);
                idName = attrKey;
            }
            if (idName != null) {
                claimedAttrs.remove(idName);
            }
            ArrayList<Object> statements = new ArrayList<Object>();
            if (claimedAttrs.isEmpty()) {
                AuthnContext ctx = samlFac.createAuthnContext(authnCtx, null);
                AuthnStatement statement = samlFac.createAuthnStatement(issueInst, null, ctx, null, null);
                statements.add(statement);
            } else {
                AttributeStatement statement = samlFac.createAttributeStatement(null);
                statements.add(statement);
            }
            NameID issuerID = samlFac.createNameID(issuer, null, null);
            assertion = samlFac.createAssertion(assertionId, issuerID, issueInst, conditions, null, null, statements);
            if (!claimedAttrs.isEmpty()) {
                assertion = WSTrustUtil.addSamlAttributes(assertion, claimedAttrs);
            }
            ((com.sun.xml.wss.saml.assertion.saml20.jaxb20.Assertion)assertion).setSubject((SubjectType)((Object)subj));
        }
        catch (SAMLException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
        }
        catch (XWSSecurityException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
        }
        return assertion;
    }

    private KeyInfo createKeyInfo(IssuedTokenContext ctx) throws WSTrustException {
        Element kiEle = (Element)ctx.getOtherProperties().get("ConfirmationKeyInfo");
        if (kiEle != null) {
            try {
                return new KeyInfo(kiEle, null);
            }
            catch (XMLSecurityException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT(), ex);
                throw new WSTrustException(LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT(), ex);
            }
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            doc = docFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0039_ERROR_CREATING_DOCFACTORY(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0039_ERROR_CREATING_DOCFACTORY(), ex);
        }
        String appliesTo = ctx.getAppliesTo();
        KeyInfo keyInfo = new KeyInfo(doc);
        String keyType = ctx.getKeyType();
        WSTrustVersion wstVer = (WSTrustVersion)ctx.getOtherProperties().get("wstVersion");
        if (wstVer.getSymmetricKeyTypeURI().equals(keyType)) {
            byte[] key = ctx.getProofKey();
            try {
                EncryptedKey encKey = WSTrustUtil.encryptKey(doc, key, (X509Certificate)ctx.getOtherProperties().get("tagetedServiceCertificate"), null);
                keyInfo.add(encKey);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0040_ERROR_ENCRYPT_PROOFKEY(appliesTo), ex);
                throw new WSTrustException(LogStringsMessages.WST_0040_ERROR_ENCRYPT_PROOFKEY(appliesTo), ex);
            }
        }
        if (wstVer.getPublicKeyTypeURI().equals(keyType)) {
            X509Data x509data = new X509Data(doc);
            try {
                x509data.addCertificate(ctx.getRequestorCertificate());
            }
            catch (XMLSecurityException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT(), ex);
                throw new WSTrustException(LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT(), ex);
            }
            keyInfo.add(x509data);
        }
        return keyInfo;
    }

    private boolean isSAMLAssertion(Element token) {
        return token.getLocalName().equals("Assertion") && (token.getNamespaceURI().equals("urn:oasis:names:tc:SAML:1.0:assertion") || token.getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion"));
    }
}

