/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.dsig;

import com.sun.xml.ws.security.opt.crypto.JAXBData;
import com.sun.xml.ws.security.opt.crypto.StreamWriterData;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.crypto.OctectStreamData;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.c14n.StAXEXC14nCanonicalizerImpl;
import com.sun.xml.wss.logging.impl.opt.signature.LogStringsMessages;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jvnet.staxex.NamespaceContextEx;

public class StAXSTRTransformWriter
implements XMLStreamWriter,
StreamWriterData {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.signature", "com.sun.xml.wss.logging.impl.opt.signature.LogStrings");
    private XMLStreamWriter nextWriter = null;
    private boolean ignore = false;
    private boolean derefSAMLKeyIdentifier = false;
    private Data data = null;
    private int index = 0;
    private NamespaceContextEx ns = null;
    private boolean directReference = false;
    private boolean first = true;
    private String directReferenceValue = "";
    private XMLCryptoContext xMLCryptoContext;
    private String strId = "";
    private JAXBFilterProcessingContext filterContext;

    public StAXSTRTransformWriter(XMLStreamWriter writer, Data data, XMLCryptoContext xMLCryptoContext) {
        this.nextWriter = writer;
        this.data = data;
        if (data instanceof JAXBData) {
            this.ns = ((JAXBData)data).getNamespaceContext();
        } else if (data instanceof StreamWriterData) {
            this.ns = ((StreamWriterData)data).getNamespaceContext();
        }
        this.xMLCryptoContext = xMLCryptoContext;
        this.filterContext = (JAXBFilterProcessingContext)xMLCryptoContext.get("http://wss.sun.com#processingContext");
    }

    public StAXSTRTransformWriter(Data data, XMLCryptoContext xMLCryptoContext, String refId) {
        this.data = data;
        if (data instanceof JAXBData) {
            this.ns = ((JAXBData)data).getNamespaceContext();
        } else if (data instanceof StreamWriterData) {
            this.ns = ((StreamWriterData)data).getNamespaceContext();
        }
        this.xMLCryptoContext = xMLCryptoContext;
        this.strId = refId;
        this.filterContext = (JAXBFilterProcessingContext)xMLCryptoContext.get("http://wss.sun.com#processingContext");
    }

    public NamespaceContextEx getNamespaceContext() {
        return this.ns;
    }

    public void close() throws XMLStreamException {
        this.nextWriter.close();
    }

    public void flush() throws XMLStreamException {
        this.nextWriter.flush();
    }

    public void writeEndDocument() throws XMLStreamException {
        if (this.index > 0) {
            int size = this.index;
            for (int i = 0; i < size; ++i) {
                this.writeEndElement();
            }
        }
        this.nextWriter.writeEndDocument();
    }

    public void writeEndElement() throws XMLStreamException {
        if (this.index == 1 && !this.ignore) {
            this.nextWriter.writeEndElement();
        }
        if (this.index > 0) {
            --this.index;
        }
        if (this.index == 0) {
            if (this.ignore) {
                this.ignore = false;
                this.derefernceSTR();
            }
            this.nextWriter.writeEndElement();
            if (this.derefSAMLKeyIdentifier) {
                this.derefSAMLKeyIdentifier = false;
            }
            if (this.directReference) {
                this.directReference = false;
            }
            return;
        }
    }

    public void writeStartDocument() throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeStartDocument();
        }
    }

    public void writeCharacters(char[] c, int index, int len) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeCharacters(c, index, len);
        } else if (this.derefSAMLKeyIdentifier) {
            this.strId = String.valueOf(c, index, len);
            if (this.strId == null) {
                throw new XMLStreamException("SAML Key Identifier is empty in SecurityTokenReference");
            }
        }
    }

    public void setDefaultNamespace(String string2) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.setDefaultNamespace(string2);
        }
    }

    public void writeCData(String string2) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeCData(string2);
        }
    }

    public void writeCharacters(String string2) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeCharacters(string2);
        } else if (this.derefSAMLKeyIdentifier) {
            this.strId = string2;
            if (this.strId == null) {
                throw new XMLStreamException("SAML Key Identifier is empty in SecurityTokenReference");
            }
        }
    }

    public void writeComment(String string2) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeComment(string2);
        }
    }

    public void writeDTD(String string2) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeDTD(string2);
        }
    }

    public void writeDefaultNamespace(String string2) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeDefaultNamespace(string2);
        }
    }

    public void writeEmptyElement(String string2) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeEmptyElement(string2);
        }
    }

    public void writeEntityRef(String string2) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeEntityRef(string2);
        }
    }

    public void writeProcessingInstruction(String string2) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeProcessingInstruction(string2);
        }
    }

    public void writeStartDocument(String string2) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeStartDocument(string2);
        }
    }

    public void writeStartElement(String string2) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeStartElement(string2);
        }
        this.first = false;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.setNamespaceContext(namespaceContext);
        }
    }

    public Object getProperty(String string2) throws IllegalArgumentException {
        return this.nextWriter.getProperty(string2);
    }

    public String getPrefix(String string2) throws XMLStreamException {
        return this.nextWriter.getPrefix(string2);
    }

    public void setPrefix(String string2, String string0) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.setPrefix(string2, string0);
        }
    }

    public void writeAttribute(String localname, String value) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeAttribute(localname, value);
        } else if (this.directReference) {
            if (localname == "URI") {
                this.directReferenceValue = value;
            }
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(value) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(value)) {
            this.derefSAMLKeyIdentifier = true;
        }
    }

    public void writeEmptyElement(String string2, String string0) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeEmptyElement(string2, string0);
        }
    }

    public void writeNamespace(String string2, String string0) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeNamespace(string2, string0);
        }
    }

    public void writeProcessingInstruction(String string2, String string0) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeProcessingInstruction(string2, string0);
        }
    }

    public void writeStartDocument(String string2, String string0) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeStartDocument(string2, string0);
        }
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        if (!this.ignore) {
            if (this.first && localName == "SecurityTokenReference" && namespaceURI == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") {
                this.ignore = true;
                ++this.index;
                return;
            }
            this.nextWriter.writeStartElement(namespaceURI, localName);
        } else {
            ++this.index;
        }
        this.first = false;
    }

    public void writeAttribute(String uri, String localname, String value) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeAttribute(uri, localname, value);
        } else if (this.directReference && localname == "URI") {
            this.directReferenceValue = value;
        }
    }

    public void writeEmptyElement(String string2, String string0, String string1) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeEmptyElement(string2, string0, string1);
        }
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (!this.ignore) {
            if (this.first && localName == "SecurityTokenReference" && namespaceURI == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") {
                this.ignore = true;
                ++this.index;
                return;
            }
            if (this.first && localName == "Reference" && namespaceURI == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") {
                this.ignore = true;
                ++this.index;
                this.directReference = true;
                this.nextWriter.writeNamespace(prefix, namespaceURI);
                return;
            }
            if (this.first && localName == "KeyIdentifier" && namespaceURI == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") {
                this.ignore = true;
                ++this.index;
                this.nextWriter.writeNamespace(prefix, namespaceURI);
            } else {
                this.nextWriter.writeStartElement(prefix, localName, namespaceURI);
            }
        } else if (localName == "Reference" && namespaceURI == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") {
            ++this.index;
            this.directReference = true;
        } else if (localName == "KeyIdentifier" && namespaceURI == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") {
            ++this.index;
            this.nextWriter.writeNamespace(prefix, namespaceURI);
        } else {
            this.nextWriter.writeStartElement(prefix, localName, namespaceURI);
        }
        this.first = false;
    }

    public void writeAttribute(String prefix, String uri, String localName, String value) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeNamespace(prefix, uri);
            this.nextWriter.writeAttribute(prefix, uri, localName, value);
        } else if (this.directReference && localName == "URI") {
            this.directReferenceValue = value;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(XMLStreamWriter writer) throws XMLStreamException {
        this.nextWriter = writer;
        boolean defaultNSDecl = false;
        if (this.data instanceof JAXBData) {
            try {
                ((JAXBData)this.data).writeTo(this);
                NamespaceContextEx nc = ((JAXBData)this.data).getNamespaceContext();
                for (NamespaceContextEx.Binding nd : nc) {
                    this.nextWriter.writeNamespace(nd.getPrefix(), nd.getNamespaceURI());
                    if (nd.getPrefix() != null && !nd.getPrefix().equals("")) continue;
                    defaultNSDecl = true;
                }
                if (defaultNSDecl || !(this.nextWriter instanceof StAXEXC14nCanonicalizerImpl)) return;
                ((StAXEXC14nCanonicalizerImpl)this.nextWriter).forceDefaultNS(true);
                this.nextWriter.writeDefaultNamespace("");
                return;
            }
            catch (XWSSecurityException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1706_ERROR_ENVELOPED_SIGNATURE());
                throw new XMLStreamException("Error occurred while performing Enveloped Signature");
            }
        } else if (this.data instanceof StreamWriterData) {
            StreamWriterData swd = (StreamWriterData)this.data;
            NamespaceContextEx nc = swd.getNamespaceContext();
            for (NamespaceContextEx.Binding nd : nc) {
                this.nextWriter.writeNamespace(nd.getPrefix(), nd.getNamespaceURI());
                if (nd.getPrefix() != null && !nd.getPrefix().equals("")) continue;
                defaultNSDecl = true;
            }
            if (!defaultNSDecl && this.nextWriter instanceof StAXEXC14nCanonicalizerImpl) {
                ((StAXEXC14nCanonicalizerImpl)this.nextWriter).forceDefaultNS(true);
                this.nextWriter.writeDefaultNamespace("");
            }
            ((StreamWriterData)this.data).write(this);
            return;
        } else {
            if (!(this.data instanceof OctectStreamData)) return;
            ((OctectStreamData)this.data).write(this);
        }
    }

    void derefernceSTR() throws XMLStreamException {
        Data token = null;
        URIDereferencer deRef = this.xMLCryptoContext.getURIDereferencer();
        final String uri = this.directReference ? this.directReferenceValue : (this.strId != null && this.strId.length() > 0 ? this.strId : "");
        URIReference ref = new URIReference(){

            public String getType() {
                return "";
            }

            public String getURI() {
                return uri;
            }
        };
        try {
            token = deRef.dereference(ref, this.xMLCryptoContext);
        }
        catch (URIReferenceException ue) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1716_ERROR_DEREFERENCE_STR_TRANSFORM());
            throw new XMLStreamException("Error occurred while dereferencing STR-Transform's Reference Element", ue);
        }
        if (token != null) {
            if (token instanceof JAXBData) {
                try {
                    ((JAXBData)token).writeTo(this);
                }
                catch (XWSSecurityException ex) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1706_ERROR_ENVELOPED_SIGNATURE());
                    throw new XMLStreamException("Error occurred while performing Enveloped Signature");
                }
            } else if (token instanceof StreamWriterData) {
                ((StreamWriterData)token).write(this);
            } else if (token instanceof OctectStreamData) {
                ((OctectStreamData)token).write(this);
            }
        }
    }
}

