/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.jaxws.client;

import com.sun.xml.ws.api.WSFeatureList;
import com.sun.xml.ws.api.client.ServiceInterceptor;
import com.sun.xml.ws.api.client.WSPortInfo;
import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.model.wsdl.WSDLService;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapMutator;
import com.sun.xml.ws.policy.jaxws.PolicyConfigParser;
import com.sun.xml.ws.policy.jaxws.WSDLPolicyMapWrapper;
import com.sun.xml.ws.policy.jaxws.client.PolicyFeature;
import com.sun.xml.ws.policy.jaxws.privateutil.LocalizationMessages;
import com.sun.xml.ws.policy.jaxws.spi.ModelConfiguratorProvider;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.ws.policy.privateutil.PolicyUtils;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyServiceInterceptor
extends ServiceInterceptor {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyServiceInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WebServiceFeature> preCreateBinding(WSPortInfo port, Class<?> serviceEndpointInterface, WSFeatureList defaultFeatures) {
        LOGGER.entering(port, serviceEndpointInterface, defaultFeatures);
        LinkedList<WebServiceFeature> features = new LinkedList<WebServiceFeature>();
        try {
            WSDLPort wsdlPort = port.getPort();
            if (wsdlPort == null) {
                WSDLModel clientModel;
                try {
                    clientModel = PolicyConfigParser.parseModel("client", null, new PolicyMapMutator[0]);
                }
                catch (PolicyException pe) {
                    throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_1017_ERROR_WHILE_PROCESSING_CLIENT_CONFIG(), (Throwable)pe));
                }
                if (clientModel != null) {
                    WSDLPolicyMapWrapper policyMapWrapper = clientModel.getExtension(WSDLPolicyMapWrapper.class);
                    if (policyMapWrapper == null) {
                        LOGGER.config(LocalizationMessages.WSP_1022_POLICY_MAP_NOT_IN_MODEL());
                    } else {
                        LOGGER.config(LocalizationMessages.WSP_1024_INVOKING_CLIENT_POLICY_ALTERNATIVE_SELECTION());
                        try {
                            policyMapWrapper.doAlternativeSelection();
                        }
                        catch (PolicyException e) {
                            throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_1003_VALID_POLICY_ALTERNATIVE_NOT_FOUND(), (Throwable)e));
                        }
                        PolicyMap map = policyMapWrapper.getPolicyMap();
                        try {
                            for (ModelConfiguratorProvider configurator : PolicyUtils.ServiceProvider.load(ModelConfiguratorProvider.class)) {
                                configurator.configure(clientModel, map);
                            }
                        }
                        catch (PolicyException e) {
                            throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_1023_ERROR_WHILE_CONFIGURING_MODEL(), (Throwable)e));
                        }
                        this.addFeatures(features, clientModel, port.getPortName());
                        features.add(new PolicyFeature(map, clientModel, port));
                    }
                }
            }
            LinkedList<WebServiceFeature> linkedList = features;
            return linkedList;
        }
        finally {
            LOGGER.exiting(features);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFeatures(List<WebServiceFeature> features, WSDLModel model, QName portName) {
        LOGGER.entering(features, model, portName);
        try {
            for (WSDLService wSDLService : model.getServices().values()) {
                WSDLPort port = wSDLService.get(portName);
                if (port == null) continue;
                this.addFeatureListToList(features, port.getFeatures());
                this.addFeatureListToList(features, port.getBinding().getFeatures());
                break;
            }
        }
        finally {
            LOGGER.exiting(features);
        }
    }

    private void addFeatureListToList(List<WebServiceFeature> list, WSFeatureList featureList) {
        for (WebServiceFeature feature : featureList) {
            list.add(feature);
        }
    }
}

