/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.extension.wsdl11.soap;

import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.jvnet.wom.api.WSDLExtension;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAP11Constants;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAP12Constants;
import org.jvnet.wom.impl.extension.Messages;
import org.jvnet.wom.impl.extension.wsdl11.AbstractWSDLExtensionHandler;
import org.jvnet.wom.impl.extension.wsdl11.soap.SOAPAddressImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPAddressExtensionHandler
extends AbstractWSDLExtensionHandler {
    private final ContentHandler contentHandler = new SOAPAddressCH();
    private SOAPAddressImpl address;
    private final QName[] names = new QName[]{SOAP11Constants.SOAPADDRESS_NAME, SOAP12Constants.SOAPADDRESS_NAME};

    public SOAPAddressExtensionHandler(ErrorHandler errorHandler, EntityResolver entityResolver) {
        super(errorHandler, entityResolver);
    }

    @Override
    public Collection<WSDLExtension> getExtensions() {
        return Collections.singleton(this.address);
    }

    @Override
    protected QName[] getExtensionNames() {
        return this.names;
    }

    @Override
    public ContentHandler getContentHandlerFor(String nsUri, String localName) {
        if (this.canHandle(nsUri, localName)) {
            return this.contentHandler;
        }
        return null;
    }

    private class SOAPAddressCH
    extends AbstractWSDLExtensionHandler.WSDLExtensibilityContentHandler {
        private SOAPAddressCH() {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (SOAPAddressExtensionHandler.this.canHandle(uri, localName)) {
                String location = atts.getValue("location");
                if (location == null) {
                    SOAPAddressExtensionHandler.this.errorHandler.error(new SAXParseException(Messages.format("missing.attr", "location", "soap:address"), this.locator));
                }
                SOAPAddressExtensionHandler.this.address = new SOAPAddressImpl(new QName(uri, localName));
                SOAPAddressExtensionHandler.this.address.setLocation(location);
            }
        }
    }
}

