/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.util;

import com.sun.org.apache.xml.internal.security.Init;
import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.xml.security.core.dsig.KeyInfoType;
import com.sun.xml.security.core.dsig.TransformType;
import com.sun.xml.security.core.xenc.CipherDataType;
import com.sun.xml.security.core.xenc.CipherReferenceType;
import com.sun.xml.security.core.xenc.EncryptedDataType;
import com.sun.xml.security.core.xenc.EncryptedKeyType;
import com.sun.xml.security.core.xenc.EncryptionMethodType;
import com.sun.xml.security.core.xenc.ObjectFactory;
import com.sun.xml.security.core.xenc.ReferenceType;
import com.sun.xml.security.core.xenc.TransformsType;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.security.opt.api.EncryptedData;
import com.sun.xml.ws.security.opt.api.EncryptedKey;
import com.sun.xml.ws.security.opt.api.SecurityElement;
import com.sun.xml.ws.security.opt.api.reference.Reference;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyInfo;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyName;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyValue;
import com.sun.xml.ws.security.opt.impl.crypto.AttachmentData;
import com.sun.xml.ws.security.opt.impl.enc.EncryptedHeader;
import com.sun.xml.ws.security.opt.impl.enc.JAXBEncryptedData;
import com.sun.xml.ws.security.opt.impl.enc.JAXBEncryptedKey;
import com.sun.xml.ws.security.opt.impl.keyinfo.BinarySecurityToken;
import com.sun.xml.ws.security.opt.impl.keyinfo.DerivedKey;
import com.sun.xml.ws.security.opt.impl.keyinfo.SecurityContextToken;
import com.sun.xml.ws.security.opt.impl.keyinfo.SecurityTokenReference;
import com.sun.xml.ws.security.opt.impl.message.GSHeaderElement;
import com.sun.xml.ws.security.opt.impl.outgoing.SecurityHeader;
import com.sun.xml.ws.security.opt.impl.reference.DirectReference;
import com.sun.xml.ws.security.opt.impl.reference.KeyIdentifier;
import com.sun.xml.ws.security.opt.impl.reference.X509Data;
import com.sun.xml.ws.security.opt.impl.reference.X509IssuerSerial;
import com.sun.xml.ws.security.secconv.impl.bindings.DerivedKeyTokenType;
import com.sun.xml.ws.security.secconv.impl.bindings.SecurityContextTokenType;
import com.sun.xml.ws.security.secext10.BinarySecurityTokenType;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import com.sun.xml.ws.security.secext11.EncryptedHeaderType;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import java.math.BigInteger;
import java.net.URI;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.crypto.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSElementFactory {
    private SOAPVersion soapVersion = SOAPVersion.SOAP_11;
    public static final ObjectFactory eoFactory;

    public WSSElementFactory(SOAPVersion soapVersion) {
        this.soapVersion = soapVersion;
    }

    public SecurityHeader createSecurityHeader() {
        return new SecurityHeader();
    }

    public SecurityHeader createSecurityHeader(int headerLayout, String soapVersion) {
        return new SecurityHeader(headerLayout, soapVersion);
    }

    public BinarySecurityToken createBinarySecurityToken(String id, String valueType, String encodingType, byte[] token) {
        BinarySecurityTokenType bst = new BinarySecurityTokenType();
        bst.setValueType(valueType);
        bst.setId(id);
        bst.setEncodingType(encodingType);
        bst.setValue(token);
        return new BinarySecurityToken(bst, this.soapVersion);
    }

    public BinarySecurityToken createBinarySecurityToken(String id, byte[] cer) {
        return this.createBinarySecurityToken(id, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary", cer);
    }

    public BinarySecurityToken createKerberosBinarySecurityToken(String id, byte[] token) {
        return this.createBinarySecurityToken(id, "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary", token);
    }

    public SecurityTokenReference createSecurityTokenReference(Reference reference) {
        SecurityTokenReference str = new SecurityTokenReference(this.soapVersion);
        str.setReference(reference);
        return str;
    }

    public SecurityTokenReference createSecurityTokenReference() {
        SecurityTokenReference str = new SecurityTokenReference(this.soapVersion);
        return str;
    }

    public DirectReference createDirectReference() {
        return new DirectReference(this.soapVersion);
    }

    public KeyIdentifier createKeyIdentifier() {
        return new KeyIdentifier(this.soapVersion);
    }

    public X509Data createX509DataWithIssuerSerial(X509IssuerSerial xis) {
        X509Data x509Data = new X509Data(this.soapVersion);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(xis);
        x509Data.setX509IssuerSerialOrX509SKIOrX509SubjectName(list);
        return x509Data;
    }

    public GSHeaderElement createGSHeaderElement(JAXBElement el) {
        return new GSHeaderElement(el, this.soapVersion);
    }

    public GSHeaderElement createGSHeaderElement(Object obj) {
        return new GSHeaderElement(obj, this.soapVersion);
    }

    public SecurityContextToken createSecurityContextToken(URI identifier, String instance, String wsuId) {
        return new SecurityContextToken(identifier, instance, wsuId, this.soapVersion);
    }

    public SecurityContextToken createSecurityContextToken(SecurityContextTokenType sTokenType, String wsuId) {
        return new SecurityContextToken(sTokenType, this.soapVersion);
    }

    public X509IssuerSerial createX509IssuerSerial(String issuerName, BigInteger serialNumber) {
        X509IssuerSerial xis = new X509IssuerSerial(this.soapVersion);
        xis.setX509IssuerName(issuerName);
        xis.setX509SerialNumber(serialNumber);
        return xis;
    }

    public KeyInfo createKeyInfo(SecurityTokenReference str) {
        KeyInfo keyInfo = new KeyInfo();
        JAXBElement<SecurityTokenReferenceType> je = new com.sun.xml.ws.security.secext10.ObjectFactory().createSecurityTokenReference(str);
        List<JAXBElement<SecurityTokenReferenceType>> strList = Collections.singletonList(je);
        keyInfo.setContent(strList);
        return keyInfo;
    }

    public KeyInfo createKeyInfo(KeyValue keyValue) {
        KeyInfo keyInfo = new KeyInfo();
        JAXBElement<KeyValue> je = new com.sun.xml.security.core.dsig.ObjectFactory().createKeyValue(keyValue);
        List<JAXBElement<KeyValue>> strList = Collections.singletonList(je);
        keyInfo.setContent(strList);
        return keyInfo;
    }

    public KeyInfo createKeyInfo(KeyName name) {
        KeyInfo keyInfo = new KeyInfo();
        List<Object> strList = Collections.singletonList(name);
        keyInfo.setContent(strList);
        return keyInfo;
    }

    public EncryptedData createEncryptedData(String id, Data data, String dataAlgo, KeyInfoType keyInfo, Key key, boolean contentOnly) {
        EncryptedDataType edt = new EncryptedDataType();
        if (contentOnly) {
            edt.setType("http://www.w3.org/2001/04/xmlenc#Content");
        } else {
            edt.setType("http://www.w3.org/2001/04/xmlenc#Element");
        }
        EncryptionMethodType emt = new EncryptionMethodType();
        emt.setAlgorithm(dataAlgo);
        edt.setEncryptionMethod(emt);
        CipherDataType ct = new CipherDataType();
        ct.setCipherValue("ed".getBytes());
        edt.setCipherData(ct);
        edt.setId(id);
        if (keyInfo != null) {
            edt.setKeyInfo(keyInfo);
        }
        return new JAXBEncryptedData(edt, data, key, this.soapVersion);
    }

    public EncryptedData createEncryptedData(String id, Attachment attachment, String dataAlgo, KeyInfoType keyInfo, Key key, EncryptionTarget target) {
        AttachmentData attachData = new AttachmentData(attachment);
        String cid = "cid:" + attachment.getContentId();
        boolean contentOnly = target.getContentOnly();
        EncryptedDataType edt = new EncryptedDataType();
        if (contentOnly) {
            edt.setType("http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Only");
        } else {
            edt.setType("http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Complete");
        }
        edt.setMimeType(attachment.getContentType());
        EncryptionMethodType emt = new EncryptionMethodType();
        emt.setAlgorithm(dataAlgo);
        edt.setEncryptionMethod(emt);
        CipherDataType ct = new CipherDataType();
        CipherReferenceType crt = new CipherReferenceType();
        crt.setURI(cid);
        TransformsType tst = new TransformsType();
        ArrayList<TransformType> ttList = new ArrayList<TransformType>();
        ArrayList list = target.getCipherReferenceTransforms();
        for (Object obj : list) {
            EncryptionTarget.Transform tr = (EncryptionTarget.Transform)obj;
            TransformType tt = new TransformType();
            tt.setAlgorithm(tr.getTransform());
            ttList.add(tt);
        }
        if (!ttList.isEmpty()) {
            tst.setTransform(ttList);
        }
        crt.setTransforms(tst);
        ct.setCipherReference(crt);
        edt.setCipherData(ct);
        edt.setId(id);
        if (keyInfo != null) {
            edt.setKeyInfo(keyInfo);
        }
        return new JAXBEncryptedData(edt, attachData, key, this.soapVersion);
    }

    public EncryptedHeader createEncryptedHeader(String ehId, String edId, Data data, String dataAlgo, KeyInfoType keyInfo, Key key, boolean contentOnly) {
        EncryptedHeaderType eht = new EncryptedHeaderType();
        EncryptedDataType edt = new EncryptedDataType();
        if (contentOnly) {
            edt.setType("http://www.w3.org/2001/04/xmlenc#Content");
        } else {
            edt.setType("http://www.w3.org/2001/04/xmlenc#Element");
        }
        EncryptionMethodType emt = new EncryptionMethodType();
        emt.setAlgorithm(dataAlgo);
        edt.setEncryptionMethod(emt);
        CipherDataType ct = new CipherDataType();
        ct.setCipherValue("ed".getBytes());
        edt.setCipherData(ct);
        edt.setId(edId);
        if (keyInfo != null) {
            edt.setKeyInfo(keyInfo);
        }
        eht.setEncryptedData(edt);
        eht.setId(ehId);
        if (this.soapVersion == SOAPVersion.SOAP_11) {
            eht.setMustUnderstand(true);
        } else if (this.soapVersion == SOAPVersion.SOAP_12) {
            eht.setMustUnderstand12(true);
        }
        EncryptedHeader eh = new EncryptedHeader(eht, data, key, this.soapVersion);
        return eh;
    }

    public EncryptedKey createEncryptedKey(String id, String keyEncAlgo, KeyInfo keyInfo, Key dkEK, Key dataEncKey) throws XWSSecurityException {
        EncryptedKeyType ekt = eoFactory.createEncryptedKeyType();
        EncryptionMethodType emt = eoFactory.createEncryptionMethodType();
        emt.setAlgorithm(keyEncAlgo);
        ekt.setEncryptionMethod(emt);
        ekt.setKeyInfo(keyInfo);
        CipherDataType ct = new CipherDataType();
        ct.setCipherValue("ek".getBytes());
        ekt.setCipherData(ct);
        ekt.setId(id);
        return new JAXBEncryptedKey(ekt, dkEK, dataEncKey, this.soapVersion);
    }

    public JAXBElement<ReferenceType> createDataReference(SecurityElement se) {
        ReferenceType rt = eoFactory.createReferenceType();
        rt.setURI("#" + se.getId());
        return eoFactory.createReferenceListDataReference(rt);
    }

    public KeyInfoType createKeyInfoType(String keyAlgo, String refType, String refId) {
        return new KeyInfoType();
    }

    public DerivedKey createDerivedKey(String id, String algo, byte[] nonce, long offset, long length, String label, SecurityTokenReference str, String spVersion) {
        DerivedKeyTokenType dkt = new DerivedKeyTokenType();
        com.sun.xml.ws.security.secconv.impl.wssx.bindings.DerivedKeyTokenType dkt13 = new com.sun.xml.ws.security.secconv.impl.wssx.bindings.DerivedKeyTokenType();
        if (spVersion.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702")) {
            dkt13.setId(id);
            dkt13.setOffset(BigInteger.valueOf(offset));
            dkt13.setNonce(nonce);
            dkt13.setLength(BigInteger.valueOf(length));
            dkt13.setSecurityTokenReference(str);
            return new DerivedKey(dkt13, this.soapVersion, spVersion);
        }
        dkt.setId(id);
        dkt.setOffset(BigInteger.valueOf(offset));
        dkt.setNonce(nonce);
        dkt.setLength(BigInteger.valueOf(length));
        dkt.setSecurityTokenReference(str);
        return new DerivedKey(dkt, this.soapVersion, spVersion);
    }

    public DerivedKey createDerivedKey(String id, String algo, byte[] nonce, long offset, long length, String label, SecurityTokenReferenceType str, String spVersion) {
        DerivedKeyTokenType dkt = new DerivedKeyTokenType();
        com.sun.xml.ws.security.secconv.impl.wssx.bindings.DerivedKeyTokenType dkt13 = new com.sun.xml.ws.security.secconv.impl.wssx.bindings.DerivedKeyTokenType();
        if (spVersion.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702")) {
            dkt13.setId(id);
            dkt13.setOffset(BigInteger.valueOf(offset));
            dkt13.setNonce(nonce);
            dkt13.setLength(BigInteger.valueOf(length));
            dkt13.setSecurityTokenReference(str);
            return new DerivedKey(dkt13, this.soapVersion, spVersion);
        }
        dkt.setId(id);
        dkt.setOffset(BigInteger.valueOf(offset));
        dkt.setNonce(nonce);
        dkt.setLength(BigInteger.valueOf(length));
        dkt.setSecurityTokenReference(str);
        return new DerivedKey(dkt, this.soapVersion, spVersion);
    }

    public DerivedKey createDerivedKey(String id, String algo, byte[] nonce, long offset, long length, String label, SecurityTokenReferenceType str, String refId, String spVersion) {
        DerivedKeyTokenType dkt = new DerivedKeyTokenType();
        com.sun.xml.ws.security.secconv.impl.wssx.bindings.DerivedKeyTokenType dkt13 = new com.sun.xml.ws.security.secconv.impl.wssx.bindings.DerivedKeyTokenType();
        if (spVersion.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702")) {
            dkt13.setId(id);
            dkt13.setOffset(BigInteger.valueOf(offset));
            dkt13.setNonce(nonce);
            dkt13.setLength(BigInteger.valueOf(length));
            dkt13.setSecurityTokenReference(str);
            return new DerivedKey(dkt13, this.soapVersion, refId, spVersion);
        }
        dkt.setId(id);
        dkt.setOffset(BigInteger.valueOf(offset));
        dkt.setNonce(nonce);
        dkt.setLength(BigInteger.valueOf(length));
        dkt.setSecurityTokenReference(str);
        return new DerivedKey(dkt, this.soapVersion, refId, spVersion);
    }

    protected String convertAlgURIToTransformation(String algorithmURI) {
        return JCEMapper.translateURItoJCEID(algorithmURI);
    }

    static {
        Init.init();
        eoFactory = new ObjectFactory();
    }
}

