/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.assembler.WsitServerTubeAssemblyContext;
import com.sun.xml.ws.rm.RmRuntimeException;
import com.sun.xml.ws.rm.faults.AbstractRmSoapFault;
import com.sun.xml.ws.rm.faults.CreateSequenceRefusedFault;
import com.sun.xml.ws.rm.faults.SequenceTerminatedFault;
import com.sun.xml.ws.rm.faults.UnknownSequenceFault;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.policy.ConfigurationManager;
import com.sun.xml.ws.rm.runtime.FlowControledFibers;
import com.sun.xml.ws.rm.runtime.PacketAdapter;
import com.sun.xml.ws.rm.runtime.Rm10ServerTube;
import com.sun.xml.ws.rm.runtime.Rm11ServerTube;
import com.sun.xml.ws.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rm.runtime.sequence.SequenceManagerFactory;
import com.sun.xml.ws.rm.runtime.sequence.UnknownSequenceException;
import java.util.logging.Level;

abstract class AbstractRmServerTube
extends AbstractFilterTubeImpl {
    private static final RmLogger LOGGER = RmLogger.getLogger(AbstractRmServerTube.class);
    final Configuration configuration;
    final SequenceManager sequenceManager;
    private PacketAdapter requestAdapter;

    static AbstractRmServerTube getInstance(WsitServerTubeAssemblyContext context) {
        Configuration configuration = ConfigurationManager.createServiceConfigurationManager(context.getWsdlPort(), context.getEndpoint().getBinding()).getConfigurationAlternatives()[0];
        switch (configuration.getRmVersion()) {
            case WSRM10: {
                return new Rm10ServerTube(configuration, context.getTubelineHead());
            }
            case WSRM11: {
                return new Rm11ServerTube(configuration, context.getTubelineHead());
            }
        }
        throw new IllegalStateException(LocalizationMessages.WSRM_1104_RM_VERSION_NOT_SUPPORTED(configuration.getRmVersion().namespaceUri));
    }

    AbstractRmServerTube(AbstractRmServerTube original, TubeCloner cloner) {
        super(original, cloner);
        this.configuration = original.configuration;
        this.sequenceManager = original.sequenceManager;
        this.requestAdapter = null;
    }

    AbstractRmServerTube(Configuration configuration, Tube tubelineHead) {
        super(tubelineHead);
        this.configuration = configuration;
        if (configuration.getAddressingVersion() != AddressingVersion.W3C) {
            throw new RmRuntimeException(LocalizationMessages.WSRM_1120_UNSUPPORTED_WSA_VERSION(configuration.getAddressingVersion().toString()));
        }
        this.sequenceManager = SequenceManagerFactory.INSTANCE.getServerSequenceManager();
        this.requestAdapter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processRequest(Packet requestPacket) {
        NextAction nextAction;
        LOGGER.entering();
        this.requestAdapter = PacketAdapter.getInstance(this.configuration, requestPacket);
        try {
            if (this.requestAdapter.isProtocolMessage()) {
                if (this.requestAdapter.isProtocolRequest()) {
                    PacketAdapter protocolResponseAdapter = this.processProtocolRequest(this.requestAdapter);
                    NextAction nextAction2 = this.doReturnWith(protocolResponseAdapter.getPacket());
                    return nextAction2;
                }
                NextAction protocolResponseAdapter = this.doThrow((Throwable)((Object)new RmRuntimeException(LocalizationMessages.WSRM_1128_INVALID_WSA_ACTION_IN_PROTOCOL_REQUEST(this.requestAdapter.getWsaAction()))));
                return protocolResponseAdapter;
            }
            Sequence inboundSequence = this.getSequenceOrSoapFault(this.requestAdapter.getPacket(), this.requestAdapter.getSequenceId());
            if (!this.requestAdapter.isSecurityContextTokenIdValid(inboundSequence.getBoundSecurityTokenReferenceId())) {
                throw new RmRuntimeException("Security context token on the message does not match the token bound to the sequence");
            }
            this.processNonSequenceRmHeaders(this.requestAdapter);
            if (this.duplicatesNotAllowed() && inboundSequence.isAcknowledged(this.requestAdapter.getMessageNumber())) {
                PacketAdapter responseAdapter;
                Object storedMessage;
                Sequence outboundSequence = this.sequenceManager.getBoundSequence(inboundSequence.getId());
                Object object = storedMessage = outboundSequence != null ? outboundSequence.retrieveMessage(this.requestAdapter.getMessageNumber()) : null;
                if (storedMessage instanceof Packet) {
                    responseAdapter = PacketAdapter.getInstance(this.configuration, (Packet)storedMessage);
                    responseAdapter.appendSequenceAcknowledgementHeader(this.sequenceManager.getSequence(inboundSequence.getId()));
                } else if (storedMessage == null) {
                    responseAdapter = this.requestAdapter.createAckResponse(inboundSequence, this.configuration.getRmVersion().sequenceAcknowledgementAction);
                } else {
                    throw new AssertionError((Object)("Unexpected message packet type: " + storedMessage.getClass().getName()));
                }
                this.doReturnWith(responseAdapter.getPacket());
            }
            if (!this.requestAdapter.hasSession()) {
                this.requestAdapter.setSession(inboundSequence.getId());
            }
            if (this.configuration.isOrderedDelivery() && !this.isMessageInOrder(this.requestAdapter)) {
                if ((long)FlowControledFibers.INSTANCE.getUsedBufferSize(inboundSequence.getId()) > this.configuration.getDestinationBufferQuota()) {
                    PacketAdapter responseAdapter = this.requestAdapter.createAckResponse(inboundSequence, this.configuration.getRmVersion().sequenceAcknowledgementAction);
                    NextAction nextAction3 = this.doReturnWith(responseAdapter.getPacket());
                    return nextAction3;
                }
                FlowControledFibers.INSTANCE.registerForResume(Fiber.current(), this.requestAdapter);
                nextAction = this.doSuspend(this.next);
                return nextAction;
            }
            nextAction = super.processRequest(this.requestAdapter.keepTransportBackChannelOpen().getPacket());
            return nextAction;
        }
        catch (AbstractRmSoapFault ex) {
            nextAction = this.doReturnWith(ex.getSoapFaultResponse());
            return nextAction;
        }
        catch (RmRuntimeException ex) {
            LOGGER.logSevereException(ex);
            nextAction = this.doThrow((Throwable)((Object)ex));
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processResponse(Packet responsePacket) {
        LOGGER.entering();
        try {
            Sequence inboundSequence = this.sequenceManager.getSequence(this.requestAdapter.getSequenceId());
            inboundSequence.acknowledgeMessageId(this.requestAdapter.getMessageNumber());
            PacketAdapter responseAdapter = PacketAdapter.getInstance(this.configuration, responsePacket);
            if (responseAdapter.containsMessage()) {
                Sequence outboundSequence = this.sequenceManager.getBoundSequence(inboundSequence.getId());
                if (outboundSequence != null) {
                    responseAdapter.appendSequenceHeader(outboundSequence.getId(), outboundSequence.generateNextMessageId());
                    responseAdapter.appendAckRequestedHeader(outboundSequence.getId());
                    if (this.duplicatesNotAllowed()) {
                        outboundSequence.storeMessage(this.requestAdapter.getMessageNumber(), responseAdapter.getMessageNumber(), responseAdapter.getPacket());
                    }
                } else {
                    throw new IllegalStateException(LocalizationMessages.WSRM_1139_NO_OUTBOUND_SEQUENCE_FOR_RESPONSE(inboundSequence.getId()));
                }
                responseAdapter.appendSequenceAcknowledgementHeader(this.sequenceManager.getSequence(inboundSequence.getId()));
            } else {
                responseAdapter.setEmptyResponseMessage(this.requestAdapter, this.configuration.getRmVersion().sequenceAcknowledgementAction);
                responseAdapter.appendSequenceAcknowledgementHeader(this.sequenceManager.getSequence(inboundSequence.getId()));
            }
            if (this.configuration.isOrderedDelivery()) {
                FlowControledFibers.INSTANCE.tryResume(inboundSequence.getId(), inboundSequence.getLastMessageId() + 1L);
            }
            NextAction nextAction = super.processResponse(responseAdapter.getPacket());
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDestroy() {
        LOGGER.entering();
        try {
            super.preDestroy();
        }
        finally {
            LOGGER.exiting();
        }
    }

    private boolean isMessageInOrder(PacketAdapter requestAdapter) {
        Sequence inboundSequence = this.sequenceManager.getSequence(requestAdapter.getSequenceId());
        return inboundSequence.getLastMessageId() + 1L == requestAdapter.getMessageNumber();
    }

    private PacketAdapter processProtocolRequest(PacketAdapter requestAdapter) throws AbstractRmSoapFault {
        if (this.configuration.getRmVersion().createSequenceAction.equals(requestAdapter.getWsaAction())) {
            return this.handleCreateSequenceAction(requestAdapter);
        }
        if (this.configuration.getRmVersion().terminateSequenceAction.equals(requestAdapter.getWsaAction())) {
            return this.handleTerminateSequenceAction(requestAdapter);
        }
        if (this.configuration.getRmVersion().ackRequestedAction.equals(requestAdapter.getWsaAction())) {
            return this.handleAckRequestedAction(requestAdapter);
        }
        if (this.configuration.getRmVersion().sequenceAcknowledgementAction.equals(requestAdapter.getWsaAction())) {
            return this.handleSequenceAcknowledgementAction(requestAdapter);
        }
        return this.processVersionSpecificProtocolRequest(requestAdapter);
    }

    PacketAdapter processVersionSpecificProtocolRequest(PacketAdapter requestAdapter) throws AbstractRmSoapFault {
        throw new UnsupportedOperationException(LocalizationMessages.WSRM_1134_UNSUPPORTED_PROTOCOL_MESSAGE(requestAdapter.getWsaAction()));
    }

    abstract PacketAdapter handleCreateSequenceAction(PacketAdapter var1) throws CreateSequenceRefusedFault;

    abstract PacketAdapter handleTerminateSequenceAction(PacketAdapter var1) throws UnknownSequenceFault;

    PacketAdapter handleAckRequestedAction(PacketAdapter requestAdapter) throws UnknownSequenceFault, SequenceTerminatedFault {
        Sequence inboundSequence;
        try {
            inboundSequence = this.sequenceManager.getSequence(requestAdapter.getAckRequestedHeaderSequenceId());
        }
        catch (UnknownSequenceException e) {
            LOGGER.logException(e, this.getProtocolFaultLoggingLevel());
            throw LOGGER.logException(new UnknownSequenceFault(this.configuration, requestAdapter.getPacket(), e.getMessage()), this.getProtocolFaultLoggingLevel());
        }
        if (inboundSequence.getStatus() == Sequence.Status.TERMINATING) {
            throw LOGGER.logException(new SequenceTerminatedFault(this.configuration, requestAdapter.getPacket(), ""), this.getProtocolFaultLoggingLevel());
        }
        inboundSequence.updateLastActivityTime();
        return requestAdapter.createAckResponse(inboundSequence, this.configuration.getRmVersion().sequenceAcknowledgementAction);
    }

    PacketAdapter handleSequenceAcknowledgementAction(PacketAdapter requestAdapter) throws UnknownSequenceFault {
        this.processNonSequenceRmHeaders(requestAdapter);
        return requestAdapter.closeTransportAndReturnNull();
    }

    final Level getProtocolFaultLoggingLevel() {
        return Level.WARNING;
    }

    private void processNonSequenceRmHeaders(PacketAdapter requestAdapter) throws UnknownSequenceFault {
        String ackRequestedSequenceId = requestAdapter.getAckRequestedHeaderSequenceId();
        if (ackRequestedSequenceId != null) {
            this.getSequenceOrSoapFault(requestAdapter.getPacket(), ackRequestedSequenceId).setAckRequestedFlag();
        }
        requestAdapter.processAcknowledgements(this.sequenceManager, this.getOutboundSequenceId4Request(requestAdapter));
    }

    final String getOutboundSequenceId4Request(PacketAdapter requestAdapter) throws UnknownSequenceFault {
        Sequence boundSequence;
        String sequenceId = requestAdapter.getSequenceId();
        if (sequenceId == null) {
            return null;
        }
        try {
            boundSequence = this.sequenceManager.getBoundSequence(requestAdapter.getSequenceId());
        }
        catch (UnknownSequenceException e) {
            LOGGER.logException(e, this.getProtocolFaultLoggingLevel());
            throw new UnknownSequenceFault(this.configuration, requestAdapter.getPacket(), requestAdapter.getSequenceId());
        }
        return boundSequence != null ? boundSequence.getId() : null;
    }

    final Sequence getSequenceOrSoapFault(Packet packet, String sequenceId) throws UnknownSequenceFault {
        try {
            return this.sequenceManager.getSequence(sequenceId);
        }
        catch (UnknownSequenceException e) {
            LOGGER.logException(e, this.getProtocolFaultLoggingLevel());
            throw LOGGER.logException(new UnknownSequenceFault(this.configuration, packet, e.getMessage()), this.getProtocolFaultLoggingLevel());
        }
    }

    private boolean duplicatesNotAllowed() {
        return this.configuration.getDeliveryAssurance() != Configuration.DeliveryAssurance.AT_LEAST_ONCE;
    }
}

