/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime.server;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.rm.CloseSequenceException;
import com.sun.xml.ws.rm.CreateSequenceException;
import com.sun.xml.ws.rm.DuplicateMessageException;
import com.sun.xml.ws.rm.InvalidSequenceException;
import com.sun.xml.ws.rm.MessageNumberRolloverException;
import com.sun.xml.ws.rm.RmException;
import com.sun.xml.ws.rm.RmSecurityException;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.TerminateSequenceException;
import com.sun.xml.ws.rm.jaxws.runtime.BufferFullException;
import com.sun.xml.ws.rm.jaxws.runtime.InboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.OutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.RMMessage;
import com.sun.xml.ws.rm.jaxws.runtime.TubeBase;
import com.sun.xml.ws.rm.jaxws.runtime.server.RMDestination;
import com.sun.xml.ws.rm.jaxws.runtime.server.ServerInboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.server.ServerMessageSender;
import com.sun.xml.ws.rm.jaxws.runtime.server.ServerOutboundSequence;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.protocol.AbstractAcceptType;
import com.sun.xml.ws.rm.protocol.AbstractAckRequested;
import com.sun.xml.ws.rm.protocol.AbstractCreateSequence;
import com.sun.xml.ws.rm.protocol.AbstractCreateSequenceResponse;
import com.sun.xml.ws.rm.protocol.AbstractSequenceAcknowledgement;
import com.sun.xml.ws.rm.protocol.AbstractTerminateSequence;
import com.sun.xml.ws.rm.v200502.CreateSequenceElement;
import com.sun.xml.ws.rm.v200502.OfferType;
import com.sun.xml.ws.rm.v200502.SequenceElement;
import com.sun.xml.ws.rm.v200502.SequenceFaultElement;
import com.sun.xml.ws.rm.v200502.TerminateSequenceElement;
import com.sun.xml.ws.rm.v200702.AcceptType;
import com.sun.xml.ws.rm.v200702.AckRequestedElement;
import com.sun.xml.ws.rm.v200702.CloseSequenceElement;
import com.sun.xml.ws.rm.v200702.CloseSequenceResponseElement;
import com.sun.xml.ws.rm.v200702.CreateSequenceResponseElement;
import com.sun.xml.ws.rm.v200702.Identifier;
import com.sun.xml.ws.rm.v200702.MakeConnectionElement;
import com.sun.xml.ws.rm.v200702.SequenceAcknowledgementElement;
import com.sun.xml.ws.rm.v200702.TerminateSequenceResponseElement;
import com.sun.xml.ws.runtime.util.Session;
import com.sun.xml.ws.runtime.util.SessionManager;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.secext10.ObjectFactory;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.str.DirectReference;
import com.sun.xml.ws.security.trust.elements.str.Reference;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import java.net.URI;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

public final class RMServerTube
extends TubeBase {
    private static final RmLogger LOGGER = RmLogger.getLogger(RMServerTube.class);
    private boolean secureReliableMessaging = false;
    private RMMessage currentRequestMessage;
    private SessionManager sessionManager = SessionManager.getSessionManager();

    public RMServerTube(WSDLPort wsdlPort, WSBinding binding, Tube nextTube) {
        super(wsdlPort, binding, nextTube);
    }

    private RMServerTube(RMServerTube toCopy, TubeCloner cloner) {
        super(toCopy, cloner);
    }

    public NextAction processRequest(Packet requestPacket) {
        SOAPFault soapFault = null;
        RMMessage message = null;
        try {
            ServerInboundSequence inboundSequence;
            Packet protocolResponsePacket = null;
            try {
                protocolResponsePacket = this.handleProtocolMessage(requestPacket);
            }
            catch (CreateSequenceException e) {
                soapFault = this.createSoapFault(this.getConfig().getRMVersion().createSequenceRefusedFaultCode, LocalizationMessages.WSRM_3027_CREATE_SEQUENCE_REFUSED(e.getMessage()));
            }
            catch (TerminateSequenceException e) {
                soapFault = this.createSoapFault(this.getConfig().getRMVersion().sequenceTerminatedFaultCode, LocalizationMessages.WSRM_3028_SEQUENCE_TERMINATED_ON_ERROR(e.getMessage()));
            }
            catch (InvalidSequenceException e) {
                soapFault = this.createSoapFault(this.getConfig().getRMVersion().unknownSequenceFaultCode, LocalizationMessages.WSRM_3022_UNKNOWN_SEQUENCE_ID_IN_MESSAGE(e.getSequenceId()));
            }
            if (protocolResponsePacket != null) {
                return this.doReturnWith(protocolResponsePacket);
            }
            try {
                message = this.handleInboundMessage(requestPacket, RMDestination.getRMDestination());
            }
            catch (MessageNumberRolloverException e) {
                soapFault = this.createSoapFault(this.getConfig().getRMVersion().messageNumberRolloverFaultCode, LocalizationMessages.WSRM_3026_MESSAGE_NUMBER_ROLLOVER(e.getSequenceId(), e.getMessageNumber()));
            }
            catch (InvalidSequenceException e) {
                soapFault = this.createSoapFault(this.getConfig().getRMVersion().unknownSequenceFaultCode, LocalizationMessages.WSRM_3022_UNKNOWN_SEQUENCE_ID_IN_MESSAGE(e.getSequenceId()));
            }
            catch (CloseSequenceException e) {
                soapFault = this.createSoapFault(this.getConfig().getRMVersion().sequenceClosedFaultCode, LocalizationMessages.WSRM_3029_SEQUENCE_CLOSED(e.getSequenceId()));
            }
            if (soapFault != null) {
                Message soapFaultMessage = Messages.create(soapFault);
                if (this.getConfig().getSoapVersion() == SOAPVersion.SOAP_11) {
                    Header header = Headers.create(this.getConfig().getRMVersion().jaxbContext, (Object)new SequenceFaultElement());
                    soapFaultMessage.getHeaders().add(header);
                }
                Packet retPacket = requestPacket.createServerResponse(soapFaultMessage, this.getConfig().getAddressingVersion(), this.getConfig().getSoapVersion(), this.getConfig().getAddressingVersion().getDefaultFaultAction());
                retPacket.setMessage(soapFaultMessage);
                this.doReturnWith(retPacket);
            }
            if (RMDestination.getRMDestination().getProcessingFilter() != null) {
                RMDestination.getRMDestination().getProcessingFilter().handleEndpointRequestMessage(message);
            }
            if ((inboundSequence = (ServerInboundSequence)message.getSequence()) == null) {
                throw LOGGER.logSevereException(new RmException(LocalizationMessages.WSRM_3017_NOT_RELIABLE_SEQ_OR_PROTOCOL_MESSAGE()));
            }
            inboundSequence.resetLastActivityTime();
            if (this.secureReliableMessaging) {
                this.checkSTR(requestPacket, inboundSequence);
            }
            this.setSessionData(requestPacket, inboundSequence);
            requestPacket.transportBackChannel = null;
            requestPacket.invocationProperties.put("com.sun.xml.ws.sequence", inboundSequence);
            requestPacket.invocationProperties.put("com.sun.xml.ws.messagenumber", message.getMessageNumber());
            this.currentRequestMessage = message;
            if (!inboundSequence.isOrdered()) {
                return this.doInvoke(this.next, requestPacket);
            }
            ServerMessageSender sender = new ServerMessageSender(this, requestPacket, this.getConfig().getSoapVersion(), this.getConfig().getAddressingVersion());
            message.setMessageSender(sender);
            if (inboundSequence.isDeliverable(message)) {
                sender.send();
            }
            return this.doSuspend();
        }
        catch (BufferFullException e) {
            if (requestPacket.getMessage().isOneWay(this.getWsdlPort())) {
                Packet ret = new Packet();
                ret.invocationProperties.putAll(requestPacket.invocationProperties);
                return this.doReturnWith(ret);
            }
            try {
                ServerInboundSequence seq = (ServerInboundSequence)e.getSequence();
                if (seq != null) {
                    Packet ret = this.generateAckMessage(requestPacket, seq, this.getConfig().getRMVersion().sequenceAcknowledgementAction);
                    return this.doReturnWith(ret);
                }
                LOGGER.severe("!!!!!!!!!!!!!!!!!!!!!!! This code branch should not be reached !!!!!!!!!!!!!!!!!!!!!!!");
                return null;
            }
            catch (RmException ee) {
                LOGGER.severe(LocalizationMessages.WSRM_3001_ACKNOWLEDGEMENT_MESSAGE_EXCEPTION(), e);
                return this.doThrow(new WebServiceException(LocalizationMessages.WSRM_3001_ACKNOWLEDGEMENT_MESSAGE_EXCEPTION(), (Throwable)e));
            }
        }
        catch (DuplicateMessageException e) {
            Message response;
            if (requestPacket.getMessage().isOneWay(this.getWsdlPort())) {
                Packet ret = new Packet();
                ret.invocationProperties.putAll(requestPacket.invocationProperties);
                return this.doReturnWith(ret);
            }
            RMMessage original = e.getRMMessage();
            RMMessage origresp = original.getRelatedMessage();
            if (origresp != null && (response = origresp.getCopy()) != null) {
                Packet ret = new Packet(response);
                ret.invocationProperties.putAll(requestPacket.invocationProperties);
                return this.doReturnWith(ret);
            }
            try {
                ServerInboundSequence seq = (ServerInboundSequence)original.getSequence();
                Packet ret = this.generateAckMessage(requestPacket, seq, this.getConfig().getRMVersion().sequenceAcknowledgementAction);
                return this.doReturnWith(ret);
            }
            catch (RmException ee) {
                return this.doThrow(new WebServiceException((Throwable)ee));
            }
        }
        catch (RmException e) {
            Message fault = e.getFault();
            if (fault != null) {
                return this.doReturnWith(new Packet(fault));
            }
            return this.doThrow(new WebServiceException((Throwable)e));
        }
        catch (RuntimeException e) {
            return this.doThrow(new WebServiceException((Throwable)e));
        }
    }

    public NextAction processResponse(Packet packet) {
        ServerInboundSequence inboundSequence = (ServerInboundSequence)this.currentRequestMessage.getSequence();
        if (!inboundSequence.isOrdered()) {
            this.postProcess(packet);
        }
        return this.doReturnWith(packet);
    }

    public NextAction processException(Throwable t) {
        return this.doThrow(t);
    }

    public void postProcess(Packet packet) {
        ServerInboundSequence inboundSequence = (ServerInboundSequence)this.currentRequestMessage.getSequence();
        try {
            packet.invocationProperties.put("com.sun.xml.ws.sequence", null);
            packet.invocationProperties.put("com.sun.xml.ws.messagenumber", null);
            Message responseMessage = packet.getMessage();
            if (responseMessage == null) {
                Message emptyMessage = Messages.createEmpty(this.getConfig().getSoapVersion());
                packet.setMessage(emptyMessage);
            }
            RMMessage om = this.handleOutboundMessage(inboundSequence.getOutboundSequence(), packet, false, responseMessage == null);
            if (RMDestination.getRMDestination().getProcessingFilter() != null) {
                RMDestination.getRMDestination().getProcessingFilter().handleEndpointResponseMessage(om);
            }
            if (responseMessage == null && packet.getMessage() != null && !packet.getMessage().hasHeaders()) {
                packet.setMessage(null);
            } else {
                this.currentRequestMessage.setRelatedMessage(om);
                if (responseMessage == null && packet.getMessage() != null) {
                    String relatestToId;
                    HeaderList headerList = packet.getMessage().getHeaders();
                    String requestMessageId = packet.getMessage().getID(this.getConfig().getAddressingVersion(), this.getConfig().getSoapVersion());
                    if (requestMessageId != null) {
                        headerList.add(Headers.create(this.getConfig().getAddressingVersion().messageIDTag, requestMessageId));
                    }
                    if ((relatestToId = this.currentRequestMessage.getHeaders().getMessageID(this.getConfig().getAddressingVersion(), this.getConfig().getSoapVersion())) != null) {
                        headerList.add(Headers.create(this.getConfig().getAddressingVersion().relatesToTag, relatestToId));
                    }
                    headerList.add(Headers.create(this.getConfig().getAddressingVersion().actionTag, this.getConfig().getRMVersion().sequenceAcknowledgementAction));
                }
            }
            inboundSequence.releaseNextMessage(this.currentRequestMessage);
        }
        catch (RmException e) {
            Message fault = e.getFault();
            if (fault != null) {
                this.doReturnWith(new Packet(fault));
            } else {
                this.doThrow(new WebServiceException((Throwable)e));
            }
        }
        catch (RuntimeException e) {
            this.doThrow(new WebServiceException((Throwable)e));
        }
    }

    public void preDestroy() {
        this.next.preDestroy();
    }

    public RMServerTube copy(TubeCloner cloner) {
        return new RMServerTube(this, cloner);
    }

    public Tube nextTube() {
        return this.next;
    }

    public Packet handleProtocolMessage(Packet packet) throws RmException {
        String actionValue = packet.getMessage().getHeaders().getAction(this.getConfig().getAddressingVersion(), this.getConfig().getSoapVersion());
        if (actionValue == null || actionValue.equals("")) {
            throw LOGGER.logSevereException(new RmException(LocalizationMessages.WSRM_3018_NON_RM_REQUEST_OR_MISSING_WSA_ACTION_HEADER()));
        }
        if (this.getConfig().getRMVersion().createSequenceAction.equals(actionValue)) {
            return this.handleCreateSequenceAction(packet);
        }
        if (this.getConfig().getRMVersion().terminateSequenceAction.equals(actionValue)) {
            return this.handleTerminateSequenceAction(packet);
        }
        if (this.getConfig().getRMVersion().ackRequestedAction.equals(actionValue)) {
            return this.handleAckRequestedAction(packet);
        }
        if (this.getConfig().getRMVersion().lastAction.equals(actionValue)) {
            return this.handleLastMessageAction(packet);
        }
        if (RmVersion.WSRM11.closeSequenceAction.equals(actionValue)) {
            return this.handleCloseSequenceAction(packet);
        }
        if (this.getConfig().getRMVersion().sequenceAcknowledgementAction.equals(actionValue)) {
            return this.handleSequenceAcknowledgementAction(packet);
        }
        if (this.getConfig().getRMVersion().makeConnectionAction.equals(actionValue)) {
            return this.handleMakeConnectionAction(packet);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Packet handleCreateSequenceAction(Packet packet) throws RmException {
        Object id2;
        Object id;
        Object offer;
        AbstractCreateSequence csrElement;
        String offeredId = null;
        Message message = packet.getMessage();
        try {
            csrElement = (AbstractCreateSequence)message.readPayloadAsJAXB(this.getUnmarshaller());
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new RmException(LocalizationMessages.WSRM_3002_CREATESEQUENCE_HEADER_PROBLEM(), e));
        }
        SecurityTokenReferenceType strType = null;
        if (csrElement instanceof CreateSequenceElement) {
            offer = ((CreateSequenceElement)csrElement).getOffer();
            if (offer != null && (id = ((OfferType)offer).getIdentifier()) != null) {
                offeredId = ((com.sun.xml.ws.rm.v200502.Identifier)id).getValue();
            }
            this.secureReliableMessaging = (strType = ((CreateSequenceElement)csrElement).getSecurityTokenReference()) != null;
        } else {
            offer = ((com.sun.xml.ws.rm.v200702.CreateSequenceElement)csrElement).getOffer();
            if (offer != null && (id = ((com.sun.xml.ws.rm.v200702.OfferType)offer).getIdentifier()) != null) {
                offeredId = ((Identifier)id).getValue();
            }
            this.secureReliableMessaging = (strType = ((com.sun.xml.ws.rm.v200702.CreateSequenceElement)csrElement).getSecurityTokenReference()) != null;
        }
        ServerInboundSequence inboundSequence = RMDestination.getRMDestination().createSequence(null, offeredId, this.getConfig());
        inboundSequence.resetLastActivityTime();
        if (this.secureReliableMessaging) {
            JAXBElement<SecurityTokenReferenceType> jaxbElem;
            SecurityContextToken sct = (SecurityContextToken)packet.invocationProperties.get("Incoming_SCT");
            if (sct == null) throw LOGGER.logSevereException(new RmSecurityException(LocalizationMessages.WSRM_3006_NULL_SECURITY_TOKEN()));
            String securityContextTokenId = sct.getIdentifier().toString();
            WSTrustElementFactory wsTrustElemFactory = WSTrustElementFactory.newInstance();
            SecurityTokenReference str = wsTrustElemFactory.createSecurityTokenReference(jaxbElem = new ObjectFactory().createSecurityTokenReference(strType));
            Reference ref = str.getReference();
            if (!(ref instanceof DirectReference)) throw LOGGER.logSevereException(new RmSecurityException(LocalizationMessages.WSRM_3005_SECURITY_REFERENCE_ERROR(ref.getClass().getName())));
            DirectReference directRef = (DirectReference)ref;
            String gotId = directRef.getURIAttr().toString();
            if (!gotId.equals(securityContextTokenId)) throw LOGGER.logSevereException(new RmSecurityException(LocalizationMessages.WSRM_3004_SECURITY_TOKEN_AUTHORIZATION_ERROR(gotId, securityContextTokenId)));
            inboundSequence.setSecurityTokenReferenceId(securityContextTokenId);
        }
        this.startSession(inboundSequence);
        if (offeredId == null) {
            inboundSequence.getOutboundSequence().setSaveMessages(false);
        }
        AbstractAcceptType accept = null;
        AbstractCreateSequenceResponse crsElement = null;
        if (this.getConfig().getRMVersion() == RmVersion.WSRM10) {
            crsElement = new com.sun.xml.ws.rm.v200502.CreateSequenceResponseElement();
            id2 = new com.sun.xml.ws.rm.v200502.Identifier();
            ((com.sun.xml.ws.rm.v200502.Identifier)id2).setValue(inboundSequence.getId());
            ((com.sun.xml.ws.rm.v200502.CreateSequenceResponseElement)crsElement).setIdentifier((com.sun.xml.ws.rm.v200502.Identifier)id2);
            accept = new com.sun.xml.ws.rm.v200502.AcceptType();
        } else {
            crsElement = new CreateSequenceResponseElement();
            id2 = new Identifier();
            ((Identifier)id2).setValue(inboundSequence.getId());
            ((CreateSequenceResponseElement)crsElement).setIdentifier((Identifier)id2);
            accept = new AcceptType();
        }
        if (offeredId != null) {
            URI dest;
            String destString = message.getHeaders().getTo(this.getConfig().getAddressingVersion(), this.getConfig().getSoapVersion());
            try {
                dest = new URI(destString);
            }
            catch (Exception e) {
                throw LOGGER.logSevereException(new RmException(LocalizationMessages.WSRM_3019_INVALID_OR_MISSING_TO_ON_CS_MESSAGE(), e));
            }
            WSEndpointReference wsepr = new WSEndpointReference(dest, this.getConfig().getAddressingVersion());
            if (this.getConfig().getAddressingVersion() == AddressingVersion.W3C) {
                W3CEndpointReference endpointReference = (W3CEndpointReference)wsepr.toSpec();
                accept.setAcksTo(endpointReference);
            }
            crsElement.setAccept(accept);
        }
        Message response = Messages.create(this.getConfig().getRMVersion().jaxbContext, (Object)crsElement, this.getConfig().getSoapVersion());
        message.assertOneWay(false);
        return packet.createServerResponse(response, this.getConfig().getAddressingVersion(), this.getConfig().getSoapVersion(), this.getConfig().getRMVersion().createSequenceResponseAction);
    }

    public Packet handleTerminateSequenceAction(Packet packet) throws RmException {
        AbstractTerminateSequence tsElement;
        Message message = packet.getMessage();
        try {
            tsElement = (AbstractTerminateSequence)message.readPayloadAsJAXB(this.getUnmarshaller());
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new TerminateSequenceException(LocalizationMessages.WSRM_3007_TERMINATE_SEQUENCE_EXCEPTION(), e));
        }
        String terminateSequenceId = tsElement instanceof TerminateSequenceElement ? ((TerminateSequenceElement)tsElement).getIdentifier().getValue() : ((com.sun.xml.ws.rm.v200702.TerminateSequenceElement)tsElement).getIdentifier().getValue();
        ServerInboundSequence seq = RMDestination.getRMDestination().getInboundSequence(terminateSequenceId);
        if (seq == null) {
            throw LOGGER.logSevereException(new InvalidSequenceException(LocalizationMessages.WSRM_3022_UNKNOWN_SEQUENCE_ID_IN_MESSAGE(terminateSequenceId), terminateSequenceId));
        }
        this.endSession(seq);
        RMDestination.getRMDestination().terminateSequence(terminateSequenceId);
        Packet ret = null;
        OutboundSequence outboundSequence = seq.getOutboundSequence();
        Message response = null;
        String tsAction = null;
        switch (this.getConfig().getRMVersion()) {
            case WSRM10: {
                tsAction = RmVersion.WSRM10.terminateSequenceAction;
                if (outboundSequence.isSaveMessages()) {
                    TerminateSequenceElement terminateSeqResponse = new TerminateSequenceElement();
                    com.sun.xml.ws.rm.v200502.Identifier id2 = new com.sun.xml.ws.rm.v200502.Identifier();
                    id2.setValue(outboundSequence.getId());
                    terminateSeqResponse.setIdentifier(id2);
                    response = Messages.create(this.getConfig().getRMVersion().jaxbContext, (Object)terminateSeqResponse, this.getConfig().getSoapVersion());
                    ret = packet.createServerResponse(response, this.getConfig().getAddressingVersion(), this.getConfig().getSoapVersion(), tsAction);
                    AbstractSequenceAcknowledgement element = seq.generateSequenceAcknowledgement(true);
                    Header header = Headers.create(this.getConfig().getRMVersion().jaxbContext, (Object)element);
                    response.getHeaders().add(header);
                    break;
                }
                packet.transportBackChannel.close();
                ret = new Packet(null);
                break;
            }
            case WSRM11: {
                tsAction = RmVersion.WSRM11.terminateSequenceResponseAction;
                TerminateSequenceResponseElement terminateSeqResponse = new TerminateSequenceResponseElement();
                Identifier id2 = new Identifier();
                id2.setValue(terminateSequenceId);
                terminateSeqResponse.setIdentifier(id2);
                response = Messages.create(this.getConfig().getRMVersion().jaxbContext, (Object)terminateSeqResponse, this.getConfig().getSoapVersion());
                response.assertOneWay(false);
                ret = packet.createServerResponse(response, this.getConfig().getAddressingVersion(), this.getConfig().getSoapVersion(), tsAction);
                AbstractSequenceAcknowledgement element = seq.generateSequenceAcknowledgement(true);
                Header header = Headers.create(this.getConfig().getRMVersion().jaxbContext, (Object)element);
                response.getHeaders().add(header);
                break;
            }
        }
        return ret;
    }

    public Packet handleLastMessageAction(Packet inbound) throws RmException {
        try {
            Message message = inbound.getMessage();
            Header header = message.getHeaders().get(this.getConfig().getRMVersion().sequenceQName, true);
            if (header == null) {
                throw LOGGER.logSevereException(new RmException(LocalizationMessages.WSRM_3008_INVALID_LAST_MESSAGE()));
            }
            SequenceElement el = (SequenceElement)header.readAsJAXB(this.getUnmarshaller());
            String id = el.getId();
            ServerInboundSequence seq = RMDestination.getRMDestination().getInboundSequence(id);
            if (seq == null) {
                throw LOGGER.logSevereException(new InvalidSequenceException(LocalizationMessages.WSRM_3022_UNKNOWN_SEQUENCE_ID_IN_MESSAGE(id), id));
            }
            int messageNumber = (int)el.getNumber();
            seq.set(messageNumber, new RMMessage(message));
            return this.generateAckMessage(inbound, seq, this.getConfig().getRMVersion().lastAction);
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new RmException(LocalizationMessages.WSRM_3009_LAST_MESSAGE_EXCEPTION(), e));
        }
    }

    public Packet handleCloseSequenceAction(Packet inbound) throws RmException {
        CloseSequenceElement csElement;
        String id = null;
        Message message = inbound.getMessage();
        try {
            csElement = (CloseSequenceElement)message.readPayloadAsJAXB(this.getUnmarshaller());
        }
        catch (JAXBException e) {
            throw new RmException(LocalizationMessages.WSRM_3021_CLOSESEQUENCE_HEADER_PROBLEM(), e);
        }
        id = csElement.getIdentifier().getValue();
        ServerInboundSequence seq = RMDestination.getRMDestination().getInboundSequence(id);
        if (seq == null) {
            throw LOGGER.logSevereException(new InvalidSequenceException(LocalizationMessages.WSRM_3022_UNKNOWN_SEQUENCE_ID_IN_MESSAGE(id), id));
        }
        CloseSequenceResponseElement csrElement = new CloseSequenceResponseElement();
        Identifier identifier = new Identifier();
        identifier.setValue(seq.getId());
        csrElement.setIdentifier(identifier);
        Message response = Messages.create(this.getConfig().getRMVersion().jaxbContext, (Object)csrElement, this.getConfig().getSoapVersion());
        message.assertOneWay(false);
        Packet returnPacket = inbound.createServerResponse(response, this.getConfig().getAddressingVersion(), this.getConfig().getSoapVersion(), this.getConfig().getRMVersion().closeSequenceResponseAction);
        AbstractSequenceAcknowledgement element = seq.generateSequenceAcknowledgement(true);
        Header header = Headers.create(this.getConfig().getRMVersion().jaxbContext, (Object)element);
        response.getHeaders().add(header);
        return returnPacket;
    }

    public Packet handleAckRequestedAction(Packet inbound) throws RmException {
        try {
            Message message = inbound.getMessage();
            Header header = message.getHeaders().get(this.getConfig().getRMVersion().ackRequestedQName, true);
            if (header == null) {
                throw LOGGER.logSevereException(new RmException(LocalizationMessages.WSRM_3010_INVALID_ACK_REQUESTED()));
            }
            AbstractAckRequested el = (AbstractAckRequested)header.readAsJAXB(this.getUnmarshaller());
            String id = null;
            id = el instanceof com.sun.xml.ws.rm.v200502.AckRequestedElement ? ((com.sun.xml.ws.rm.v200502.AckRequestedElement)el).getId() : ((AckRequestedElement)el).getId();
            ServerInboundSequence seq = RMDestination.getRMDestination().getInboundSequence(id);
            if (seq == null) {
                throw LOGGER.logSevereException(new InvalidSequenceException(LocalizationMessages.WSRM_3022_UNKNOWN_SEQUENCE_ID_IN_MESSAGE(id), id));
            }
            seq.resetLastActivityTime();
            return this.generateAckMessage(inbound, seq, this.getConfig().getRMVersion().sequenceAcknowledgementAction);
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new RmException(LocalizationMessages.WSRM_3011_ACK_REQUESTED_EXCEPTION(), e));
        }
    }

    public Packet handleSequenceAcknowledgementAction(Packet inbound) throws RmException {
        try {
            Message message = inbound.getMessage();
            Header header = message.getHeaders().get(this.getConfig().getRMVersion().sequenceAcknowledgementQName, false);
            if (header == null) {
                throw LOGGER.logSevereException(new RmException(LocalizationMessages.WSRM_3012_INVALID_SEQ_ACKNOWLEDGEMENT()));
            }
            AbstractSequenceAcknowledgement el = (AbstractSequenceAcknowledgement)header.readAsJAXB(this.getUnmarshaller());
            String id = el instanceof com.sun.xml.ws.rm.v200502.SequenceAcknowledgementElement ? ((com.sun.xml.ws.rm.v200502.SequenceAcknowledgementElement)el).getId() : ((SequenceAcknowledgementElement)el).getId();
            ServerInboundSequence seq = RMDestination.getRMDestination().getInboundSequence(id);
            seq.resetLastActivityTime();
            this.handleInboundMessage(inbound, RMDestination.getRMDestination());
            inbound.transportBackChannel.close();
            Packet ret = new Packet(null);
            ret.invocationProperties.putAll(inbound.invocationProperties);
            return ret;
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new RmException(LocalizationMessages.WSRM_3013_SEQ_ACKNOWLEDGEMENT_EXCEPTION(), e));
        }
    }

    public Packet handleMakeConnectionAction(Packet packet) throws RmException {
        if (this.getConfig().getRMVersion() == RmVersion.WSRM10) {
            throw LOGGER.logSevereException(new RmException(LocalizationMessages.WSRM_3023_UNSUPPORTED_MAKECONNECTION_MESSAGE()));
        }
        MakeConnectionElement element = null;
        String sequenceId = null;
        Message message = packet.getMessage();
        try {
            element = (MakeConnectionElement)message.readPayloadAsJAXB(this.getUnmarshaller());
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new RmException(LocalizationMessages.WSRM_3024_INVALID_MAKECONNECTION_MESSAGE(), e));
        }
        sequenceId = element.getIdentifier().getValue();
        ServerOutboundSequence outboundSequence = RMDestination.getRMDestination().getOutboundSequence(sequenceId);
        if (outboundSequence == null) {
            throw LOGGER.logSevereException(new RmException(LocalizationMessages.WSRM_3025_INVALID_SEQUENCE_ID_IN_MAKECONNECTION_MESSAGE(sequenceId)));
        }
        Packet ret = new Packet();
        RMMessage unacknowledgedMessage = outboundSequence.getUnacknowledgedMessage();
        if (unacknowledgedMessage != null) {
            ret.setMessage(unacknowledgedMessage.getCopy());
        } else {
            ret.setMessage(Messages.createEmpty(this.getConfig().getSoapVersion()));
        }
        ret.invocationProperties.putAll(packet.invocationProperties);
        return ret;
    }

    private void checkSTR(Packet packet, InboundSequence seq) throws RmSecurityException {
        SecurityContextToken sct = (SecurityContextToken)packet.invocationProperties.get("Incoming_SCT");
        URI uri = sct.getIdentifier();
        if (!uri.toString().equals(seq.getSecurityTokenReferenceId())) {
            throw LOGGER.logSevereException(new RmSecurityException(LocalizationMessages.WSRM_3016_SECURITY_TOKEN_MISMATCH()));
        }
    }

    private Packet generateAckMessage(Packet inbound, InboundSequence seq, String action) throws RmException {
        Message message = Messages.createEmpty(this.getConfig().getSoapVersion());
        Packet outbound = inbound.createServerResponse(message, this.getConfig().getAddressingVersion(), this.getConfig().getSoapVersion(), action);
        outbound.invocationProperties.putAll(inbound.invocationProperties);
        AbstractSequenceAcknowledgement sequenceAckElement = seq.generateSequenceAcknowledgement(false);
        Header header = Headers.create(this.getConfig().getRMVersion().jaxbContext, (Object)sequenceAckElement);
        message.getHeaders().add(header);
        return outbound;
    }

    private SOAPFault createSoapFault(QName subcode, String faultMessage) throws RmException {
        try {
            SOAPFault fault;
            if (this.getConfig().getSoapVersion() == SOAPVersion.SOAP_12) {
                SOAPFactory factory = SOAPVersion.SOAP_12.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(subcode);
            } else {
                SOAPFactory factory = SOAPVersion.SOAP_11.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(subcode);
            }
            fault.setFaultString(faultMessage);
            return fault;
        }
        catch (SOAPException se) {
            throw new RmException("Error creating SOAP fault", se);
        }
    }

    public Session startSession(InboundSequence sequence) {
        String id = sequence.getSessionId();
        Session sess = this.sessionManager.getSession(id);
        if (sess == null) {
            sess = this.sessionManager.createSession(id);
        }
        sess.setSequence(sequence);
        return sess;
    }

    public void endSession(InboundSequence sequence) {
        String sessionId = sequence.getSessionId();
        if (sessionId.equals(sequence.getId())) {
            this.sessionManager.terminateSession(sessionId);
        }
    }

    private void setSessionData(Packet packet, InboundSequence seq) {
        if (null == packet.invocationProperties.get("com.sun.xml.ws.sessionid")) {
            packet.invocationProperties.put("com.sun.xml.ws.sessionid", seq.getSessionId());
        }
        if (null == packet.invocationProperties.get("com.sun.xml.ws.session")) {
            Session session = this.sessionManager.getSession(seq.getSessionId());
            packet.invocationProperties.put("com.sun.xml.ws.session", session.getUserData());
        }
    }
}

