/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.wss.provider.wsit.PacketMessageInfo;
import com.sun.xml.wss.provider.wsit.WSITAuthConfigProvider;
import com.sun.xml.wss.provider.wsit.logging.LogStringsMessages;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.xml.ws.WebServiceException;

public class WSITServerSecurityPipe
implements Pipe {
    private static final Logger log = Logger.getLogger("com.sun.xml.wss.provider.wsit", "com.sun.xml.wss.provider.wsit.logging.LogStrings");
    Map properties = null;
    Pipe nextPipe = null;
    ServerAuthConfig serverAuthConfig = null;
    ServerAuthContext serverAuthContext = null;

    public WSITServerSecurityPipe(WSITServerSecurityPipe that) {
        this.properties = that.properties;
        this.serverAuthConfig = that.serverAuthConfig;
        this.serverAuthContext = that.serverAuthContext;
    }

    public WSITServerSecurityPipe(Map properties, Pipe nextPipe) {
        this.properties = properties;
        this.nextPipe = nextPipe;
        properties.put("NEXT_PIPE", nextPipe);
        properties.put("WSIT_GENERIC_CALLBACK_HANDLER", "true");
        WSITAuthConfigProvider provider = new WSITAuthConfigProvider(properties, null);
        try {
            this.serverAuthConfig = provider.getServerAuthConfig("SOAP", null, null);
            this.serverAuthContext = this.serverAuthConfig.getAuthContext(null, null, properties);
        }
        catch (AuthException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0047_ERROR_CREATING_NEW_INSTANCE_WSIT_SERVER_SEC_PIPE(), e);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0047_ERROR_CREATING_NEW_INSTANCE_WSIT_SERVER_SEC_PIPE(), e);
        }
    }

    public Packet process(Packet packet) {
        PacketMessageInfo messageInfo = new PacketMessageInfo();
        try {
            block7: {
                block6: {
                    messageInfo.getMap().put("REQ_PACKET", packet);
                    AuthStatus status = this.serverAuthContext.validateRequest((MessageInfo)messageInfo, null, null);
                    if (status == AuthStatus.SEND_SUCCESS) break block6;
                    if (status == AuthStatus.SEND_FAILURE) break block6;
                    if (status != AuthStatus.FAILURE) break block7;
                }
                return (Packet)messageInfo.getMap().get("RES_PACKET");
            }
            Packet retPacket = this.nextPipe.process((Packet)messageInfo.getRequestMessage());
            messageInfo.getMap().put("RES_PACKET", retPacket);
            if (retPacket.getMessage() == null) {
                return retPacket;
            }
            this.serverAuthContext.secureResponse((MessageInfo)messageInfo, null);
        }
        catch (AuthException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0039_ERROR_PROCESSING_INCOMING_PACKET(), e);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0039_ERROR_PROCESSING_INCOMING_PACKET(), (Throwable)e);
        }
        return (Packet)messageInfo.getMap().get("RES_PACKET");
    }

    public void preDestroy() {
        try {
            this.serverAuthContext.cleanSubject(null, null);
        }
        catch (AuthException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0040_ERROR_CLEAN_SUBJECT(), e);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0040_ERROR_CLEAN_SUBJECT(), e);
        }
        if (this.nextPipe != null) {
            this.nextPipe.preDestroy();
        }
    }

    public Pipe copy(PipeCloner cloner) {
        Pipe clonedNextPipe = cloner.copy(this.nextPipe);
        WSITServerSecurityPipe copied = new WSITServerSecurityPipe(this);
        copied.setNextPipe(clonedNextPipe);
        cloner.add(this, copied);
        return copied;
    }

    public void setNextPipe(Pipe next) {
        this.nextPipe = next;
    }
}

