/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.callback;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.xml.wss.RealmAuthenticationAdapter;
import com.sun.xml.wss.impl.callback.XWSSCallback;
import com.sun.xml.wss.impl.misc.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import javax.security.auth.callback.Callback;

public class PasswordValidationCallback
extends XWSSCallback
implements Callback {
    private Request request;
    private boolean result = false;
    private PasswordValidator validator;
    private RealmAuthenticationAdapter authenticator = null;

    public PasswordValidationCallback(Request request) {
        this.request = request;
    }

    public boolean getResult() {
        try {
            if (this.validator != null) {
                this.result = this.validator.validate(this.request);
            }
        }
        catch (Exception e) {
            return false;
        }
        return this.result;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setValidator(PasswordValidator validator) {
        this.validator = validator;
    }

    public PasswordValidator getValidator() {
        return this.validator;
    }

    public void setRealmAuthentcationAdapter(RealmAuthenticationAdapter adapter) {
        this.authenticator = adapter;
    }

    public RealmAuthenticationAdapter getRealmAuthenticationAdapter() {
        return this.authenticator;
    }

    public static class PasswordValidationException
    extends Exception {
        public PasswordValidationException(String message) {
            super(message);
        }

        public PasswordValidationException(String message, Throwable cause) {
            super(message, cause);
        }

        public PasswordValidationException(Throwable cause) {
            super(cause);
        }
    }

    public static abstract class WsitDigestPasswordValidator
    extends DigestPasswordValidator {
        public abstract void setPassword(Request var1);
    }

    public static class DigestPasswordValidator
    implements PasswordValidator {
        public boolean validate(Request request) throws PasswordValidationException {
            byte[] hash;
            byte[] bytesToHash;
            byte[] utf8Bytes;
            DigestPasswordRequest req = (DigestPasswordRequest)request;
            String passwd = req.getPassword();
            String nonce = req.getNonce();
            String created = req.getCreated();
            String passwordDigest = req.getDigest();
            if (null == passwd) {
                return false;
            }
            byte[] decodedNonce = null;
            if (null != nonce) {
                try {
                    decodedNonce = Base64.decode(nonce);
                }
                catch (Base64DecodingException bde) {
                    throw new PasswordValidationException(bde);
                }
            }
            String utf8String = "";
            if (created != null) {
                utf8String = utf8String + created;
            }
            utf8String = utf8String + passwd;
            try {
                utf8Bytes = utf8String.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new PasswordValidationException(uee);
            }
            if (decodedNonce != null) {
                int i;
                bytesToHash = new byte[utf8Bytes.length + decodedNonce.length];
                for (i = 0; i < decodedNonce.length; ++i) {
                    bytesToHash[i] = decodedNonce[i];
                }
                for (i = decodedNonce.length; i < utf8Bytes.length + decodedNonce.length; ++i) {
                    bytesToHash[i] = utf8Bytes[i - decodedNonce.length];
                }
            } else {
                bytesToHash = utf8Bytes;
            }
            try {
                MessageDigest sha = MessageDigest.getInstance("SHA-1");
                hash = sha.digest(bytesToHash);
            }
            catch (Exception e) {
                throw new PasswordValidationException("Password Digest could not be created" + e);
            }
            return passwordDigest.equals(Base64.encode(hash));
        }
    }

    public static interface PasswordValidator {
        public boolean validate(Request var1) throws PasswordValidationException;
    }

    public static class DigestPasswordRequest
    implements Request {
        private String password;
        private String userName;
        private String digest;
        private String nonce;
        private String created;

        public DigestPasswordRequest(String userName, String digest, String nonce, String created) {
            this.userName = userName;
            this.digest = digest;
            this.nonce = nonce;
            this.created = created;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getPassword() {
            return this.password;
        }

        public String getUsername() {
            return this.userName;
        }

        public String getDigest() {
            return this.digest;
        }

        public String getNonce() {
            return this.nonce;
        }

        public String getCreated() {
            return this.created;
        }
    }

    public static class PlainTextPasswordRequest
    implements Request {
        private String password;
        private String userName;

        public PlainTextPasswordRequest(String userName, String password) {
            this.password = password;
            this.userName = userName;
        }

        public String getUsername() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }
    }

    public static interface Request {
    }
}

