/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policyconv;

import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policyconv.EncryptionAssertionProcessor;
import com.sun.xml.ws.security.impl.policyconv.EncryptionTargetCreator;
import com.sun.xml.ws.security.impl.policyconv.IntegrityAssertionProcessor;
import com.sun.xml.ws.security.impl.policyconv.PolicyID;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyUtil;
import com.sun.xml.ws.security.impl.policyconv.SignatureTargetCreator;
import com.sun.xml.ws.security.impl.policyconv.TokenProcessor;
import com.sun.xml.ws.security.impl.policyconv.XWSSPolicyContainer;
import com.sun.xml.ws.security.policy.AlgorithmSuite;
import com.sun.xml.ws.security.policy.Binding;
import com.sun.xml.ws.security.policy.EncryptedElements;
import com.sun.xml.ws.security.policy.EncryptedParts;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.policy.SignedElements;
import com.sun.xml.ws.security.policy.SignedParts;
import com.sun.xml.ws.security.policy.SupportingTokens;
import com.sun.xml.ws.security.policy.Target;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.ws.security.policy.UserNameToken;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportingTokensProcessor {
    protected TokenProcessor tokenProcessor = null;
    protected SignatureTargetCreator stc = null;
    protected EncryptionTargetCreator etc = null;
    protected Binding binding = null;
    protected XWSSPolicyContainer policyContainer = null;
    protected SignaturePolicy signaturePolicy = null;
    protected EncryptionPolicy encryptionPolicy = null;
    protected SupportingTokens st = null;
    protected IntegrityAssertionProcessor iAP = null;
    protected EncryptionAssertionProcessor eAP = null;
    protected ArrayList<SignaturePolicy> spList = null;
    protected ArrayList<EncryptionPolicy> epList = null;
    protected SignedParts emptySP = null;
    protected boolean buildSP = false;
    protected boolean buildEP = false;
    protected PolicyID pid = null;

    protected SupportingTokensProcessor() {
    }

    public SupportingTokensProcessor(SupportingTokens st, TokenProcessor tokenProcessor, Binding binding, XWSSPolicyContainer container, SignaturePolicy sp, EncryptionPolicy ep, PolicyID pid) {
        this.st = st;
        this.tokenProcessor = tokenProcessor;
        this.binding = binding;
        this.pid = pid;
        this.policyContainer = container;
        this.encryptionPolicy = ep;
        this.signaturePolicy = sp;
        AlgorithmSuite as = null;
        as = st.getAlgorithmSuite();
        if (as == null) {
            as = binding.getAlgorithmSuite();
        }
        this.iAP = new IntegrityAssertionProcessor(as, binding.isSignContent());
        this.eAP = new EncryptionAssertionProcessor(as, false);
        this.stc = this.iAP.getTargetCreator();
        this.etc = this.eAP.getTargetCreator();
        this.emptySP = this.getEmptySignedParts(st.getSignedParts());
    }

    public void process() throws PolicyException {
        Iterator tokens = this.st.getTokens();
        if (this.st.getEncryptedParts().hasNext() || this.st.getEncryptedElements().hasNext()) {
            this.buildEP = true;
        }
        if (this.st.getSignedElements().hasNext() || this.st.getSignedParts().hasNext()) {
            this.buildSP = true;
        }
        while (tokens.hasNext()) {
            Token token = (Token)tokens.next();
            SecurityPolicyVersion spVersion = SecurityPolicyUtil.getSPVersion((PolicyAssertion)((Object)token));
            WSSPolicy policy = this.tokenProcessor.getWSSToken(token);
            if (policy.getUUID() != null) {
                this.addToPrimarySignature(policy, token);
                this.encryptToken(token, spVersion);
                if (PolicyUtil.isSamlToken((PolicyAssertion)((Object)token), spVersion)) {
                    this.correctSAMLBinding(policy);
                }
                this.collectSignaturePolicies(token);
                if (this.buildEP) {
                    EncryptionPolicy ep = new EncryptionPolicy();
                    ep.setKeyBinding(policy);
                    this.getEPList().add(ep);
                }
            }
            AuthenticationTokenPolicy atp = new AuthenticationTokenPolicy();
            atp.setFeatureBinding(policy);
            this.policyContainer.insert(atp);
            this.addTargets();
        }
    }

    protected void collectSignaturePolicies(Token token) throws PolicyException {
        if (this.buildSP) {
            this.createSupportingSignature(token);
        }
    }

    protected void createSupportingSignature(Token token) throws PolicyException {
        SignaturePolicy sp = new SignaturePolicy();
        sp.setUUID(this.pid.generateID());
        this.tokenProcessor.addKeyBinding(sp, token, true);
        if (this.binding.getTokenProtection()) {
            this.protectToken((WSSPolicy)sp.getKeyBinding(), sp);
        }
        SignaturePolicy.FeatureBinding spFB = (SignaturePolicy.FeatureBinding)sp.getFeatureBinding();
        AlgorithmSuite as = null;
        as = this.st.getAlgorithmSuite();
        if (as == null) {
            as = this.binding.getAlgorithmSuite();
        }
        SecurityPolicyUtil.setCanonicalizationMethod(spFB, as);
        this.getSPList().add(sp);
        this.endorseSignature(sp);
    }

    protected void addToPrimarySignature(WSSPolicy policy, Token token) throws PolicyException {
    }

    protected void endorseSignature(SignaturePolicy sp) {
    }

    protected ArrayList<SignaturePolicy> getSPList() {
        if (this.spList == null) {
            this.spList = new ArrayList();
        }
        return this.spList;
    }

    protected ArrayList<EncryptionPolicy> getEPList() {
        if (this.epList == null) {
            this.epList = new ArrayList();
        }
        return this.epList;
    }

    protected void encryptToken(Token token, SecurityPolicyVersion spVersion) throws PolicyException {
        if (PolicyUtil.isUsernameToken((PolicyAssertion)((Object)token), spVersion) && ((UserNameToken)token).hasPassword() && !((UserNameToken)token).useHashPassword() && token.getTokenId() != null) {
            EncryptionPolicy.FeatureBinding fb = (EncryptionPolicy.FeatureBinding)this.encryptionPolicy.getFeatureBinding();
            EncryptionTarget et = this.etc.newURIEncryptionTarget(token.getTokenId());
            fb.addTargetBinding(et);
        }
    }

    protected SignedParts getEmptySignedParts(Iterator itr) {
        while (itr.hasNext()) {
            SecurityPolicyVersion spVersion;
            Target target = (Target)itr.next();
            if (!PolicyUtil.isSignedParts((PolicyAssertion)((Object)target), spVersion = SecurityPolicyUtil.getSPVersion((PolicyAssertion)((Object)target))) || !SecurityPolicyUtil.isSignedPartsEmpty((SignedParts)target)) continue;
            return (SignedParts)target;
        }
        return null;
    }

    protected void addTargets() {
        if (this.binding.getProtectionOrder() == "SignBeforeEncrypting") {
            if (this.spList != null) {
                this.populateSignaturePolicy();
            }
            if (this.epList != null) {
                this.populateEncryptionPolicy();
            }
        } else {
            if (this.epList != null) {
                this.populateEncryptionPolicy();
            }
            if (this.spList != null) {
                this.populateSignaturePolicy();
            }
        }
    }

    protected void populateSignaturePolicy() {
        for (SignaturePolicy sp : this.spList) {
            Target target;
            Iterator<Target> itr;
            SignaturePolicy.FeatureBinding spFB = (SignaturePolicy.FeatureBinding)sp.getFeatureBinding();
            if (this.emptySP != null) {
                this.iAP.process(this.emptySP, spFB);
            } else {
                itr = this.st.getSignedParts();
                while (itr.hasNext()) {
                    target = itr.next();
                    this.iAP.process((SignedParts)target, spFB);
                }
            }
            itr = this.st.getSignedElements();
            while (itr.hasNext()) {
                target = (SignedElements)itr.next();
                this.iAP.process((SignedElements)target, spFB);
            }
            this.policyContainer.insert(sp);
        }
    }

    protected void populateEncryptionPolicy() {
        for (EncryptionPolicy ep : this.epList) {
            EncryptionPolicy.FeatureBinding epFB = (EncryptionPolicy.FeatureBinding)ep.getFeatureBinding();
            Iterator<EncryptedElements> itr = this.st.getEncryptedElements();
            while (itr.hasNext()) {
                EncryptedElements target = itr.next();
                this.eAP.process(target, epFB);
            }
            Iterator<EncryptedParts> epr = this.st.getEncryptedParts();
            while (epr.hasNext()) {
                EncryptedParts target = epr.next();
                this.eAP.process(target, epFB);
            }
            this.policyContainer.insert(ep);
        }
    }

    protected void protectToken(WSSPolicy token, SignaturePolicy sp) {
        String uid = token.getUUID();
        if (uid != null) {
            SignatureTargetCreator stc = this.iAP.getTargetCreator();
            SignatureTarget st = stc.newURISignatureTarget(uid);
            stc.addTransform(st);
            SecurityPolicyUtil.setName(st, token);
            stc.addSTRTransform(st);
            SignaturePolicy.FeatureBinding fb = (SignaturePolicy.FeatureBinding)sp.getFeatureBinding();
            fb.addTargetBinding(st);
        }
    }

    protected void correctSAMLBinding(WSSPolicy policy) {
    }
}

