/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.rm.CloseSequenceException;
import com.sun.xml.ws.rm.CreateSequenceException;
import com.sun.xml.ws.rm.MessageNumberRolloverException;
import com.sun.xml.ws.rm.RmException;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.TerminateSequenceException;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.runtime.ClientSession;
import com.sun.xml.ws.rm.runtime.ProtocolCommunicator;
import com.sun.xml.ws.rm.runtime.Sequence;
import com.sun.xml.ws.rm.runtime.UnknownSequenceException;
import com.sun.xml.ws.rm.v200702.AcceptType;
import com.sun.xml.ws.rm.v200702.AckRequestedElement;
import com.sun.xml.ws.rm.v200702.CloseSequenceElement;
import com.sun.xml.ws.rm.v200702.CloseSequenceResponseElement;
import com.sun.xml.ws.rm.v200702.CreateSequenceElement;
import com.sun.xml.ws.rm.v200702.CreateSequenceResponseElement;
import com.sun.xml.ws.rm.v200702.Identifier;
import com.sun.xml.ws.rm.v200702.OfferType;
import com.sun.xml.ws.rm.v200702.SequenceAcknowledgementElement;
import com.sun.xml.ws.rm.v200702.SequenceElement;
import com.sun.xml.ws.rm.v200702.TerminateSequenceElement;
import com.sun.xml.ws.rm.v200702.TerminateSequenceResponseElement;
import com.sun.xml.ws.rm.v200702.UsesSequenceSTR;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

final class Rm11ClientSession
extends ClientSession {
    private static final RmLogger LOGGER = RmLogger.getLogger(Rm11ClientSession.class);

    public Rm11ClientSession(Configuration configuration, ProtocolCommunicator communicator) {
        super(configuration, communicator);
    }

    protected void openRmSession(String offerInboundSequenceId, SecurityTokenReferenceType strType) throws RmException {
        Message csResponseMessage;
        CreateSequenceElement csElement = new CreateSequenceElement();
        csElement.setAcksTo(new W3CEndpointReference(this.configuration.getAddressingVersion().anonymousEpr.asSource("AcksTo")));
        if (offerInboundSequenceId != null) {
            Identifier offerIdentifier = new Identifier();
            offerIdentifier.setValue(offerInboundSequenceId);
            OfferType offer = new OfferType();
            offer.setIdentifier(offerIdentifier);
            offer.setEndpoint(csElement.getAcksTo());
            csElement.setOffer(offer);
        }
        if (strType != null) {
            csElement.setSecurityTokenReference(strType);
        }
        Message csMessage = this.communicator.createMessage(csElement);
        if (strType != null) {
            HeaderList headerList = csMessage.getHeaders();
            UsesSequenceSTR usesSequenceSTR = new UsesSequenceSTR();
            usesSequenceSTR.getOtherAttributes().put(this.communicator.soapMustUnderstandAttributeName, "true");
            headerList.add(Headers.create(RmVersion.WSRM11.jaxbContext, (Object)usesSequenceSTR));
        }
        if ((csResponseMessage = this.communicator.send(csMessage, RmVersion.WSRM11.createSequenceAction)) == null) {
            throw LOGGER.logSevereException(new CreateSequenceException("CreateSequenceResponse was 'null'"));
        }
        if (csResponseMessage.isFault()) {
            throw LOGGER.logSevereException(new CreateSequenceException("CreateSequence was refused by the RMDestination", csResponseMessage));
        }
        CreateSequenceResponseElement csrElement = (CreateSequenceResponseElement)this.communicator.unmarshallMessage(csResponseMessage);
        this.outboundSequenceId = csrElement.getIdentifier().getValue();
        long expirationTime = -1L;
        if (csrElement.getExpires() != null && !"PT0S".equals(csrElement.getExpires().getValue().toString())) {
            expirationTime = csrElement.getExpires().getValue().getTimeInMillis(Calendar.getInstance()) + System.currentTimeMillis();
        }
        this.sequenceManager.createOutboudSequence(this.outboundSequenceId, expirationTime);
        if (offerInboundSequenceId != null) {
            AcceptType accept = csrElement.getAccept();
            if (accept == null || !this.communicator.getDestination().getAddress().equals(new WSEndpointReference((EndpointReference)accept.getAcksTo()).getAddress())) {
                throw new CreateSequenceException("Unsupported \"AcksTo\" destination. Inbound sequence \"AcksTo\" destination [" + accept.getAcksTo().toString() + "] " + "must be the same as the service endpoint destination [" + this.communicator.getDestination() + "]", this.inboundSequenceId);
            }
            this.inboundSequenceId = offerInboundSequenceId;
            this.sequenceManager.createInboundSequence(this.inboundSequenceId, -1L);
        }
    }

    protected void appendSequenceHeader(Message outboundMessage) throws UnknownSequenceException, MessageNumberRolloverException {
        long messageNumber = this.sequenceManager.getSequence(this.outboundSequenceId).getNextMessageId();
        SequenceElement sequenceHeaderElement = new SequenceElement();
        sequenceHeaderElement.setNumber(messageNumber);
        sequenceHeaderElement.setId(this.outboundSequenceId);
        outboundMessage.getHeaders().add(this.communicator.createHeader(sequenceHeaderElement));
    }

    protected void appendAckRequestedHeader(Message outboundMessage) {
        AckRequestedElement ackRequestedElement = new AckRequestedElement();
        ackRequestedElement.setId(this.outboundSequenceId);
        outboundMessage.getHeaders().add(this.communicator.createHeader(ackRequestedElement));
    }

    protected void appendSequenceAcknowledgementHeader(Message outboundMessage) throws UnknownSequenceException {
        SequenceAcknowledgementElement ackElement = new SequenceAcknowledgementElement();
        Identifier identifier = new Identifier();
        identifier.setValue(this.inboundSequenceId);
        ackElement.setIdentifier(identifier);
        List<Sequence.AckRange> acknowledgedIndexes = this.sequenceManager.getSequence(this.inboundSequenceId).getAcknowledgedMessageIds();
        if (acknowledgedIndexes != null && !acknowledgedIndexes.isEmpty()) {
            for (Sequence.AckRange range : acknowledgedIndexes) {
                ackElement.addAckRange(range.lower, range.upper);
            }
        } else {
            ackElement.setNone(new SequenceAcknowledgementElement.None());
        }
        if (this.sequenceManager.getSequence(this.inboundSequenceId).isClosed()) {
            SequenceAcknowledgementElement.Final finalElement = new SequenceAcknowledgementElement.Final();
            ackElement.setFinal(finalElement);
        }
        outboundMessage.getHeaders().add(this.communicator.createHeader(ackElement));
    }

    protected void closeOutboundSequence() throws RmException {
        Message request = this.communicator.createMessage(new CloseSequenceElement(this.outboundSequenceId, this.sequenceManager.getSequence(this.outboundSequenceId).getLastMessageId()));
        this.appendSequenceAcknowledgementHeader(request);
        Message response = this.communicator.send(request, RmVersion.WSRM11.closeSequenceAction);
        if (response == null) {
            throw new CloseSequenceException("CloseSequenceResponse was 'null'");
        }
        this.processInboundMessageHeaders(response.getHeaders(), false);
        if (response.isFault()) {
            throw new CloseSequenceException("CloseSequence was refused by the RMDestination", response);
        }
        CloseSequenceResponseElement csrElement = (CloseSequenceResponseElement)this.communicator.unmarshallMessage(response);
        if (!this.outboundSequenceId.equals(csrElement.getIdentifier().getValue())) {
            throw new CloseSequenceException("The sequence identifier in the close sequence response message [" + csrElement.getIdentifier().getValue() + "]" + " does not correspond to the closing outbound sequence identifier [" + this.outboundSequenceId + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminateOutboundSequence() throws RmException {
        Message request = this.communicator.createMessage(new TerminateSequenceElement(this.outboundSequenceId, this.sequenceManager.getSequence(this.outboundSequenceId).getLastMessageId()));
        Message response = null;
        try {
            response = this.communicator.send(request, RmVersion.WSRM11.terminateSequenceAction);
            if (response == null) {
                throw new TerminateSequenceException("TerminateSequenceResponse was 'null'");
            }
            this.processInboundMessageHeaders(response.getHeaders(), false);
            if (response.isFault()) {
                throw new TerminateSequenceException("There was an error during the sequence termination", response);
            }
            String responseAction = this.communicator.getAction(response);
            if (RmVersion.WSRM11.terminateSequenceAction.equals(responseAction)) {
                TerminateSequenceElement tsElement = (TerminateSequenceElement)this.communicator.unmarshallMessage(response);
                response = null;
                this.sequenceManager.terminateSequence(tsElement.getIdentifier().getValue());
            } else if (RmVersion.WSRM11.terminateSequenceResponseAction.equals(responseAction)) {
                TerminateSequenceResponseElement tsrElement = (TerminateSequenceResponseElement)this.communicator.unmarshallMessage(response);
                response = null;
                if (!this.outboundSequenceId.equals(tsrElement.getIdentifier().getValue())) {
                    throw new TerminateSequenceException("The sequence identifier in the terminate sequence response message [" + tsrElement.getIdentifier().getValue() + "]" + " does not correspond to the terminating outbound sequence identifier [" + this.outboundSequenceId + "]");
                }
            }
        }
        finally {
            if (response != null) {
                response.consume();
            }
        }
    }

    protected void processSequenceHeader(HeaderList inboundMessageHeaders) throws RmException {
        SequenceElement sequenceElement = (SequenceElement)this.communicator.readHeaderAsUnderstood(inboundMessageHeaders, "Sequence");
        if (sequenceElement == null) {
            throw new RmException("Mandatory <Sequence ... /> header not present on the response message");
        }
        this.assertSequenceIdInInboundHeader(this.inboundSequenceId, sequenceElement.getId());
        this.sequenceManager.getSequence(sequenceElement.getId()).acknowledgeMessageId(sequenceElement.getMessageNumber());
    }

    protected void processAcknowledgementHeader(HeaderList inboundMessageHeaders) throws RmException {
        SequenceAcknowledgementElement ackElement = (SequenceAcknowledgementElement)this.communicator.readHeaderAsUnderstood(inboundMessageHeaders, "SequenceAcknowledgement");
        if (ackElement != null) {
            this.assertSequenceIdInInboundHeader(this.outboundSequenceId, ackElement.getId());
            LinkedList<Sequence.AckRange> ranges = new LinkedList<Sequence.AckRange>();
            if (ackElement.getNone() == null) {
                if (!ackElement.getNack().isEmpty()) {
                    ArrayList<BigInteger> nacks = new ArrayList<BigInteger>(ackElement.getNack());
                    Collections.sort(nacks);
                    long lastLowerBound = 1L;
                    for (BigInteger nackId : nacks) {
                        if (lastLowerBound == nackId.longValue()) {
                            ++lastLowerBound;
                            continue;
                        }
                        ranges.add(new Sequence.AckRange(lastLowerBound, nackId.longValue() - 1L));
                        lastLowerBound = nackId.longValue() + 1L;
                    }
                    long lastMessageId = this.sequenceManager.getSequence(this.outboundSequenceId).getLastMessageId();
                    if (lastLowerBound <= lastMessageId) {
                        ranges.add(new Sequence.AckRange(lastLowerBound, lastMessageId));
                    }
                } else if (ackElement.getAcknowledgementRange() != null && !ackElement.getAcknowledgementRange().isEmpty()) {
                    for (SequenceAcknowledgementElement.AcknowledgementRange rangeElement : ackElement.getAcknowledgementRange()) {
                        ranges.add(new Sequence.AckRange(rangeElement.getLower().longValue(), rangeElement.getUpper().longValue()));
                    }
                }
            }
            this.sequenceManager.getSequence(this.outboundSequenceId).acknowledgeMessageIds(ranges);
        }
    }

    protected void processAckRequestedHeader(HeaderList inboundMessageHeaders) throws RmException {
        AckRequestedElement ackRequestedElement = (AckRequestedElement)this.communicator.readHeaderAsUnderstood(inboundMessageHeaders, "AckRequested");
        if (ackRequestedElement != null) {
            String sequenceId = ackRequestedElement.getId();
            this.assertSequenceIdInInboundHeader(this.inboundSequenceId, sequenceId);
            this.sequenceManager.getSequence(sequenceId).setAckRequestedFlag();
        }
    }
}

