/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.runtime.AbstractSequence;
import com.sun.xml.ws.rm.runtime.IllegalMessageIdentifierException;
import com.sun.xml.ws.rm.runtime.Sequence;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InboundSequence
extends AbstractSequence {
    private static final RmLogger LOGGER = RmLogger.getLogger(InboundSequence.class);
    private long lastAckedIndex = 0L;

    public InboundSequence(String id, long expirationTime) {
        super(id, expirationTime, new TreeSet<Long>());
    }

    @Override
    public long getLastMessageId() {
        return this.lastAckedIndex;
    }

    @Override
    public void acknowledgeMessageIds(List<Sequence.AckRange> ranges) throws IllegalMessageIdentifierException {
        for (Sequence.AckRange range : ranges) {
            for (long index = range.lower; index <= range.upper; ++index) {
                this.acknowledgeMessageId(index);
            }
        }
    }

    @Override
    public void acknowledgeMessageId(long messageId) throws IllegalMessageIdentifierException {
        if (messageId > this.lastAckedIndex) {
            if (this.lastAckedIndex + 1L != messageId) {
                for (long lostIndex = this.lastAckedIndex + 1L; lostIndex < messageId; ++lostIndex) {
                    this.unackedIndexes.add(lostIndex);
                }
            }
            this.lastAckedIndex = messageId;
        } else if (this.lastAckedIndex == messageId) {
            if (this.unackedIndexes.contains(messageId)) {
                this.unackedIndexes.remove(messageId);
            } else {
                throw LOGGER.logSevereException(new IllegalMessageIdentifierException(messageId));
            }
        }
    }
}

