/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.xml.ws.rm.MessageNumberRolloverException;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.runtime.Sequence;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSequence
implements Sequence {
    private static final RmLogger LOGGER = RmLogger.getLogger(AbstractSequence.class);
    protected static final long UNSPECIFIED_MESSAGE_ID = 0L;
    protected static final long MIN_MESSAGE_ID = 1L;
    protected static final long MAX_MESSAGE_ID = Long.MAX_VALUE;
    protected final Collection<Long> unackedIndexes;
    private final String id;
    private final long expirationTime;
    private Sequence.Status status;
    private boolean ackRequestedFlag;

    protected AbstractSequence(String id, long expirationTime, Collection<Long> unackedMessageIdentifiersStorage) {
        this.id = id;
        this.expirationTime = expirationTime;
        this.unackedIndexes = unackedMessageIdentifiersStorage;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getNextMessageId() throws MessageNumberRolloverException {
        throw new UnsupportedOperationException("This operation is not supported in this Sequence implementation.");
    }

    @Override
    public List<Sequence.AckRange> getAcknowledgedMessageIds() {
        if (this.getLastMessageId() == 0L) {
            return Collections.emptyList();
        }
        if (this.unackedIndexes.isEmpty()) {
            return Arrays.asList(new Sequence.AckRange(1L, this.getLastMessageId()));
        }
        LinkedList<Sequence.AckRange> result = new LinkedList<Sequence.AckRange>();
        long lastUnacked = this.unackedIndexes.iterator().next();
        if (lastUnacked > 1L) {
            result.add(new Sequence.AckRange(1L, lastUnacked - 1L));
        }
        for (long unackedIndex : this.unackedIndexes) {
            if (unackedIndex > lastUnacked + 1L) {
                result.add(new Sequence.AckRange(lastUnacked + 1L, unackedIndex - 1L));
            }
            lastUnacked = unackedIndex;
        }
        return result;
    }

    @Override
    public boolean hasPendingAcknowledgements() {
        return !this.unackedIndexes.isEmpty();
    }

    @Override
    public Sequence.Status getStatus() {
        return this.status;
    }

    protected void setStatus(Sequence.Status newStatus) {
        this.status = newStatus;
    }

    @Override
    public final void setAckRequestedFlag() {
        this.ackRequestedFlag = true;
    }

    protected final void clearAckRequestedFlag() {
        this.ackRequestedFlag = false;
    }

    @Override
    public boolean isAckRequested() {
        return this.ackRequestedFlag;
    }

    @Override
    public void close() {
        this.setStatus(Sequence.Status.CLOSED);
    }

    @Override
    public boolean isClosed() {
        return this.status == Sequence.Status.CLOSING || this.status == Sequence.Status.CLOSED || this.status == Sequence.Status.TERMINATING;
    }

    @Override
    public boolean isExpired() {
        return this.expirationTime == -1L ? false : System.currentTimeMillis() < this.expirationTime;
    }

    @Override
    public void preDestroy() {
    }
}

