/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.policy.assertion;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.ComplexAssertion;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.policy.spi.AssertionCreationException;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.assertion.RmAssertionInstantiator;
import java.util.Collection;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RmFlowControlAssertion
extends ComplexAssertion {
    public static final QName NAME = new QName("http://schemas.microsoft.com/net/2005/02/rm/policy", "RmFlowControl");
    private static final RmLogger LOGGER = RmLogger.getLogger(RmFlowControlAssertion.class);
    private static final QName BUFFER_SIZE_ASSERTION_QNAME = new QName("http://schemas.microsoft.com/net/2005/02/rm/policy", "MaxReceiveBufferSize");
    private static RmAssertionInstantiator instantiator = new RmAssertionInstantiator(){

        @Override
        public PolicyAssertion newInstance(AssertionData data, Collection<PolicyAssertion> assertionParameters, AssertionSet nestedAlternative) throws AssertionCreationException {
            return new RmFlowControlAssertion(data, assertionParameters, nestedAlternative);
        }
    };
    private final long maxBufferSize;

    public static RmAssertionInstantiator getInstantiator() {
        return instantiator;
    }

    private RmFlowControlAssertion(AssertionData data, Collection<? extends PolicyAssertion> assertionParameters, AssertionSet nestedAlternative) throws AssertionCreationException {
        super(data, assertionParameters, nestedAlternative);
        long _maxBufferSize = -1L;
        if (nestedAlternative != null) {
            for (PolicyAssertion assertion : nestedAlternative) {
                if (!BUFFER_SIZE_ASSERTION_QNAME.equals(assertion.getName())) continue;
                _maxBufferSize = this.evaluateBufferSize(_maxBufferSize == -1L, assertion.getValue(), data);
            }
        }
        this.maxBufferSize = _maxBufferSize == -1L ? 32L : _maxBufferSize;
    }

    public long getMaximumBufferSize() {
        return this.maxBufferSize;
    }

    private long evaluateBufferSize(boolean successCondition, String valueOnSuccess, AssertionData data) throws AssertionCreationException {
        if (successCondition) {
            return Long.parseLong(valueOnSuccess);
        }
        throw LOGGER.logSevereException(new AssertionCreationException(data, "Inconsistent RM policy: Multiple flow control buffer sizes specified."));
    }
}

