/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.rm.BufferFullException;
import com.sun.xml.ws.rm.DuplicateMessageException;
import com.sun.xml.ws.rm.InvalidMessageNumberException;
import com.sun.xml.ws.rm.RMMessage;
import com.sun.xml.ws.rm.RmException;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.Sequence;
import com.sun.xml.ws.rm.jaxws.runtime.InboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.SequenceConfig;
import com.sun.xml.ws.rm.jaxws.util.ProcessingFilter;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.protocol.AbstractAckRequested;
import com.sun.xml.ws.rm.protocol.AbstractSequence;
import com.sun.xml.ws.rm.protocol.AbstractSequenceAcknowledgement;
import com.sun.xml.ws.rm.v200502.SequenceAcknowledgementElement;
import com.sun.xml.ws.rm.v200502.SequenceElement;
import com.sun.xml.ws.rm.v200702.AckRequestedElement;
import com.sun.xml.ws.rm.v200702.SequenceAcknowledgementElement;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public abstract class OutboundSequence
extends Sequence {
    private static final RmLogger LOGGER = RmLogger.getLogger(OutboundSequence.class);
    private int bufferRemaining;
    private String destination;
    private ProcessingFilter filter = null;
    private InboundSequence companionInboundSequence;
    private boolean saveMessages = true;
    private AbstractSequenceAcknowledgement sequenceAcknowledgement;

    protected OutboundSequence(SequenceConfig config) {
        super(config);
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setSequenceAcknowledgement(AbstractSequenceAcknowledgement element) {
        this.sequenceAcknowledgement = element;
    }

    public InboundSequence getInboundSequence() {
        return this.companionInboundSequence;
    }

    protected void setCompanionSequence(InboundSequence companionSequence) {
        this.companionInboundSequence = companionSequence;
    }

    public int getBufferRemaining() {
        return this.bufferRemaining;
    }

    public void setBufferRemaining(int value) {
        this.bufferRemaining = value;
    }

    public void processOutboundMessage(RMMessage outboundMessage) throws InvalidMessageNumberException, BufferFullException, DuplicateMessageException {
        if (this.saveMessages && !outboundMessage.isOneWayResponse()) {
            int messageNumber = outboundMessage.getMessageNumber();
            if (messageNumber == 0) {
                messageNumber = this.set(this.getNextIndex(), outboundMessage);
            } else {
                this.set(messageNumber, outboundMessage);
            }
            AbstractSequence element = null;
            element = this.getConfig().getRMVersion() == RmVersion.WSRM10 ? new SequenceElement() : new com.sun.xml.ws.rm.v200702.SequenceElement();
            element.setNumber(messageNumber);
            element.setId(this.getId());
            outboundMessage.setSequenceElement(element);
            if (this.isAckRequested()) {
                AbstractAckRequested ack = null;
                if (this.getConfig().getRMVersion() == RmVersion.WSRM10) {
                    ack = new com.sun.xml.ws.rm.v200502.AckRequestedElement();
                    ack.setId(this.getId());
                } else {
                    ack = new AckRequestedElement();
                    ack.setId(this.getId());
                }
                outboundMessage.setAckRequestedElement(ack);
            }
        }
        if (this.sequenceAcknowledgement != null) {
            if (this.sequenceAcknowledgement instanceof com.sun.xml.ws.rm.v200502.SequenceAcknowledgementElement) {
                outboundMessage.setSequenceAcknowledgementElement((com.sun.xml.ws.rm.v200502.SequenceAcknowledgementElement)this.sequenceAcknowledgement);
            } else {
                outboundMessage.setSequenceAcknowledgementElement((SequenceAcknowledgementElement)this.sequenceAcknowledgement);
            }
            this.sequenceAcknowledgement = null;
        }
        if (this.filter != null) {
            this.filter.handleOutboundHeaders(outboundMessage);
        }
        if (outboundMessage.getSequenceElement() != null) {
            outboundMessage.addHeader(this.createHeader(outboundMessage.getSequenceElement()));
        }
        if (outboundMessage.getAckRequestedElement() != null) {
            outboundMessage.addHeader(this.createHeader(outboundMessage.getAckRequestedElement()));
        }
        if (outboundMessage.getSequenceAcknowledgementElement() != null) {
            outboundMessage.addHeader(this.createHeader(outboundMessage.getSequenceAcknowledgementElement()));
        }
    }

    public synchronized void processAcknowledgement(RMMessage mess) throws RmException {
        if (this.sequenceAcknowledgement != null) {
            mess.addHeader(this.createHeader(this.sequenceAcknowledgement));
            this.sequenceAcknowledgement = null;
        }
    }

    public synchronized void acknowledge(int messageIndex) throws InvalidMessageNumberException {
        RMMessage rmMessage;
        if (messageIndex >= this.getNextIndex() || null == (rmMessage = this.get(messageIndex))) {
            throw LOGGER.logSevereException(new InvalidMessageNumberException("No RM message stored under index " + messageIndex));
        }
        if (!rmMessage.isComplete()) {
            this.decreaseStoredMessages();
            if (this.getStoredMessages() == 0) {
                this.notifyAll();
            }
            rmMessage.complete();
        }
    }

    public synchronized void waitForAcks() {
        while (this.getStoredMessages() != 0) {
            try {
                long timeout = this.getConfig().getCloseTimeout();
                this.wait(timeout);
                if (this.getStoredMessages() <= 0) continue;
                LOGGER.severe(LocalizationMessages.WSRM_5000_TIMEOUT_IN_WAITFORACKS_STRING(timeout / 1000L, this.getStoredMessages()));
            }
            catch (InterruptedException e) {
                LOGGER.finest("Waiting for acknowledgement interrupted, resuming processing", e);
            }
            break;
        }
    }

    protected boolean isAckRequested() {
        return this.saveMessages;
    }

    public boolean isSaveMessages() {
        return this.saveMessages;
    }

    public void setSaveMessages(boolean value) {
        this.saveMessages = value;
    }

    protected boolean isResendDue() {
        return true;
    }

    public void setProcessingFilter(ProcessingFilter filter) {
        this.filter = filter;
    }

    protected Header createHeader(Object obj) {
        return Headers.create(this.getConfig().getRMVersion().jaxbContext, obj);
    }

    public RMMessage getUnacknowledgedMessage() {
        for (int i = 0; i < this.getNextIndex(); ++i) {
            try {
                RMMessage mess = this.get(i);
                if (mess == null || mess.isComplete()) continue;
                return mess;
            }
            catch (InvalidMessageNumberException e) {
                LOGGER.fine("Attemted to access message with an invalid index [" + i + "]", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAckResponse(AbstractSequenceAcknowledgement element) throws InvalidMessageNumberException {
        OutboundSequence outboundSequence = this;
        synchronized (outboundSequence) {
            List<BigInteger> nacks = null;
            if (this.getConfig().getRMVersion() == RmVersion.WSRM10) {
                this.setBufferRemaining(((com.sun.xml.ws.rm.v200502.SequenceAcknowledgementElement)element).getBufferRemaining());
                nacks = ((com.sun.xml.ws.rm.v200502.SequenceAcknowledgementElement)element).getNack();
            } else {
                this.setBufferRemaining(((SequenceAcknowledgementElement)element).getBufferRemaining());
                nacks = ((SequenceAcknowledgementElement)element).getNack();
            }
            if (nacks != null && !nacks.isEmpty()) {
                ArrayList<Boolean> list = new ArrayList<Boolean>();
                for (int i = 1; i < this.getNextIndex(); ++i) {
                    list.set(i, true);
                }
                for (BigInteger big : nacks) {
                    int index = (int)big.longValue();
                    list.set(index, false);
                }
                for (int i = 1; i < this.getNextIndex(); ++i) {
                    if (!((Boolean)list.get(i)).booleanValue()) continue;
                    this.acknowledgeIfValid(i);
                }
            } else {
                switch (this.getConfig().getRMVersion()) {
                    case WSRM10: {
                        List<SequenceAcknowledgementElement.AcknowledgementRange> ranges = ((com.sun.xml.ws.rm.v200502.SequenceAcknowledgementElement)element).getAcknowledgementRange();
                        for (SequenceAcknowledgementElement.AcknowledgementRange range : ranges) {
                            int lower = range.getLower().intValue();
                            int upper = range.getUpper().intValue();
                            if (this.isLast() && upper == this.getNextIndex()) {
                                --upper;
                            }
                            for (int i = lower; i <= upper; ++i) {
                                this.acknowledgeIfValid(i);
                            }
                        }
                        break;
                    }
                    case WSRM11: {
                        List<SequenceAcknowledgementElement.AcknowledgementRange> ranges = ((SequenceAcknowledgementElement)element).getAcknowledgementRange();
                        for (SequenceAcknowledgementElement.AcknowledgementRange range : ranges) {
                            int lower = range.getLower().intValue();
                            int upper = range.getUpper().intValue();
                            for (int i = lower; i <= upper; ++i) {
                                this.acknowledgeIfValid(i);
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    private void acknowledgeIfValid(int i) {
        try {
            if (this.get(i) != null) {
                this.acknowledge(i);
            }
        }
        catch (InvalidMessageNumberException e) {
            LOGGER.fine(LocalizationMessages.WSRM_4001_ACKNOWLEDGEMENT_MESSAGE(this.getId(), i));
        }
    }
}

