/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.rm.BufferFullException;
import com.sun.xml.ws.rm.CloseSequenceException;
import com.sun.xml.ws.rm.DuplicateMessageException;
import com.sun.xml.ws.rm.InvalidMessageNumberException;
import com.sun.xml.ws.rm.InvalidSequenceException;
import com.sun.xml.ws.rm.MessageNumberRolloverException;
import com.sun.xml.ws.rm.RMMessage;
import com.sun.xml.ws.rm.RmException;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.jaxws.runtime.InboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.OutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.RMProvider;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.protocol.AbstractAckRequested;
import com.sun.xml.ws.rm.protocol.AbstractSequence;
import com.sun.xml.ws.rm.protocol.AbstractSequenceAcknowledgement;
import com.sun.xml.ws.rm.v200502.SequenceElement;
import com.sun.xml.ws.rm.v200702.AckRequestedElement;
import com.sun.xml.ws.rm.v200702.SequenceAcknowledgementElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class InboundMessageProcessor {
    private static final RmLogger LOGGER = RmLogger.getLogger(InboundMessageProcessor.class);

    private InboundMessageProcessor() {
    }

    private static void processAckRequestHeader(Header header, Unmarshaller unmarshaller, RMMessage message, RMProvider provider) throws RmException, InvalidMessageNumberException {
        try {
            AbstractAckRequested el = (AbstractAckRequested)header.readAsJAXB(unmarshaller);
            message.setAckRequestedElement(el);
            String id = null;
            id = el instanceof com.sun.xml.ws.rm.v200502.AckRequestedElement ? ((com.sun.xml.ws.rm.v200502.AckRequestedElement)el).getId() : ((AckRequestedElement)el).getId();
            InboundSequence seq = provider.getInboundSequence(id);
            if (seq != null) {
                seq.handleAckRequested();
            }
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new RmException("Unable to unmarshall AckRequested RM header", e));
        }
    }

    private static void processAckHeader(Header header, Unmarshaller unmarshaller, RMMessage message, RMProvider provider) throws InvalidMessageNumberException, RmException {
        try {
            AbstractSequenceAcknowledgement ackHeader = (AbstractSequenceAcknowledgement)header.readAsJAXB(unmarshaller);
            String ackHeaderId = null;
            ackHeaderId = ackHeader instanceof com.sun.xml.ws.rm.v200502.SequenceAcknowledgementElement ? ((com.sun.xml.ws.rm.v200502.SequenceAcknowledgementElement)ackHeader).getId() : ((SequenceAcknowledgementElement)ackHeader).getId();
            message.setSequenceAcknowledgementElement(ackHeader);
            OutboundSequence seq = provider.getOutboundSequence(ackHeaderId);
            if (seq != null) {
                seq.handleAckResponse(ackHeader);
            }
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new RmException("Unable to unmarshall SequenceAcknowledgement RM header", e));
        }
    }

    private static InboundSequence processSequenceHeader(Header header, Unmarshaller unmarshaller, RMMessage message, RMProvider provider, InboundSequence inseq) throws DuplicateMessageException, InvalidSequenceException, InvalidMessageNumberException, BufferFullException, CloseSequenceException, MessageNumberRolloverException, RmException {
        try {
            long messageNumber;
            AbstractSequence el = (AbstractSequence)header.readAsJAXB(unmarshaller);
            message.setSequenceElement(el);
            String seqid = null;
            if (el instanceof SequenceElement) {
                seqid = ((SequenceElement)el).getId();
                messageNumber = ((SequenceElement)el).getNumber();
            } else {
                seqid = ((com.sun.xml.ws.rm.v200702.SequenceElement)el).getId();
                messageNumber = ((com.sun.xml.ws.rm.v200702.SequenceElement)el).getNumber();
            }
            if (messageNumber == Integer.MAX_VALUE) {
                throw LOGGER.logSevereException(new MessageNumberRolloverException(seqid, messageNumber));
            }
            inseq = provider.getInboundSequence(seqid);
            if (inseq != null) {
                if (inseq.isClosed()) {
                    throw LOGGER.logSevereException(new CloseSequenceException(LocalizationMessages.WSRM_3029_SEQUENCE_CLOSED(seqid), seqid));
                }
            } else {
                throw LOGGER.logSevereException(new InvalidSequenceException(LocalizationMessages.WSRM_3022_UNKNOWN_SEQUENCE_ID_IN_MESSAGE(seqid), seqid));
            }
            inseq.set((int)messageNumber, message);
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new RmException("Unable to unmarshall Sequence RM header", e));
        }
        return inseq;
    }

    public static void processMessage(RMMessage message, Unmarshaller unmarshaller, RMProvider provider, RmVersion rmVersion) throws RmException {
        InboundSequence inseq = null;
        Header header = InboundMessageProcessor.getHeader(message, "Sequence", rmVersion);
        if (header != null) {
            inseq = InboundMessageProcessor.processSequenceHeader(header, unmarshaller, message, provider, inseq);
        }
        if ((header = InboundMessageProcessor.getHeader(message, "SequenceAcknowledgement", rmVersion)) != null) {
            InboundMessageProcessor.processAckHeader(header, unmarshaller, message, provider);
        }
        if ((header = InboundMessageProcessor.getHeader(message, "AckRequested", rmVersion)) != null) {
            InboundMessageProcessor.processAckRequestHeader(header, unmarshaller, message, provider);
        } else if (inseq != null) {
            inseq.handleAckRequested();
        }
    }

    private static Header getHeader(RMMessage message, String name, RmVersion rmVersion) {
        return message.getHeaders() != null ? message.getHeaders().get(rmVersion.namespaceUri, name, true) : null;
    }
}

