/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.common.BulkResponseImpl;
import com.sun.xml.registry.common.util.MarshallerUtil;
import com.sun.xml.registry.uddi.RegistryServiceImpl;
import com.sun.xml.registry.uddi.ResponseTransformer;
import com.sun.xml.registry.uddi.UDDIMapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Processor {
    RegistryServiceImpl service;
    UDDIMapper mapper;
    ResponseTransformer transformer;
    Logger logger = (Logger)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Logger.getLogger("javax.enterprise.resource.webservices.registry.uddi");
        }
    });

    public Processor(RegistryServiceImpl registryServiceImpl, UDDIMapper uDDIMapper) {
        this.service = registryServiceImpl;
        this.mapper = uDDIMapper;
        this.transformer = new ResponseTransformer(uDDIMapper);
    }

    BulkResponse processRequestJAXB(Object object, boolean bl, Collection collection, String string) throws JAXRException {
        SOAPMessage sOAPMessage = null;
        try {
            sOAPMessage = MarshallerUtil.getInstance().jaxbMarshalObject(object);
        }
        catch (JAXBException jAXBException) {
            throw new JAXRException((Throwable)jAXBException);
        }
        return this.processResponseJAXB(this.service.send(sOAPMessage, bl), collection, string);
    }

    BulkResponse processResponseJAXB(Node node, Collection collection, String string) throws JAXRException {
        Object object;
        BulkResponse bulkResponse = null;
        if (node == null) {
            return null;
        }
        Node node2 = null;
        String string2 = node.getNodeName();
        if (((SOAPBody)node).hasFault()) {
            int n;
            if (node instanceof Element && (object = ((Element)node).getElementsByTagName("dispositionReport")) != null && (n = object.getLength()) > 0) {
                for (int i = 0; i < n; ++i) {
                    Node node3 = object.item(i);
                    if (node3 == null) continue;
                    node2 = node3;
                    string2 = "dispositionReport";
                    break;
                }
            }
        } else {
            node2 = node.getFirstChild();
        }
        this.logger.finest("Node name " + string2);
        try {
            object = MarshallerUtil.getInstance().jaxbUnmarshalObject(node2);
            this.logger.finest("Class name " + object.getClass().getName());
            bulkResponse = this.invokeMethod(object, collection, string);
        }
        catch (JAXBException jAXBException) {
            throw new JAXRException((Throwable)jAXBException);
        }
        if (bulkResponse == null) {
            bulkResponse = new BulkResponseImpl();
        }
        return bulkResponse;
    }

    public BulkResponse invokeMethod(Object object, Collection collection, String string) throws JAXRException {
        return this.transformer.transformResponse(object, collection, string);
    }

    public BulkResponse invoke(Object object, Collection collection, String string) throws InvocationTargetException, IllegalAccessException, JAXRException {
        Object[] objectArray = new Object[]{object, collection, string};
        Class[] classArray = new Class[]{objectArray[0].getClass(), Collection.class, String.class};
        try {
            Class<UDDIMapper> clazz = UDDIMapper.class;
            Method method = clazz.getMethod("transformResponse", classArray);
            return (BulkResponse)method.invoke((Object)this.mapper, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exception exception = (Exception)invocationTargetException.getTargetException();
            throw new JAXRException((Throwable)exception);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvocationTargetException(noSuchMethodException, ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Can't_find_method_"));
        }
    }
}

