/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.policy.verifier;

import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.PolicyViolationException;
import com.sun.xml.wss.impl.policy.PolicyAlternatives;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.impl.policy.spi.PolicyVerifier;
import com.sun.xml.wss.impl.policy.verifier.PolicyVerifierFactory;
import com.sun.xml.wss.impl.policy.verifier.TargetResolver;
import java.util.List;
import java.util.logging.Logger;

public class PolicyAlternativesVerifier
implements PolicyVerifier {
    private ProcessingContext ctx = null;
    private TargetResolver targetResolver;
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public PolicyAlternativesVerifier(ProcessingContext ctx, TargetResolver targetResolver) {
        this.ctx = ctx;
        this.targetResolver = targetResolver;
    }

    public void verifyPolicy(SecurityPolicy recvdPolicy, SecurityPolicy configPolicy) throws PolicyViolationException {
        PolicyAlternatives confPolicies = (PolicyAlternatives)configPolicy;
        List<MessagePolicy> mps = confPolicies.getSecurityPolicy();
        if (mps.size() == 1) {
            PolicyVerifier verifier = PolicyVerifierFactory.createVerifier(mps.get(0), this.ctx);
            verifier.verifyPolicy(recvdPolicy, mps.get(0));
            if (mps.get(0).getPolicyAlternativeId() != null) {
                this.ctx.getExtraneousProperties().put("policy-alternative-id", mps.get(0).getPolicyAlternativeId());
            }
            return;
        }
        DefaultAlternativeSelector selector = new DefaultAlternativeSelector();
        MessagePolicy toVerify = selector.selectAlternative(this.ctx, mps, recvdPolicy);
        if (toVerify != null) {
            PolicyVerifier verifier = PolicyVerifierFactory.createVerifier(toVerify, this.ctx);
            verifier.verifyPolicy(recvdPolicy, toVerify);
            if (toVerify.getPolicyAlternativeId() != null) {
                this.ctx.getExtraneousProperties().put("policy-alternative-id", toVerify.getPolicyAlternativeId());
            }
            return;
        }
        throw new UnsupportedOperationException("Cannot verify the request against the configured PolicyAlternatives in the WebService");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UsernameOrSAMLAlternativeSelector
    implements AlternativeSelector {
        private UsernameOrSAMLAlternativeSelector() {
        }

        @Override
        public MessagePolicy selectAlternative(ProcessingContext ctx, List<MessagePolicy> alternatives, SecurityPolicy recvdPolicy) {
            SupportingTokenType reqMsgTokenType = this.determineTokenType(recvdPolicy);
            for (MessagePolicy mp : alternatives) {
                SupportingTokenType alternativeTokenType = this.determineTokenType(mp);
                if (reqMsgTokenType == SupportingTokenType.UNKNOWN || !reqMsgTokenType.equals((Object)alternativeTokenType)) continue;
                return mp;
            }
            return null;
        }

        private SupportingTokenType determineTokenType(SecurityPolicy recvdPolicy) {
            SupportingTokenType ret = SupportingTokenType.UNKNOWN;
            if (recvdPolicy instanceof MessagePolicy) {
                MessagePolicy pol = (MessagePolicy)recvdPolicy;
                for (int i = 0; i < pol.size(); ++i) {
                    try {
                        WSSPolicy p = (WSSPolicy)pol.get(i);
                        if (PolicyTypeUtil.usernameTokenBinding(p) || PolicyTypeUtil.usernameTokenBinding(p.getFeatureBinding())) {
                            ret = SupportingTokenType.USERNAME;
                            break;
                        }
                        if (!PolicyTypeUtil.samlTokenPolicy(p) && !PolicyTypeUtil.samlTokenPolicy(p.getFeatureBinding())) continue;
                        ret = SupportingTokenType.SAML;
                        break;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            return ret;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum SupportingTokenType {
            USERNAME,
            SAML,
            UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultAlternativeSelector
    implements AlternativeSelector {
        private DefaultAlternativeSelector() {
        }

        @Override
        public MessagePolicy selectAlternative(ProcessingContext ctx, List<MessagePolicy> alternatives, SecurityPolicy recvdPolicy) {
            MessagePolicy selected = null;
            if (alternatives.size() == 2) {
                selected = new UsernameOrSAMLAlternativeSelector().selectAlternative(ctx, alternatives, recvdPolicy);
            }
            if (selected != null) {
                return selected;
            }
            throw new UnsupportedOperationException("Cannot verify the request against the configured PolicyAlternatives in the WebService");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface AlternativeSelector {
        public MessagePolicy selectAlternative(ProcessingContext var1, List<MessagePolicy> var2, SecurityPolicy var3);
    }
}

