/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.internal;

import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.WSATXAResource;
import com.sun.xml.ws.tx.at.common.TransactionManagerImpl;
import com.sun.xml.ws.tx.at.internal.BranchRecord;
import com.sun.xml.ws.tx.at.internal.JTAHelper;
import com.sun.xml.ws.tx.at.internal.WSATNoOpXAResource;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class WSATGatewayRM
implements XAResource {
    private static WSATGatewayRM singleton;
    private String resourceRegistrationName;
    private Map<Xid, BranchRecord> branches;
    private List<Xid> pendingXids;
    private final Object currentXidLock = new Object();
    private byte[] currentBQual;
    private Xid currentXid;
    private static TransactionManager m_transactionManager;
    private static Transaction m_transaction;

    private WSATGatewayRM() {
    }

    private WSATGatewayRM(String serverName) {
        this.resourceRegistrationName = "RM_NAME_PREFIX" + serverName;
        this.branches = Collections.synchronizedMap(new HashMap());
        this.pendingXids = Collections.synchronizedList(new ArrayList());
    }

    public static synchronized WSATGatewayRM getInstance() {
        return singleton;
    }

    public static synchronized WSATGatewayRM create(String serverName) {
        if (singleton == null) {
            singleton = new WSATGatewayRM(serverName);
            singleton.initStore();
            singleton.recoverPendingBranches();
            singleton.registerResourceWithTM();
        }
        return singleton;
    }

    private void initStore() {
    }

    private void recoverPendingBranches() {
    }

    private void registerResourceWithTM() {
    }

    public void stop() {
        try {
            this.unregisterResource();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
    }

    private void unregisterResource() throws SystemException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid registerWSATResource(Xid xidd, XAResource wsatResource, Transaction tx) throws IllegalStateException, RollbackException, SystemException {
        if (tx == null) {
            throw new IllegalStateException("Transaction " + tx + " does not exist, wsatResource=" + wsatResource);
        }
        Object object = this.currentXidLock;
        synchronized (object) {
            tx.enlistResource((XAResource)this);
            byte[] bqual = this.currentBQual;
            this.currentBQual = null;
            ((WSATXAResource)wsatResource).setXid(this.currentXid);
            BranchRecord branch = this.getOrCreateBranch(this.currentXid);
            branch.addSubordinate(this.currentXid, wsatResource);
            tx.enlistResource((XAResource)new WSATNoOpXAResource());
            if (WSATHelper.isDebugEnabled()) {
                this.debug("registerWSATResource() xid=" + this.currentXid + " currentBQual=" + String.valueOf(this.currentBQual) + " bqual=" + String.valueOf(bqual));
            }
        }
        return this.currentXid;
    }

    public void start(Xid xid, int flags) throws XAException {
        this.currentXid = xid;
        this.debug("start currentXid:" + this.currentXid);
        this.debug("start xid:" + xid);
        this.debug("start currentXid bqual:" + this.currentXid.getBranchQualifier());
        this.debug("start currentXid formatid:" + this.currentXid.getFormatId());
        this.debug("start currentXid gtrid:" + this.currentXid.getGlobalTransactionId());
        this.currentBQual = this.currentXid.getBranchQualifier();
        if (WSATHelper.isDebugEnabled()) {
            this.debug("start() xid=" + xid + ", flags=" + flags + ", currentBQual=" + String.valueOf(this.currentBQual));
        }
        switch (flags) {
            case 0: {
                this.getOrCreateBranch(xid);
                break;
            }
            case 0x200000: 
            case 0x8000000: {
                BranchRecord branch = this.getBranch(xid);
                if (branch != null) break;
                JTAHelper.throwXAException(-4, "Attempt to resume xid " + xid + " that is not in SUSPENDED state.");
                break;
            }
            case 0x20000000: {
                JTAHelper.throwXAException(-3, "error while attempting to rollback branch" + this.resourceRegistrationName);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid flag:" + flags);
            }
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        BranchRecord branch;
        if (WSATHelper.isDebugEnabled()) {
            this.debug("end() xid=" + xid + ", flags=" + flags);
        }
        if ((branch = this.getBranch(xid)) == null) {
            JTAHelper.throwXAException(-4, "end: no branch info for " + xid);
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("prepare() xid=" + xid);
        }
        BranchRecord branch = this.getBranch(xid);
        if (WSATHelper.isDebugEnabled()) {
            this.debug("prepare() xid=" + xid + " branch=" + branch);
        }
        if (branch == null) {
            JTAHelper.throwXAException(-4, "prepare: no branch info for " + xid);
        }
        if (WSATHelper.isDebugEnabled()) {
            this.debug("prepare() xid=" + xid);
        }
        this.persistBranchIfNecessary(branch);
        return branch.prepare(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        BranchRecord branch;
        if (WSATHelper.isDebugEnabled()) {
            this.debug("commit() xid=" + xid);
        }
        if ((branch = this.getBranch(xid)) == null) {
            JTAHelper.throwXAException(-4, "commit: no branch information for xid:" + xid);
        }
        try {
            branch.commit(xid, onePhase);
        }
        finally {
            this.deleteBranchIfNecessary(branch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        BranchRecord branch;
        if (WSATHelper.isDebugEnabled()) {
            this.debug("rollback() xid=" + xid);
        }
        if ((branch = this.getBranch(xid)) == null) {
            JTAHelper.throwXAException(-4, "rollback: no branch info for " + xid);
        }
        try {
            branch.rollback(xid);
        }
        finally {
            this.deleteBranchIfNecessary(branch);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("recover() flag=" + flag);
        }
        if ((flag & 0x1000000) != 0) {
            if (WSATHelper.isDebugEnabled()) {
                this.debug("WSAT recover(" + flag + ") returning " + this.pendingXids);
            }
            Xid[] xids = this.pendingXids.toArray(new Xid[this.pendingXids.size()]);
            return xids;
        }
        if (WSATHelper.isDebugEnabled()) {
            this.debug("recover() returning nothing");
        }
        return new Xid[0];
    }

    public void forget(Xid xid) throws XAException {
        BranchRecord branch;
        if (WSATHelper.isDebugEnabled()) {
            this.debug("forget() xid=" + xid);
        }
        if ((branch = this.getBranch(xid)) == null) {
            JTAHelper.throwXAException(-4, "forget: no branch info for " + xid);
        }
        this.deleteBranchIfNecessary(branch);
    }

    public int getTransactionTimeout() throws XAException {
        return -1;
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (!(xares instanceof WSATGatewayRM)) {
            return false;
        }
        WSATGatewayRM oxares = (WSATGatewayRM)xares;
        return this.equals(oxares);
    }

    public boolean detectedUnavailable() {
        return true;
    }

    public int getDelistFlag() {
        return 0x4000000;
    }

    private synchronized BranchRecord getOrCreateBranch(Xid xid) {
        BranchRecord branch = this.getBranch(xid);
        if (branch == null) {
            branch = new BranchRecord(xid);
            this.branches.put(xid, branch);
        }
        return branch;
    }

    private synchronized BranchRecord getBranch(Xid xid) {
        BranchRecord branch = this.branches.get(xid);
        if (branch != null && xid.getBranchQualifier() != null) {
            branch.assignBranchXid(xid);
        }
        return branch;
    }

    private void delete(BranchRecord branch) {
        this.releaseBranchRecord(branch);
        this.branches.remove(branch.getXid());
        this.pendingXids.removeAll(branch.getAllXids());
        branch.cleanup();
    }

    private void persistBranchRecord(BranchRecord branch) {
    }

    private void releaseBranchRecord(BranchRecord branch) {
    }

    private void persistBranchIfNecessary(BranchRecord branch) throws XAException {
    }

    private boolean deleteBranchIfNecessary(BranchRecord branch) throws XAException {
        return true;
    }

    private TransactionManager getTM() {
        return TransactionManagerImpl.getInstance();
    }

    private Transaction getTransaction(Xid xid) {
        if (m_transaction != null) {
            return m_transaction;
        }
        try {
            return TransactionManagerImpl.getInstance().getTransaction();
        }
        catch (SystemException ex) {
            Logger.getLogger(WSATGatewayRM.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    static void setTM(TransactionManager transactionManager) {
        m_transactionManager = transactionManager;
    }

    static void setTx(Transaction transaction) {
        m_transaction = transaction;
    }

    private void debug(String msg) {
    }

    static {
        WSATGatewayRM.create("server");
    }

    private final class BranchObjectHandler {
        private static final int VERSION = 1;

        private BranchObjectHandler() {
        }

        public Object readObject(ObjectInput in) throws ClassNotFoundException, IOException {
            int version = in.readInt();
            if (version != 1) {
                throw new IOException("Stream corrupted.  Invalid WS-AT gateway branch version: " + version);
            }
            BranchRecord branch = new BranchRecord();
            branch.readExternal(in);
            if (WSATHelper.isDebugEnabled()) {
                WSATGatewayRM.this.debug("read WS-AT branch " + branch);
            }
            return branch;
        }

        public void writeObject(ObjectOutput out, Object o) throws IOException {
            if (!(o instanceof BranchRecord)) {
                throw new IOException("Cannot serialize class of type: " + (o == null ? null : o.getClass().toString()));
            }
            out.writeInt(1);
            BranchRecord branch = (BranchRecord)o;
            branch.writeExternal(out);
            if (WSATHelper.isDebugEnabled()) {
                WSATGatewayRM.this.debug("serialized WS-AT branch " + branch);
            }
        }
    }
}

