/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.HttpsToken;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policy.Token;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import java.util.Collection;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportToken
extends Token
implements com.sun.xml.ws.security.policy.TransportToken,
SecurityAssertionValidator {
    private String id;
    private HttpsToken token = null;
    private boolean populated;
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private QName itQname;
    private String includeToken;

    public TransportToken() {
        this.id = PolicyUtil.randomUUID();
        this.itQname = new QName(this.getSecurityPolicyVersion().namespaceUri, "IncludeToken");
        this.includeToken = "";
    }

    public TransportToken(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        this.id = PolicyUtil.randomUUID();
        this.itQname = new QName(this.getSecurityPolicyVersion().namespaceUri, "IncludeToken");
    }

    @Override
    public String getTokenId() {
        return this.id;
    }

    @Override
    public String getIncludeToken() {
        throw new UnsupportedOperationException("This method is not supported for TransportToken");
    }

    @Override
    public void setIncludeToken(String type) {
        throw new UnsupportedOperationException("This method is not supported for TransportToken");
    }

    @Override
    public com.sun.xml.ws.security.policy.HttpsToken getHttpsToken() {
        this.populate();
        return this.token;
    }

    public void setHttpsToken(com.sun.xml.ws.security.policy.HttpsToken token) {
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            this.includeToken = this.getAttributeValue(this.itQname);
            NestedPolicy policy = this.getNestedPolicy();
            AssertionSet assertionSet = policy.getAssertionSet();
            for (PolicyAssertion assertion : assertionSet) {
                if (PolicyUtil.isHttpsToken(assertion, this.getSecurityPolicyVersion())) {
                    this.token = (HttpsToken)assertion;
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "TransportToken");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            this.populated = true;
        }
        return this.fitness;
    }
}

