/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.writer.ProgressCodeWriter;
import com.sun.istack.tools.ParallelWorldClassLoader;
import com.sun.tools.ws.ToolVersion;
import com.sun.tools.ws.api.TJavaGeneratorExtension;
import com.sun.tools.ws.processor.generator.CustomExceptionGenerator;
import com.sun.tools.ws.processor.generator.SeiGenerator;
import com.sun.tools.ws.processor.generator.ServiceGenerator;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.modeler.wsdl.ConsoleErrorReporter;
import com.sun.tools.ws.processor.modeler.wsdl.WSDLModeler;
import com.sun.tools.ws.processor.util.DirectoryUtil;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.resources.WsdlMessages;
import com.sun.tools.ws.util.WSDLFetcher;
import com.sun.tools.ws.wscompile.AbortException;
import com.sun.tools.ws.wscompile.BadCommandLineException;
import com.sun.tools.ws.wscompile.DefaultAuthenticator;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.ErrorReceiverFilter;
import com.sun.tools.ws.wscompile.JavaCompilerHelper;
import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.ws.wscompile.WSCodeWriter;
import com.sun.tools.ws.wscompile.WsimportListener;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.tools.ws.wsdl.parser.MetadataFinder;
import com.sun.tools.ws.wsdl.parser.WSDLInternalizationLogic;
import com.sun.tools.xjc.util.NullStream;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.util.ServiceFinder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.xml.bind.JAXBPermission;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.EndpointContext;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXParseException;

public class WsimportTool {
    private static final String WSIMPORT = "wsimport";
    private final PrintStream out;
    private final Container container;
    private final WsimportOptions options = new WsimportOptions();

    public WsimportTool(OutputStream out) {
        this(out, null);
    }

    public WsimportTool(OutputStream logStream, Container container) {
        this.out = logStream instanceof PrintStream ? (PrintStream)logStream : new PrintStream(logStream);
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(String[] args) {
        class Listener
        extends WsimportListener {
            ConsoleErrorReporter cer;

            Listener() {
                this.cer = new ConsoleErrorReporter(WsimportTool.this.out == null ? new PrintStream((OutputStream)new NullStream()) : WsimportTool.this.out);
            }

            public void generatedFile(String fileName) {
                this.message(fileName);
            }

            public void message(String msg) {
                WsimportTool.this.out.println(msg);
            }

            public void error(SAXParseException exception) {
                this.cer.error(exception);
            }

            public void fatalError(SAXParseException exception) {
                this.cer.fatalError(exception);
            }

            public void warning(SAXParseException exception) {
                this.cer.warning(exception);
            }

            public void debug(SAXParseException exception) {
                this.cer.debug(exception);
            }

            public void info(SAXParseException exception) {
                this.cer.info(exception);
            }

            public void enableDebugging() {
                this.cer.enableDebugging();
            }
        }
        final Listener listener = new Listener();
        ErrorReceiverFilter receiver = new ErrorReceiverFilter(listener){
            {
                super(x0);
            }

            public void info(SAXParseException exception) {
                if (((WsimportTool)WsimportTool.this).options.verbose) {
                    super.info(exception);
                }
            }

            public void warning(SAXParseException exception) {
                if (!((WsimportTool)WsimportTool.this).options.quiet) {
                    super.warning(exception);
                }
            }

            public void pollAbort() throws AbortException {
                if (listener.isCanceled()) {
                    throw new AbortException();
                }
            }

            public void debug(SAXParseException exception) {
                if (((WsimportTool)WsimportTool.this).options.debugMode) {
                    listener.debug(exception);
                }
            }
        };
        for (String arg : args) {
            if (!arg.equals("-version")) continue;
            listener.message(ToolVersion.VERSION.BUILD_VERSION);
            return true;
        }
        try {
            Model wsdlModel;
            MetadataFinder forest;
            block28: {
                WSDLModeler wsdlModeler;
                this.options.parseArguments(args);
                this.options.validate();
                if (this.options.debugMode) {
                    listener.enableDebugging();
                }
                this.options.parseBindings(receiver);
                if (!this.options.quiet) {
                    listener.message(WscompileMessages.WSIMPORT_PARSING_WSDL());
                }
                Authenticator.setDefault(new DefaultAuthenticator(receiver, this.options.authFile));
                forest = new MetadataFinder(new WSDLInternalizationLogic(), this.options, receiver);
                forest.parseWSDL();
                if (forest.isMexMetadata) {
                    receiver.reset();
                }
                if ((wsdlModel = (wsdlModeler = new WSDLModeler(this.options, receiver, forest)).buildModel()) != null) break block28;
                listener.message(WsdlMessages.PARSING_PARSE_FAILED());
                boolean arg = false;
                return arg;
            }
            try {
                if (this.options.clientjar != null) {
                    if (!this.options.quiet) {
                        listener.message(WscompileMessages.WSIMPORT_FETCHING_METADATA());
                    }
                    this.options.wsdlLocation = new WSDLFetcher(this.options, listener).fetchWsdls(forest);
                }
                if (!this.options.quiet) {
                    listener.message(WscompileMessages.WSIMPORT_GENERATING_CODE());
                }
                TJavaGeneratorExtension[] genExtn = ServiceFinder.find(TJavaGeneratorExtension.class).toArray();
                CustomExceptionGenerator.generate(wsdlModel, this.options, receiver);
                SeiGenerator.generate(wsdlModel, this.options, receiver, genExtn);
                if (receiver.hadError()) {
                    throw new AbortException();
                }
                ServiceGenerator.generate(wsdlModel, this.options, receiver);
                WSCodeWriter cw = new WSCodeWriter(this.options.sourceDir, this.options);
                if (this.options.verbose) {
                    cw = new ProgressCodeWriter((CodeWriter)cw, this.out);
                }
                this.options.getCodeModel().build((CodeWriter)cw);
            }
            catch (AbortException e) {
            }
            catch (IOException e) {
                receiver.error(e);
            }
            catch (XMLStreamException e) {
                receiver.error(e);
            }
            if (!this.options.nocompile && !this.compileGeneratedClasses(receiver, listener)) {
                listener.message(WscompileMessages.WSCOMPILE_COMPILATION_FAILED());
                boolean e = false;
                return e;
            }
            try {
                if (this.options.clientjar != null) {
                    this.addClassesToGeneratedFiles();
                    this.jarArtifacts(listener);
                }
            }
            catch (IOException e) {
                receiver.error(e);
            }
        }
        catch (Options.WeAreDone done) {
            this.usage(done.getOptions());
        }
        catch (BadCommandLineException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
                System.out.println();
            }
            this.usage(e.getOptions());
            boolean bl = false;
            return bl;
        }
        finally {
            this.deleteGeneratedFiles();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteGeneratedFiles() {
        HashSet<File> trackedRootPackages = new HashSet<File>();
        if (this.options.clientjar != null) {
            Iterable<File> generatedFiles;
            Iterable<File> iterable = generatedFiles = this.options.getGeneratedFiles();
            synchronized (iterable) {
                for (File file : generatedFiles) {
                    if (file.getName().endsWith(".java")) continue;
                    file.delete();
                    trackedRootPackages.add(file.getParentFile());
                }
            }
            for (File pkg : trackedRootPackages) {
                while (pkg.list() != null && pkg.list().length == 0 && !pkg.equals(this.options.destDir)) {
                    File parentPkg = pkg.getParentFile();
                    pkg.delete();
                    pkg = parentPkg;
                }
            }
        }
        if (!this.options.keep) {
            this.options.removeGeneratedFiles();
        }
    }

    private void addClassesToGeneratedFiles() throws IOException {
        Iterable<File> generatedFiles = this.options.getGeneratedFiles();
        final ArrayList trackedClassFiles = new ArrayList();
        for (File f : generatedFiles) {
            if (!f.getName().endsWith(".java")) continue;
            String relativeDir = DirectoryUtil.getRelativePathfromCommonBase(f.getParentFile(), this.options.sourceDir);
            final String className = f.getName().substring(0, f.getName().indexOf(".java"));
            File classDir = new File(this.options.destDir, relativeDir);
            if (!classDir.exists()) continue;
            classDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    if (name.equals(className + ".class") || name.startsWith(className + "$") && name.endsWith(".class")) {
                        trackedClassFiles.add(new File(dir, name));
                        return true;
                    }
                    return false;
                }
            });
        }
        for (File f : trackedClassFiles) {
            this.options.addGeneratedFile(f);
        }
    }

    private void jarArtifacts(WsimportListener listener) throws IOException {
        File zipFile = new File(this.options.clientjar);
        if (!zipFile.isAbsolute()) {
            zipFile = new File(this.options.destDir, this.options.clientjar);
        }
        if (zipFile.exists()) {
            // empty if block
        }
        FileOutputStream fos = null;
        if (!this.options.quiet) {
            listener.message(WscompileMessages.WSIMPORT_ARCHIVING_ARTIFACTS(zipFile));
        }
        fos = new FileOutputStream(zipFile);
        JarOutputStream jos = new JarOutputStream(fos);
        String base = this.options.destDir.getCanonicalPath();
        for (File f : this.options.getGeneratedFiles()) {
            int bytesRead;
            if (f.getName().endsWith(".java")) continue;
            if (this.options.verbose) {
                listener.message(WscompileMessages.WSIMPORT_ARCHIVE_ARTIFACT(f, this.options.clientjar));
            }
            String entry = f.getCanonicalPath().substring(base.length() + 1);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
            JarEntry jarEntry = new JarEntry(entry);
            jos.putNextEntry(jarEntry);
            byte[] buffer = new byte[1024];
            while ((bytesRead = bis.read(buffer)) != -1) {
                jos.write(buffer, 0, bytesRead);
            }
            bis.close();
        }
        jos.close();
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.options.entityResolver = resolver;
    }

    private static boolean useBootClasspath(Class clazz) {
        try {
            ParallelWorldClassLoader.toJarUrl((URL)clazz.getResource('/' + clazz.getName().replace('.', '/') + ".class"));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean compileGeneratedClasses(ErrorReceiver receiver, WsimportListener listener) {
        ArrayList<String> sourceFiles = new ArrayList<String>();
        for (File f : this.options.getGeneratedFiles()) {
            if (!f.exists() || !f.getName().endsWith(".java")) continue;
            sourceFiles.add(f.getAbsolutePath());
        }
        if (sourceFiles.size() > 0) {
            String classDir = this.options.destDir.getAbsolutePath();
            String classpathString = this.createClasspathString();
            boolean bootCP = WsimportTool.useBootClasspath(EndpointContext.class) || WsimportTool.useBootClasspath(JAXBPermission.class);
            String[] args = new String[4 + (bootCP ? 1 : 0) + (this.options.debug ? 1 : 0) + sourceFiles.size()];
            args[0] = "-d";
            args[1] = classDir;
            args[2] = "-classpath";
            args[3] = classpathString;
            int baseIndex = 4;
            if (bootCP) {
                args[baseIndex++] = "-Xbootclasspath/p:" + JavaCompilerHelper.getJarFile(EndpointContext.class) + File.pathSeparator + JavaCompilerHelper.getJarFile(JAXBPermission.class);
            }
            if (this.options.debug) {
                args[baseIndex++] = "-g";
            }
            for (int i = 0; i < sourceFiles.size(); ++i) {
                args[baseIndex + i] = (String)sourceFiles.get(i);
            }
            listener.message(WscompileMessages.WSIMPORT_COMPILING_CODE());
            if (this.options.verbose) {
                StringBuffer argstr = new StringBuffer();
                for (String arg : args) {
                    argstr.append(arg).append(" ");
                }
                listener.message("javac " + argstr.toString());
            }
            return JavaCompilerHelper.compile(args, this.out, receiver);
        }
        return true;
    }

    private String createClasspathString() {
        String classpathStr = System.getProperty("java.class.path");
        for (String s : this.options.cmdlineJars) {
            classpathStr = classpathStr + File.pathSeparator + new File(s);
        }
        return classpathStr;
    }

    protected void usage(Options options) {
        System.out.println(WscompileMessages.WSIMPORT_HELP(WSIMPORT));
        System.out.println(WscompileMessages.WSIMPORT_USAGE_EXTENSIONS());
        System.out.println(WscompileMessages.WSIMPORT_USAGE_EXAMPLES());
    }
}

