/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.istack.NotNull;
import com.sun.xml.ws.server.DummyWebServiceFeature;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.ws.WebServiceFeature;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.GmbalMBean;
import org.glassfish.gmbal.InheritedAttributes;
import org.glassfish.gmbal.ManagedData;
import org.glassfish.gmbal.ManagedObjectManager;
import org.glassfish.gmbal.ManagedObjectManagerFactory;

public abstract class MonitorBase {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.monitoring");
    private static final String amxRootName = "amx:pp=/mon,type=server-mon,name=server";
    private static final String standaloneName = "com.sun.metro";
    private static boolean clientMonitoring = false;
    private static boolean endpointMonitoring = true;
    private static int typelibDebug = -1;
    private static String registrationDebug = "NONE";
    private static boolean runtimeDebug = false;
    private static int maxUniqueEndpointRootNameRetries = 100;
    private static final String monitorProperty = "com.sun.xml.ws.monitoring.";

    @NotNull
    public ManagedObjectManager createManagedObjectManager(boolean isEndpoint, String rootName) {
        String msg = " monitoring disabled. " + rootName + " will not be monitored";
        if (isEndpoint && !endpointMonitoring) {
            logger.log(Level.CONFIG, "Endpoint" + msg);
            return ManagedObjectManagerFactory.createNOOP();
        }
        if (!isEndpoint && !clientMonitoring) {
            logger.log(Level.CONFIG, "Client" + msg);
            return ManagedObjectManagerFactory.createNOOP();
        }
        return this.createMOMLoop(rootName, 0);
    }

    @NotNull
    private ManagedObjectManager createMOMLoop(String rootName, int unique) {
        ManagedObjectManager mom = this.createMOM(this.isFederated());
        mom = this.initMOM(mom);
        mom = this.createRoot(mom, rootName, unique);
        return mom;
    }

    private ObjectName isFederated() {
        try {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName amxRoot = new ObjectName(amxRootName);
            return mbeanServer.isRegistered(amxRoot) ? amxRoot : null;
        }
        catch (Throwable t) {
            logger.log(Level.CONFIG, "GlassFish AMX monitoring root not available.  Trying standalone.", t);
            return null;
        }
    }

    @NotNull
    private ManagedObjectManager createMOM(ObjectName amxRoot) {
        boolean isFederated = amxRoot != null;
        try {
            return isFederated ? ManagedObjectManagerFactory.createFederated((ObjectName)amxRoot) : ManagedObjectManagerFactory.createStandalone((String)standaloneName);
        }
        catch (Throwable t) {
            if (isFederated) {
                logger.log(Level.CONFIG, "Problem while attempting to federate with GlassFish AMX monitoring.  Trying standalone.", t);
                return this.createMOM(null);
            }
            logger.log(Level.WARNING, "Ignoring exception - starting up without monitoring", t);
            return ManagedObjectManagerFactory.createNOOP();
        }
    }

    @NotNull
    private ManagedObjectManager initMOM(ManagedObjectManager mom) {
        try {
            if (typelibDebug != -1) {
                mom.setTypelibDebug(typelibDebug);
            }
            if (registrationDebug.equals("FINE")) {
                mom.setRegistrationDebug(ManagedObjectManager.RegistrationDebugLevel.FINE);
            } else if (registrationDebug.equals("NORMAL")) {
                mom.setRegistrationDebug(ManagedObjectManager.RegistrationDebugLevel.NORMAL);
            } else {
                mom.setRegistrationDebug(ManagedObjectManager.RegistrationDebugLevel.NONE);
            }
            mom.setRuntimeDebug(runtimeDebug);
            mom.suppressDuplicateRootReport(true);
            mom.stripPrefix(new String[]{"com.sun.xml.ws.server", "com.sun.xml.ws.rx.rm.runtime.sequence"});
            mom.addAnnotation(WebServiceFeature.class, (Annotation)DummyWebServiceFeature.class.getAnnotation(ManagedData.class));
            mom.addAnnotation(WebServiceFeature.class, (Annotation)DummyWebServiceFeature.class.getAnnotation(Description.class));
            mom.addAnnotation(WebServiceFeature.class, (Annotation)DummyWebServiceFeature.class.getAnnotation(InheritedAttributes.class));
            mom.suspendJMXRegistration();
        }
        catch (Throwable t) {
            try {
                mom.close();
            }
            catch (IOException e) {
                logger.log(Level.CONFIG, "Ignoring exception caught when closing unused ManagedObjectManager", e);
            }
            logger.log(Level.WARNING, "Ignoring exception - starting up without monitoring", t);
            return ManagedObjectManagerFactory.createNOOP();
        }
        return mom;
    }

    private ManagedObjectManager createRoot(ManagedObjectManager mom, String rootName, int unique) {
        String name = rootName + (unique == 0 ? "" : "-" + String.valueOf(unique));
        try {
            GmbalMBean ignored = mom.createRoot((Object)this, name);
            if (ignored != null) {
                logger.log(Level.INFO, "Monitoring rootname successfully set to: " + name);
                return mom;
            }
            try {
                mom.close();
            }
            catch (IOException e) {
                logger.log(Level.CONFIG, "Ignoring exception caught when closing unused ManagedObjectManager", e);
            }
            String basemsg = "duplicate monitoring rootname: " + name + " : ";
            if (unique > maxUniqueEndpointRootNameRetries) {
                String msg = basemsg + "Giving up.";
                logger.log(Level.INFO, msg);
                return ManagedObjectManagerFactory.createNOOP();
            }
            String msg = basemsg + "Will try to make unique";
            logger.log(Level.CONFIG, msg);
            return this.createMOMLoop(rootName, ++unique);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Error while creating monitoring root with name: " + rootName, t);
            return ManagedObjectManagerFactory.createNOOP();
        }
    }

    static {
        try {
            Integer i;
            String s = System.getProperty("com.sun.xml.ws.monitoring.endpoint");
            if (s != null && s.toLowerCase().equals("false")) {
                endpointMonitoring = false;
            }
            if ((s = System.getProperty("com.sun.xml.ws.monitoring.client")) != null && s.toLowerCase().equals("true")) {
                clientMonitoring = true;
            }
            if ((i = Integer.getInteger("com.sun.xml.ws.monitoring.typelibDebug")) != null) {
                typelibDebug = i;
            }
            if ((s = System.getProperty("com.sun.xml.ws.monitoring.registrationDebug")) != null) {
                registrationDebug = s.toUpperCase();
            }
            if ((s = System.getProperty("com.sun.xml.ws.monitoring.runtimeDebug")) != null && s.toLowerCase().equals("true")) {
                runtimeDebug = true;
            }
            if ((i = Integer.getInteger("com.sun.xml.ws.monitoring.maxUniqueEndpointRootNameRetries")) != null) {
                maxUniqueEndpointRootNameRetries = i;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while reading monitoring properties", e);
        }
    }
}

