/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.invm;

import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.sequence.AbstractSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.InboundSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.OutboundSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.invm.InVmSequenceData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.gmbal.ManagedObjectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InVmSequenceManager
implements SequenceManager {
    private final ReadWriteLock internalDataAccessLock = new ReentrantReadWriteLock();
    private final Map<String, AbstractSequence> sequences = new HashMap<String, AbstractSequence>();
    private final Map<String, String> boundSequences = new HashMap<String, String>();
    private final ManagedObjectManager managedObjectManager;
    private final DeliveryQueueBuilder inboundQueueBuilder;
    private final DeliveryQueueBuilder outboundQueueBuilder;
    private final String uniqueEndpointId;

    public InVmSequenceManager(String uniqueEndpointId, DeliveryQueueBuilder inboundQueueBuilder, DeliveryQueueBuilder outboundQueueBuilder, ManagedObjectManager managedObjectManager) {
        this.managedObjectManager = managedObjectManager;
        if (this.managedObjectManager != null) {
            this.managedObjectManager.registerAtRoot((Object)this, "RMSequenceManager");
        }
        this.uniqueEndpointId = uniqueEndpointId;
        this.inboundQueueBuilder = inboundQueueBuilder;
        this.outboundQueueBuilder = outboundQueueBuilder;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public String uniqueEndpointId() {
        return this.uniqueEndpointId;
    }

    @Override
    public Map<String, ? extends Sequence> sequences() {
        return this.sequences;
    }

    @Override
    public Map<String, String> boundSequences() {
        return this.boundSequences;
    }

    @Override
    public Sequence createOutboundSequence(String sequenceId, String strId, long expirationTime) throws DuplicateSequenceException {
        InVmSequenceData data = new InVmSequenceData(sequenceId, strId, expirationTime, 0L, this.currentTimeInMillis());
        return this.registerSequence(new OutboundSequence(data, this.outboundQueueBuilder, this));
    }

    @Override
    public Sequence createInboundSequence(String sequenceId, String strId, long expirationTime) throws DuplicateSequenceException {
        InVmSequenceData data = new InVmSequenceData(sequenceId, strId, expirationTime, 0L, this.currentTimeInMillis());
        return this.registerSequence(new InboundSequence(data, this.inboundQueueBuilder, this));
    }

    @Override
    public String generateSequenceUID() {
        return "uuid:" + UUID.randomUUID();
    }

    @Override
    public Sequence closeSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.getSequence(sequenceId);
        sequence.close();
        return sequence;
    }

    @Override
    public Sequence getSequence(String sequenceId) throws UnknownSequenceException {
        try {
            this.internalDataAccessLock.readLock().lock();
            if (this.sequences.containsKey(sequenceId)) {
                Sequence sequence = this.sequences.get(sequenceId);
                return sequence;
            }
            throw new UnknownSequenceException(sequenceId);
        }
        finally {
            this.internalDataAccessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(String sequenceId) {
        try {
            this.internalDataAccessLock.readLock().lock();
            Sequence s = this.sequences.get(sequenceId);
            boolean bl = s != null && s.getState() != Sequence.State.TERMINATING;
            return bl;
        }
        finally {
            this.internalDataAccessLock.readLock().unlock();
        }
    }

    @Override
    public Sequence terminateSequence(String sequenceId) throws UnknownSequenceException {
        try {
            this.internalDataAccessLock.writeLock().lock();
            if (this.sequences.containsKey(sequenceId)) {
                AbstractSequence sequence = this.sequences.remove(sequenceId);
                sequence.setState(Sequence.State.TERMINATING);
                if (this.boundSequences.containsKey(sequenceId)) {
                    this.boundSequences.remove(sequenceId);
                }
                sequence.preDestroy();
                AbstractSequence abstractSequence = sequence;
                return abstractSequence;
            }
            throw new UnknownSequenceException(sequenceId);
        }
        finally {
            this.internalDataAccessLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindSequences(String referenceSequenceId, String boundSequenceId) throws UnknownSequenceException {
        try {
            this.internalDataAccessLock.writeLock().lock();
            if (!this.sequences.containsKey(referenceSequenceId)) {
                throw new UnknownSequenceException(referenceSequenceId);
            }
            if (!this.sequences.containsKey(boundSequenceId)) {
                throw new UnknownSequenceException(boundSequenceId);
            }
            this.boundSequences.put(referenceSequenceId, boundSequenceId);
        }
        finally {
            this.internalDataAccessLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence getBoundSequence(String referenceSequenceId) throws UnknownSequenceException {
        try {
            this.internalDataAccessLock.readLock().lock();
            if (!this.isValid(referenceSequenceId)) {
                throw new UnknownSequenceException(referenceSequenceId);
            }
            AbstractSequence abstractSequence = this.boundSequences.containsKey(referenceSequenceId) ? this.sequences.get(this.boundSequences.get(referenceSequenceId)) : null;
            return abstractSequence;
        }
        finally {
            this.internalDataAccessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence registerSequence(AbstractSequence sequence) throws DuplicateSequenceException {
        try {
            this.internalDataAccessLock.writeLock().lock();
            if (this.sequences.containsKey(sequence.getId())) {
                throw new DuplicateSequenceException(sequence.getId());
            }
            this.sequences.put(sequence.getId(), sequence);
            AbstractSequence abstractSequence = sequence;
            return abstractSequence;
        }
        finally {
            this.internalDataAccessLock.writeLock().unlock();
        }
    }

    @Override
    public long currentTimeInMillis() {
        return System.currentTimeMillis();
    }
}

